/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.swf;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ExeExportMode;
import com.jpexs.helpers.Helper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwfToExeExporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveFileToExe(SWF swf, ExeExportMode exeExportMode, File outFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            switch (exeExportMode) {
                case WRAPPER: {
                    InputStream exeStream = SwfToExeExporter.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/Swf2Exe.bin");
                    Helper.copyStream(exeStream, bos);
                    int width = swf.displayRect.Xmax - swf.displayRect.Xmin;
                    int height = swf.displayRect.Ymax - swf.displayRect.Ymin;
                    bos.write(width & 0xFF);
                    bos.write(width >> 8 & 0xFF);
                    bos.write(width >> 16 & 0xFF);
                    bos.write(width >> 24 & 0xFF);
                    bos.write(height & 0xFF);
                    bos.write(height >> 8 & 0xFF);
                    bos.write(height >> 16 & 0xFF);
                    bos.write(height >> 24 & 0xFF);
                    bos.write(Configuration.saveAsExeScaleMode.get());
                    break;
                }
                case PROJECTOR_WIN: 
                case PROJECTOR_MAC: 
                case PROJECTOR_LINUX: {
                    File projectorFile = Configuration.getProjectorFile(exeExportMode);
                    if (projectorFile == null) {
                        String message = "Projector not found, please place it to " + Configuration.getProjectorPath();
                        Logger.getLogger(SwfToExeExporter.class.getName()).log(Level.SEVERE, message);
                        throw new IOException(message);
                    }
                    Helper.copyStream(new FileInputStream(projectorFile), bos);
                    bos.flush();
                    break;
                }
            }
            long pos = fos.getChannel().position();
            swf.saveTo(bos);
            switch (exeExportMode) {
                case PROJECTOR_WIN: 
                case PROJECTOR_MAC: 
                case PROJECTOR_LINUX: {
                    bos.flush();
                    int swfSize = (int)(fos.getChannel().position() - pos);
                    bos.write(86);
                    bos.write(52);
                    bos.write(18);
                    bos.write(250);
                    bos.write(swfSize & 0xFF);
                    bos.write(swfSize >> 8 & 0xFF);
                    bos.write(swfSize >> 16 & 0xFF);
                    bos.write(swfSize >> 24 & 0xFF);
                    return;
                }
            }
            return;
        }
    }
}

