/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.harman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HarmanSwfEncrypt {
    private static final String GLOBAL_KEY = "Adobe AIR SDK (c) 2021 HARMAN Internation Industries Incorporated";

    private HarmanSwfEncrypt() {
    }

    private static int sum(byte[] data) {
        int s = 0;
        for (int i = 0; i < data.length; ++i) {
            s += data[i] & 0xFF;
        }
        return s;
    }

    private static long getkey(byte[] data) {
        int dsum = HarmanSwfEncrypt.sum(data);
        int dmod = dsum % GLOBAL_KEY.length();
        String s = GLOBAL_KEY.substring(dmod) + GLOBAL_KEY.substring(0, dmod);
        s = s + " EncryptSWF ";
        s = s + "" + dsum;
        long ret = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            ret *= 31L;
            ret += (long)code;
        }
        return ret & 0xFFFFFFFFL;
    }

    private static long unpack(byte[] data, int start) {
        return (long)(data[start] & 0xFF) + ((long)(data[start + 1] & 0xFF) << 8) + ((long)(data[start + 2] & 0xFF) << 16) + ((long)(data[start + 3] & 0xFF) << 24);
    }

    private static byte[] pack(long value) {
        return new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
    }

    private static byte[] readStream(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    public static byte[] encrypt(byte[] data) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return HarmanSwfEncrypt.encrypt(new ByteArrayInputStream(data));
    }

    public static byte[] encrypt(InputStream is) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] header = new byte[8];
        DataInputStream dais = new DataInputStream(is);
        dais.readFully(header);
        return HarmanSwfEncrypt.encrypt(is, header);
    }

    public static byte[] encrypt(InputStream is, byte[] header) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long key = HarmanSwfEncrypt.getkey(header);
        byte[] data = HarmanSwfEncrypt.readStream(is);
        int decryptedLength = data.length;
        long encryptedLength = (long)decryptedLength ^ key;
        byte[] encryptedLengthBytes = HarmanSwfEncrypt.pack(encryptedLength);
        int paddedLength = decryptedLength + 31 & 0xFFFFFFE0;
        byte[] dataPadded = new byte[paddedLength];
        System.arraycopy(data, 0, dataPadded, 0, data.length);
        byte[] aesIV = new byte[16];
        System.arraycopy(header, 0, aesIV, 0, header.length);
        System.arraycopy(encryptedLengthBytes, 0, aesIV, 8, 4);
        aesIV[12] = (byte)(key & 0xFFL);
        aesIV[13] = (byte)(key >> 8 & 0xFFL);
        aesIV[14] = (byte)(key >> 16 & 0xFFL);
        aesIV[15] = (byte)(key >> 24 & 0xFFL);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            aesIV[n] = (byte)(aesIV[n] ^ GLOBAL_KEY.charAt(i));
        }
        byte[] aesKey = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(aesKey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(aesIV));
        byte[] encryptedData = cipher.doFinal(dataPadded);
        header[0] = (byte)(header[0] + 32);
        baos.write(header);
        baos.write(HarmanSwfEncrypt.pack(encryptedLength));
        baos.write(encryptedData, 0, paddedLength);
        byte[] aesKeyData = new byte[32];
        for (int i = 0; i < 32; i += 4) {
            long value = HarmanSwfEncrypt.unpack(aesKey, i);
            value = (i & 4) == 4 ? (value += key) : (value -= key);
            aesKeyData[i] = (byte)(value & 0xFFL);
            aesKeyData[i + 1] = (byte)(value >> 8 & 0xFFL);
            aesKeyData[i + 2] = (byte)(value >> 16 & 0xFFL);
            aesKeyData[i + 3] = (byte)(value >> 24 & 0xFFL);
        }
        baos.write(aesKeyData);
        return baos.toByteArray();
    }

    public static byte[] decrypt(byte[] data) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return HarmanSwfEncrypt.decrypt(new ByteArrayInputStream(data));
    }

    public static byte[] decrypt(InputStream is) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        DataInputStream dais = new DataInputStream(is);
        byte[] header = new byte[8];
        dais.readFully(header);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] dec = HarmanSwfEncrypt.decrypt(is, header);
        baos.write(header);
        baos.write(dec);
        return baos.toByteArray();
    }

    public static byte[] decrypt(InputStream is, byte[] header) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        header[0] = (byte)(header[0] - 32);
        long key = HarmanSwfEncrypt.getkey(header);
        DataInputStream dais = new DataInputStream(is);
        byte[] encryptedLengthBytes = new byte[4];
        dais.readFully(encryptedLengthBytes);
        long encryptedLength = HarmanSwfEncrypt.unpack(encryptedLengthBytes, 0);
        int decryptedLength = (int)(encryptedLength ^ key);
        int paddedLength = decryptedLength + 31 & 0xFFFFFFE0;
        byte[] aesIV = new byte[16];
        System.arraycopy(header, 0, aesIV, 0, header.length);
        System.arraycopy(encryptedLengthBytes, 0, aesIV, 8, 4);
        aesIV[12] = (byte)(key & 0xFFL);
        aesIV[13] = (byte)(key >> 8 & 0xFFL);
        aesIV[14] = (byte)(key >> 16 & 0xFFL);
        aesIV[15] = (byte)(key >> 24 & 0xFFL);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            aesIV[n] = (byte)(aesIV[n] ^ GLOBAL_KEY.charAt(i));
        }
        byte[] aesKey = new byte[32];
        byte[] data = new byte[paddedLength];
        dais.readFully(data);
        byte[] aesKeyData = new byte[32];
        dais.readFully(aesKeyData);
        for (int i = 0; i < 32; i += 4) {
            long value = HarmanSwfEncrypt.unpack(aesKeyData, i);
            value = (i & 4) == 4 ? (value -= key) : (value += key);
            aesKey[i] = (byte)(value & 0xFFL);
            aesKey[i + 1] = (byte)(value >> 8 & 0xFFL);
            aesKey[i + 2] = (byte)(value >> 16 & 0xFFL);
            aesKey[i + 3] = (byte)(value >> 24 & 0xFFL);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(aesIV));
        byte[] decryptedData = cipher.doFinal(data);
        return Arrays.copyOfRange(decryptedData, 0, decryptedLength);
    }

    public static void main(String[] args) throws Exception {
        byte[] data = new byte[]{67, 87, 83, 50, 1, 2, 3, 4, 65, 66, 67, 13, 10};
        byte[] encrypted = HarmanSwfEncrypt.encrypt(data);
        byte[] decrypted = HarmanSwfEncrypt.decrypt(encrypted);
        if (!Arrays.equals(data, decrypted)) {
            throw new RuntimeException("Cannot encrypt/decrypt");
        }
    }
}

