/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.helpers.utf8.Utf8OutputStreamWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamTextWriter
extends GraphTextWriter
implements AutoCloseable {
    private final Writer writer;
    private boolean newLine = true;
    private int indent;
    private int writtenBytes;

    public StreamTextWriter(CodeFormatting formatting, OutputStream os) {
        super(formatting);
        this.writer = new Utf8OutputStreamWriter(new BufferedOutputStream(os));
    }

    @Override
    public GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue, HighlightData data) {
        this.addLineLength(text.length());
        this.writeToOutputStream(text);
        return this;
    }

    @Override
    public GraphTextWriter appendWithData(String str, HighlightData data) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StreamTextWriter append(String str) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StreamTextWriter append(String str, long offset, long fileOffset) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StreamTextWriter appendNoHilight(int i) {
        this.addLineLength(Integer.toString(i).length());
        this.writeToOutputStream(Integer.toString(i));
        return this;
    }

    @Override
    public StreamTextWriter appendNoHilight(String str) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StreamTextWriter indent() {
        ++this.indent;
        return this;
    }

    @Override
    public StreamTextWriter unindent() {
        --this.indent;
        return this;
    }

    @Override
    public StreamTextWriter newLine() {
        this.writeToOutputStream(this.formatting.newLineChars);
        this.newLine = true;
        this.lineLength = 0;
        return this;
    }

    @Override
    public int getLength() {
        return this.writtenBytes;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    private void writeToOutputStream(String str) {
        if (this.newLine) {
            this.newLine = false;
            this.appendIndent();
        }
        try {
            this.writer.write(str);
            this.writtenBytes += str.length();
        }
        catch (IOException ex) {
            Logger.getLogger(StreamTextWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.writeToOutputStream(this.formatting.indentString);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

