/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;

public class StringBuilderTextWriter
extends GraphTextWriter {
    private final StringBuilder writer;
    private boolean newLine = true;
    private int indent;
    private int writtenBytes;

    public StringBuilderTextWriter(CodeFormatting formatting, StringBuilder writer) {
        super(formatting);
        this.writer = writer;
    }

    @Override
    public GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue, HighlightData data) {
        this.addLineLength(text.length());
        this.writeToOutputStream(text);
        return this;
    }

    @Override
    public GraphTextWriter appendWithData(String str, HighlightData data) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StringBuilderTextWriter append(String str) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StringBuilderTextWriter append(String str, long offset, long fileOffset) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StringBuilderTextWriter appendNoHilight(int i) {
        this.addLineLength(Integer.toString(i).length());
        this.writeToOutputStream(Integer.toString(i));
        return this;
    }

    @Override
    public StringBuilderTextWriter appendNoHilight(String str) {
        this.addLineLength(str.length());
        this.writeToOutputStream(str);
        return this;
    }

    @Override
    public StringBuilderTextWriter indent() {
        ++this.indent;
        return this;
    }

    @Override
    public StringBuilderTextWriter unindent() {
        --this.indent;
        return this;
    }

    @Override
    public StringBuilderTextWriter newLine() {
        this.writeToOutputStream(this.formatting.newLineChars);
        this.newLine = true;
        this.lineLength = 0;
        return this;
    }

    @Override
    public int getLength() {
        return this.writtenBytes;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    private void writeToOutputStream(String str) {
        if (this.newLine) {
            this.newLine = false;
            this.appendIndent();
        }
        this.writer.append(str);
        this.writtenBytes += str.length();
    }

    private void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.writeToOutputStream(this.formatting.indentString);
        }
    }
}

