/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyArrayFieldType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;

public class IggyHeader
implements StructureInterface {
    public static int STRUCT_SIZE = 32;
    public static long MAGIC = -318085303L;
    @IggyFieldType(value=DataType.uint32_t)
    private long magic = MAGIC;
    @IggyFieldType(value=DataType.uint32_t)
    private long version;
    @IggyFieldType(value=DataType.uint8_t)
    private int platform1;
    @IggyFieldType(value=DataType.uint8_t)
    private int platform2;
    @IggyFieldType(value=DataType.uint8_t)
    private int platform3;
    @IggyFieldType(value=DataType.uint8_t)
    private int platform4;
    @IggyFieldType(value=DataType.uint32_t)
    private long unk_0C;
    @IggyArrayFieldType(value=DataType.uint8_t, count=12)
    private byte[] reserved;
    @IggyFieldType(value=DataType.uint32_t)
    private long numSubfiles;

    public IggyHeader(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    public IggyHeader(long version, int platform1, int platform2, int platform3, int platform4, long unk_0C, byte[] reserved, long num_subfiles) {
        this.version = version;
        this.platform1 = platform1;
        this.platform2 = platform2;
        this.platform3 = platform3;
        this.platform4 = platform4;
        this.unk_0C = unk_0C;
        this.reserved = reserved;
        this.numSubfiles = num_subfiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("version: ").append(this.version).append(", ");
        sb.append("platform: ").append(this.platform1).append(" ").append(this.platform2).append(" ").append(this.platform3).append(" ").append(this.platform4).append(", ");
        sb.append("unk_0C: ").append(String.format("%08X", this.unk_0C)).append(", ");
        sb.append("reserved: 12 bytes").append(", ");
        sb.append("num_subfiles: ").append(this.numSubfiles);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface stream) throws IOException {
        this.magic = stream.readUI32();
        if (this.magic != MAGIC) {
            throw new IOException("Invalid Iggy file");
        }
        this.version = stream.readUI32();
        this.platform1 = stream.readUI8();
        this.platform2 = stream.readUI8();
        this.platform3 = stream.readUI8();
        this.platform4 = stream.readUI8();
        this.unk_0C = stream.readUI32();
        this.reserved = stream.readBytes(12);
        this.numSubfiles = stream.readUI32();
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        s.writeUI32(this.magic);
        s.writeUI32(this.version);
        s.writeUI8(this.platform1);
        s.writeUI8(this.platform2);
        s.writeUI8(this.platform3);
        s.writeUI8(this.platform4);
        s.writeUI32(this.unk_0C);
        s.writeBytes(this.reserved);
        s.writeUI32(this.numSubfiles);
    }

    public boolean is64() {
        return this.platform2 == 64;
    }

    public long getMagic() {
        return this.magic;
    }

    public long getVersion() {
        return this.version;
    }

    public int getPlatform1() {
        return this.platform1;
    }

    public int getPlatform2() {
        return this.platform2;
    }

    public int getPlatform3() {
        return this.platform3;
    }

    public int getPlatform4() {
        return this.platform4;
    }

    public long getUnk_0C() {
        return this.unk_0C;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public long getNumSubfiles() {
        return this.numSubfiles;
    }
}

