/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.IggyShapeNode;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class IggyShape
implements StructureInterface {
    public static final int STRUCT_SIZE = 64;
    private static Logger LOGGER = Logger.getLogger(IggyShape.class.getName());
    @IggyFieldType(value=DataType.float_t)
    float minx;
    @IggyFieldType(value=DataType.float_t)
    float miny;
    @IggyFieldType(value=DataType.float_t)
    float maxx;
    @IggyFieldType(value=DataType.float_t)
    float maxy;
    @IggyFieldType(value=DataType.uint64_t)
    long unk;
    @IggyFieldType(value=DataType.uint64_t)
    long count;
    @IggyFieldType(value=DataType.uint64_t)
    long one;
    @IggyFieldType(value=DataType.uint64_t)
    long one2;
    @IggyFieldType(value=DataType.uint64_t)
    long one3;
    @IggyFieldType(value=DataType.uint32_t)
    long one4;
    @IggyFieldType(value=DataType.uint32_t)
    long two1;
    List<IggyShapeNode> nodes;

    public float getBearingX() {
        return this.minx;
    }

    public float getBearingY() {
        return this.miny;
    }

    public float getWidth() {
        return this.maxx - this.minx;
    }

    public float getHeight() {
        return this.maxy - this.miny;
    }

    public IggyShape(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    public IggyShape(float minx, float miny, float maxx, float maxy, List<IggyShapeNode> nodes) {
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
        this.unk = 0L;
        this.one = 1L;
        this.one2 = 1L;
        this.one3 = 1L;
        this.one4 = 1L;
        this.two1 = 2L;
        this.count = nodes.size();
        this.nodes = nodes;
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        this.minx = s.readFloat();
        this.miny = s.readFloat();
        this.maxx = s.readFloat();
        this.maxy = s.readFloat();
        this.unk = s.readUI64();
        this.count = s.readUI64();
        this.one = s.readUI64();
        this.one2 = s.readUI64();
        this.one3 = s.readUI64();
        this.one4 = s.readUI32();
        this.two1 = s.readUI32();
        if (this.one != 1L || this.one2 != 1L || this.one3 != 1L || this.one4 != 1L || this.two1 != 2L) {
            LOGGER.fine(String.format("Unique header at one: %d, one2: %d, one3: %d, one4: %d, two1: %d\n", this.one, this.one2, this.one3, this.one4, this.two1));
        }
        this.nodes = new ArrayList<IggyShapeNode>();
        int i = 0;
        while ((long)i < this.count) {
            this.nodes.add(new IggyShapeNode(s, i == 0));
            ++i;
        }
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        s.getIndexing().writeConstLength(5);
        s.writeFloat(this.minx);
        s.writeFloat(this.miny);
        s.writeFloat(this.maxx);
        s.writeFloat(this.maxy);
        s.writeUI64(this.unk);
        s.writeUI64(this.count);
        s.writeUI64(this.one);
        s.writeUI64(this.one2);
        s.writeUI64(this.one3);
        s.writeUI32(this.one4);
        s.writeUI32(this.two1);
        s.getIndexing().writeConstLengthArray(0, this.nodes.size());
        for (IggyShapeNode node : this.nodes) {
            node.writeToDataStream(s);
        }
    }

    public float getMinx() {
        return this.minx;
    }

    public float getMiny() {
        return this.miny;
    }

    public float getMaxx() {
        return this.maxx;
    }

    public float getMaxy() {
        return this.maxy;
    }

    public long getUnk() {
        return this.unk;
    }

    public long getOne() {
        return this.one;
    }

    public long getOne2() {
        return this.one2;
    }

    public long getOne3() {
        return this.one3;
    }

    public long getOne4() {
        return this.one4;
    }

    public long getTwo1() {
        return this.two1;
    }

    public List<IggyShapeNode> getNodes() {
        return this.nodes;
    }
}

