/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ActionScript3Parser;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.graph.CompilationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FFDecAs3ScriptReplacer
implements As3ScriptReplacerInterface {
    private boolean air;

    public FFDecAs3ScriptReplacer(boolean air) {
        this.air = air;
    }

    @Override
    public void replaceScript(ScriptPack pack, String text, List<SWF> dependencies) throws As3ScriptReplaceException, IOException, InterruptedException {
        ABC abc = pack.abc;
        SWF swf = pack.abc.getSwf();
        String scriptName = pack.getPathScriptName() + ".as";
        int oldIndex = pack.scriptIndex;
        int newIndex = abc.script_info.size();
        AbcIndexing abcIndex = swf.getAbcIndex();
        try {
            ScriptInfo si = abc.script_info.get(oldIndex);
            pack.delete(abc, true);
            int newClassIndex = abc.instance_info.size();
            for (int t : pack.traitIndices) {
                if (!(si.traits.traits.get(t) instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)si.traits.traits.get(t);
                newClassIndex = tc.class_info + 1;
            }
            ArrayList<ABC> otherAbcs = new ArrayList<ABC>(pack.allABCs);
            otherAbcs.remove(abc);
            abcIndex.selectAbc(abc);
            abcIndex.refreshAbc(abc);
            ActionScript3Parser.compile(text, abc, abcIndex, scriptName, newClassIndex, oldIndex, this.air, swf.getDocumentClass());
            if (pack.isSimple) {
                abc.script_info.set(oldIndex, abc.script_info.get(newIndex));
                abc.script_info.remove(newIndex);
            }
            abc.script_info.get(oldIndex).setModified(true);
            abc.pack();
            ((Tag)((Object)abc.parentTag)).setModified(true);
        }
        catch (AVM2ParseException ex) {
            pack.delete(abc, false);
            abcIndex.refreshAbc(abc);
            throw new As3ScriptReplaceException(new As3ScriptReplaceExceptionItem(null, ex.text, (int)ex.line));
        }
        catch (CompilationException ex) {
            pack.delete(abc, false);
            abcIndex.refreshAbc(abc);
            throw new As3ScriptReplaceException(new As3ScriptReplaceExceptionItem(null, ex.text, ex.line));
        }
    }

    @Override
    public boolean isAvailable() {
        File swc = this.air ? Configuration.getAirSWC() : Configuration.getPlayerSWC();
        return swc != null && swc.exists();
    }

    public boolean isAir() {
        return this.air;
    }

    @Override
    public void initReplacement(ScriptPack pack, List<SWF> dependencies) {
    }

    @Override
    public void deinitReplacement(ScriptPack pack) {
    }
}

