/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg.css;

import com.jpexs.decompiler.flash.importers.svg.css.CssLexer;
import com.jpexs.decompiler.flash.importers.svg.css.CssParseException;
import com.jpexs.decompiler.flash.importers.svg.css.CssParsedSymbol;
import com.jpexs.decompiler.flash.importers.svg.css.CssSymbolType;
import com.jpexs.helpers.Reference;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CssParser {
    private final CssLexer lexer;
    private final String s;
    private final List<String> selectors = new ArrayList<String>();
    private final List<String> declarations = new ArrayList<String>();
    private final List<List<String>> propNames = new ArrayList<List<String>>();
    private final List<List<String>> propValues = new ArrayList<List<String>>();
    private final List<Integer> specificities = new ArrayList<Integer>();

    public CssParser(String s) {
        this.s = s;
        this.lexer = new CssLexer(new StringReader(s));
    }

    public void stylesheet() throws IOException, CssParseException {
        CssParsedSymbol symb = this.lex();
        if (symb.type == CssSymbolType.CHARSET_SYM) {
            this.expect(CssSymbolType.STRING);
            this.expect(";");
            symb = this.lex();
        }
        while (symb.isType(CssSymbolType.S, CssSymbolType.CDO, CssSymbolType.CDC)) {
            symb = this.lex();
        }
        while (symb.type == CssSymbolType.IMPORT_SYM) {
            this.sstar();
            this.expect(CssSymbolType.STRING, CssSymbolType.URI);
            this.sstar();
            symb = this.lex();
            if (!symb.isType(";")) {
                this.lexer.pushback(symb);
                this.media_list();
                this.expect(";");
            }
            this.sstar();
            symb = this.lex();
            while (symb.isType(CssSymbolType.CDO, CssSymbolType.CDC)) {
                this.sstar();
                symb = this.lex();
            }
        }
        while (symb.type != CssSymbolType.EOF) {
            if (symb.type == CssSymbolType.MEDIA_SYM) {
                this.lexer.pushback(symb);
                this.media();
            } else if (symb.type == CssSymbolType.PAGE_SYM) {
                this.lexer.pushback(symb);
                ArrayList<String> propNames = new ArrayList<String>();
                ArrayList<String> propValues = new ArrayList<String>();
                this.page(propNames, propValues);
            } else {
                this.lexer.pushback(symb);
                if (!this.ruleset()) break;
            }
            symb = this.lex();
            while (symb.isType(CssSymbolType.CDO, CssSymbolType.CDC)) {
                this.sstar();
                symb = this.lex();
            }
        }
    }

    private boolean ruleset() throws IOException, CssParseException {
        int posSelectorStart = this.lexer.getPos();
        int specificity = this.selector();
        if (specificity == -1) {
            return false;
        }
        CssParsedSymbol symb = this.lex();
        while (symb.isType(",")) {
            this.sstar();
            specificity += this.selector();
            symb = this.lex();
        }
        this.expect(symb, "{");
        int posSelectorEnd = this.lexer.getPos() - 1;
        String selectorStr = this.s.substring(posSelectorStart, posSelectorEnd).trim();
        this.selectors.add(selectorStr);
        this.specificities.add(specificity);
        int declarationsStart = this.lexer.getPos();
        Reference<String> propName = new Reference<String>("");
        Reference<String> propValue = new Reference<String>("");
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propValues = new ArrayList<String>();
        this.sstar();
        symb = this.lex();
        if (symb.type == CssSymbolType.IDENT) {
            this.lexer.pushback(symb);
            this.declaration(propName, propValue);
            propNames.add(propName.getVal());
            propValues.add(propValue.getVal());
            symb = this.lex();
        }
        while (symb.isType(";")) {
            this.sstar();
            symb = this.lex();
            if (symb.type != CssSymbolType.IDENT) continue;
            this.lexer.pushback(symb);
            this.declaration(propName, propValue);
            propNames.add(propName.getVal());
            propValues.add(propValue.getVal());
            symb = this.lex();
        }
        this.expect(symb, "}");
        int declarationsEnd = this.lexer.getPos() - 1;
        String declaration = this.s.substring(declarationsStart, declarationsEnd);
        this.declarations.add(declaration);
        this.propNames.add(propNames);
        this.propValues.add(propValues);
        this.sstar();
        return true;
    }

    private int selector() throws IOException, CssParseException {
        int specificity = this.simple_selector();
        if (specificity == -1) {
            return -1;
        }
        CssParsedSymbol symb = this.lex();
        if (symb.type == CssSymbolType.S) {
            while (symb.type == CssSymbolType.S) {
                symb = this.lex();
            }
            if (symb.isType("+", ">")) {
                this.sstar();
                specificity += this.selector();
            } else {
                this.lexer.pushback(symb);
                if (symb.isType("*", ".", "[", ":") || symb.isType(CssSymbolType.IDENT, CssSymbolType.HASH)) {
                    specificity += this.selector();
                }
            }
        } else if (symb.isType("+", ">")) {
            this.sstar();
            specificity += this.selector();
        } else {
            this.lexer.pushback(symb);
        }
        return specificity;
    }

    private int simple_selector() throws IOException, CssParseException {
        CssParsedSymbol symb = this.lex();
        int specificity = 0;
        if (symb.isType(CssSymbolType.IDENT) || symb.isType("*")) {
            if (symb.isType(CssSymbolType.IDENT)) {
                ++specificity;
            }
            while (true) {
                symb = this.lex();
                if (symb.type == CssSymbolType.HASH) {
                    specificity += 100;
                    continue;
                }
                if (symb.isType(".")) {
                    this.expect(CssSymbolType.IDENT);
                    specificity += 10;
                    continue;
                }
                if (symb.isType("[")) {
                    this.lexer.pushback(symb);
                    this.attrib();
                    specificity += 10;
                    continue;
                }
                if (!symb.isType(":")) break;
                this.lexer.pushback(symb);
                this.pseudo();
                specificity += 10;
            }
            this.lexer.pushback(symb);
        } else {
            int count = 0;
            while (true) {
                if (symb.type == CssSymbolType.HASH) {
                    specificity += 100;
                    ++count;
                } else if (symb.isType(".")) {
                    this.expect(CssSymbolType.IDENT);
                    specificity += 10;
                    ++count;
                } else if (symb.isType("[")) {
                    this.lexer.pushback(symb);
                    this.attrib();
                    specificity += 10;
                    ++count;
                } else if (symb.isType(":")) {
                    this.lexer.pushback(symb);
                    this.pseudo();
                    specificity += 10;
                    ++count;
                } else {
                    if (count != 0) break;
                    this.lexer.pushback(symb);
                    return -1;
                }
                symb = this.lex();
            }
            this.lexer.pushback(symb);
        }
        return specificity;
    }

    private void pseudo() throws IOException, CssParseException {
        this.expect(":");
        CssParsedSymbol symb = this.lex();
        if (symb.type != CssSymbolType.IDENT && symb.type == CssSymbolType.FUNCTION) {
            this.sstar();
            symb = this.lex();
            if (symb.type == CssSymbolType.IDENT) {
                this.sstar();
                symb = this.lex();
            }
            this.expect(symb, ")");
        }
    }

    private void attrib() throws IOException, CssParseException {
        this.expect("[");
        this.sstar();
        this.expect(CssSymbolType.IDENT);
        this.sstar();
        CssParsedSymbol symb = this.lex();
        if (symb.isType(CssSymbolType.INCLUDES, CssSymbolType.DASHMATCH) || symb.isType("=")) {
            this.sstar();
            this.expect(CssSymbolType.IDENT, CssSymbolType.STRING);
            this.sstar();
            symb = this.lex();
        }
        this.expect(symb, "]");
    }

    private void page(List<String> propNames, List<String> propValues) throws IOException, CssParseException {
        this.expect(CssSymbolType.PAGE_SYM);
        this.sstar();
        CssParsedSymbol symb = this.lex();
        if (symb.isType(":")) {
            this.expect(CssSymbolType.IDENT);
            this.sstar();
            symb = this.lex();
        }
        this.expect(symb, "{");
        this.sstar();
        Reference<String> propName = new Reference<String>("");
        Reference<String> propValue = new Reference<String>("");
        this.declaration(propName, propValue);
        propNames.add(propName.getVal());
        propValues.add(propValue.getVal());
        symb = this.lex();
        while (symb.isType(";")) {
            this.sstar();
            symb = this.lex();
            if (symb.isType(";", "}")) continue;
            this.declaration(propName, propValue);
            propNames.add(propName.getVal());
            propValues.add(propValue.getVal());
        }
        this.expect(symb, "}");
    }

    private void declaration(Reference<String> propName, Reference<String> propValue) throws IOException, CssParseException {
        CssParsedSymbol symb = this.lex();
        this.expect(symb, CssSymbolType.IDENT);
        propName.setVal(symb.value);
        this.sstar();
        this.expect(":");
        this.sstar();
        this.lexer.startBuffer();
        this.expr();
        symb = this.lex();
        if (symb.type == CssSymbolType.IMPORTANT_SYM) {
            this.sstar();
        } else {
            this.lexer.pushback(symb);
        }
        propValue.setVal(this.lexer.getAndClearBuffer());
    }

    private void expr() throws IOException, CssParseException {
        this.term(true);
        while (true) {
            CssParsedSymbol symb = this.lex();
            if (symb.isType("/", ",")) {
                this.sstar();
                this.term(true);
                continue;
            }
            this.lexer.pushback(symb);
            if (!this.term(false)) break;
        }
    }

    private boolean term(boolean required) throws IOException, CssParseException {
        CssParsedSymbol symb = this.lex();
        if (symb.isType("-", "+")) {
            symb = this.lex();
        }
        if (symb.isType(CssSymbolType.NUMBER, CssSymbolType.PERCENTAGE, CssSymbolType.LENGTH, CssSymbolType.EMS, CssSymbolType.EXS, CssSymbolType.ANGLE, CssSymbolType.TIME, CssSymbolType.FREQ)) {
            this.sstar();
        } else if (symb.isType(CssSymbolType.STRING, CssSymbolType.IDENT, CssSymbolType.URI)) {
            this.sstar();
        } else if (symb.type == CssSymbolType.HASH) {
            this.sstar();
        } else if (symb.type == CssSymbolType.FUNCTION) {
            this.sstar();
            this.expr();
            this.expect(")");
            this.sstar();
        } else {
            this.lexer.pushback(symb);
            if (required) {
                throw new CssParseException();
            }
            return false;
        }
        return true;
    }

    private void media() throws IOException, CssParseException {
        this.expect(CssSymbolType.MEDIA_SYM);
        this.sstar();
        this.media_list();
        this.expect("{");
        this.sstar();
        CssParsedSymbol symb = this.lex();
        while (!symb.isType("}") && this.ruleset()) {
            symb = this.lex();
        }
        this.sstar();
    }

    private void medium() throws IOException, CssParseException {
        this.expect(CssSymbolType.IDENT);
        this.sstar();
    }

    private void media_list() throws IOException, CssParseException {
        this.medium();
        CssParsedSymbol symb = this.lex();
        while (symb.isType(",")) {
            this.sstar();
            this.medium();
        }
        this.lexer.pushback(symb);
    }

    private void sstar() throws IOException {
        CssParsedSymbol symb = this.lex();
        while (symb.type == CssSymbolType.S) {
            symb = this.lex();
        }
        this.lexer.pushback(symb);
    }

    private CssParsedSymbol lex() throws IOException {
        CssParsedSymbol v = this.lexer.lex();
        return v;
    }

    private void expect(String s) throws IOException, CssParseException {
        CssParsedSymbol symb = this.lex();
        if (symb.type != CssSymbolType.OTHER) {
            throw new CssParseException(s + " expected but " + symb + " found");
        }
        if (!s.equals(symb.value)) {
            throw new CssParseException(s + " expected but " + symb + " found");
        }
    }

    private void expect(CssParsedSymbol symb, String s) throws IOException, CssParseException {
        if (symb.type != CssSymbolType.OTHER) {
            throw new CssParseException(s + " expected but " + symb + " found");
        }
        if (!s.equals(symb.value)) {
            throw new CssParseException(s + " expected but " + symb.value + " found");
        }
    }

    private void expect(CssParsedSymbol symb, CssSymbolType ... types) throws IOException, CssParseException {
        ArrayList<String> toPrint = new ArrayList<String>();
        for (CssSymbolType type : types) {
            toPrint.add(type.toString());
            if (symb.type != type) continue;
            return;
        }
        throw new CssParseException(String.join((CharSequence)",", toPrint) + " expected but " + symb + " found");
    }

    private void expect(CssSymbolType ... types) throws IOException, CssParseException {
        ArrayList<String> toPrint = new ArrayList<String>();
        CssParsedSymbol symb = this.lex();
        for (CssSymbolType type : types) {
            toPrint.add(type.toString());
            if (symb.type != type) continue;
            return;
        }
        throw new CssParseException(String.join((CharSequence)",", toPrint) + " expected but " + symb + " found");
    }

    public int getCountRulesets() {
        return this.declarations.size();
    }

    public String getSelector(int index) {
        return this.selectors.get(index);
    }

    public String getDeclarations(int index) {
        return this.declarations.get(index);
    }

    public int getPropertyCount(int index) {
        return this.propNames.get(index).size();
    }

    public String getPropertyName(int ruleSetIndex, int propertyIndex) {
        return this.propNames.get(ruleSetIndex).get(propertyIndex);
    }

    public String getPropertyValue(int ruleSetIndex, int propertyIndex) {
        return this.propValues.get(ruleSetIndex).get(propertyIndex);
    }

    public int getSpecificity(int index) {
        return this.specificities.get(index);
    }
}

