/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class BezierUtils {
    private static final int MAX_DEPTH = 64;
    private static final double[] Z_QUAD = new double[]{1.0, 0.6666666666666666, 0.3333333333333333, 0.3333333333333333, 0.6666666666666666, 1.0};
    private static final double EPSILON = 1.0 * Math.pow(2.0, -65.0);

    public Point2D pointAt(double t, Point2D p0, Point2D p1, Point2D p2) {
        double xt = (1.0 - t) * (1.0 - t) * p0.getX() + 2.0 * (1.0 - t) * t * p1.getX() + t * t * p2.getX();
        double yt = (1.0 - t) * (1.0 - t) * p0.getY() + 2.0 * (1.0 - t) * t * p1.getY() + t * t * p2.getY();
        return new Point2D.Double(xt, yt);
    }

    public double closestPointToBezier(Point2D _p, Point2D p0, Point2D p1, Point2D p2) {
        double dMinimum;
        double tMinimum;
        Point2D p = p0;
        double deltaX = p.getX() - _p.getX();
        double deltaY = p.getY() - _p.getY();
        double d0 = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        p = p2;
        deltaX = p.getX() - _p.getX();
        deltaY = p.getY() - _p.getY();
        double d1 = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        int n = 2;
        ArrayList<Point2D> v = new ArrayList<Point2D>();
        v.add(p0);
        v.add(p1);
        v.add(p2);
        List<Point2D> w = this.toBezierForm(_p, v);
        List<Double> roots = this.findRoots(w, 2 * n - 1, 0);
        if (d0 < d1) {
            tMinimum = 0.0;
            dMinimum = d0;
        } else {
            tMinimum = 1.0;
            dMinimum = d1;
        }
        for (int i = 0; i < roots.size(); ++i) {
            double d;
            double t = roots.get(i);
            if (!(t >= 0.0) || !(t <= 1.0) || !((d = Math.sqrt((deltaX = (p = this.pointAt(t, p0, p1, p2)).getX() - _p.getX()) * deltaX + (deltaY = p.getY() - _p.getY()) * deltaY)) < dMinimum)) continue;
            tMinimum = t;
            dMinimum = d;
        }
        return tMinimum;
    }

    private List<Point2D> toBezierForm(Point2D _p, List<Point2D> _v) {
        Point2D v;
        ArrayList<Point2D.Double> c = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> d = new ArrayList<Point2D.Double>();
        ArrayList<Point2D> w = new ArrayList<Point2D>();
        int n = _v.size() - 1;
        int degree = 2 * n - 1;
        double pX = _p.getX();
        double pY = _p.getY();
        for (int i = 0; i <= n; ++i) {
            v = _v.get(i);
            c.add(new Point2D.Double(v.getX() - pX, v.getY() - pY));
        }
        double s = n;
        for (int i = 0; i <= n - 1; ++i) {
            v = _v.get(i);
            Point2D v1 = _v.get(i + 1);
            d.add(new Point2D.Double(s * (v1.getX() - v.getX()), s * (v1.getY() - v.getY())));
        }
        ArrayList<Double> cd = new ArrayList<Double>();
        for (int row = 0; row <= n - 1; ++row) {
            Point2D di = (Point2D)d.get(row);
            double dX = di.getX();
            double dY = di.getY();
            for (int col = 0; col <= n; ++col) {
                int k = this.getLinearIndex(n + 1, row, col);
                cd.add(dX * ((Point2D)c.get(col)).getX() + dY * ((Point2D)c.get(col)).getY());
            }
        }
        double dInv = 1.0 / (double)degree;
        for (int i = 0; i <= degree; ++i) {
            w.add(new Point2D.Double((double)i * dInv, 0.0));
        }
        double[] z = Z_QUAD;
        int m = n - 1;
        for (int k = 0; k <= n + m; ++k) {
            int lb = Math.max(0, k - m);
            int ub = Math.min(k, n);
            for (int i = lb; i <= ub; ++i) {
                int j = k - i;
                Point2D p = (Point2D)w.get(i + j);
                int index = this.getLinearIndex(n + 1, j, i);
                p.setLocation(p.getX(), p.getY() + (Double)cd.get(index) * z[index]);
                w.set(i + j, p);
            }
        }
        return w;
    }

    private int crossingCount(List<Point2D> _v, int _degree) {
        int sign;
        int nCrossings = 0;
        int oldSign = sign = _v.get(0).getY() < 0.0 ? -1 : 1;
        for (int i = 1; i <= _degree; ++i) {
            int n = sign = _v.get(i).getY() < 0.0 ? -1 : 1;
            if (sign != oldSign) {
                ++nCrossings;
            }
            oldSign = sign;
        }
        return nCrossings;
    }

    private int getLinearIndex(int _n, int _row, int _col) {
        return _row * _n + _col;
    }

    public void subdivide(List<Point2D> _c, double _t, List<Point2D> _left, List<Point2D> _right) {
        int index;
        int j;
        int degree = _c.size() - 1;
        int n = degree + 1;
        ArrayList<Point2D> p = new ArrayList<Point2D>(_c);
        double t1 = 1.0 - _t;
        for (int i = 1; i <= degree; ++i) {
            for (int j2 = 0; j2 <= degree - i; ++j2) {
                Point2D.Double vertex = new Point2D.Double();
                int ij = this.getLinearIndex(n, i, j2);
                int im1j = this.getLinearIndex(n, i - 1, j2);
                int im1jp1 = this.getLinearIndex(n, i - 1, j2 + 1);
                ((Point2D)vertex).setLocation(t1 * ((Point2D)p.get(im1j)).getX() + _t * ((Point2D)p.get(im1jp1)).getX(), t1 * ((Point2D)p.get(im1j)).getY() + _t * ((Point2D)p.get(im1jp1)).getY());
                while (ij >= p.size()) {
                    p.add(new Point2D.Double(0.0, 0.0));
                }
                p.set(ij, vertex);
            }
        }
        for (j = 0; j <= degree; ++j) {
            index = this.getLinearIndex(n, j, 0);
            _left.add((Point2D)p.get(index));
        }
        for (j = 0; j <= degree; ++j) {
            index = this.getLinearIndex(n, degree - j, j);
            _right.add((Point2D)p.get(index));
        }
    }

    private boolean isControlPolygonLinear(List<Point2D> _v, int _degree) {
        double a = _v.get(0).getY() - _v.get(_degree).getY();
        double b = _v.get(_degree).getX() - _v.get(0).getX();
        double c = _v.get(0).getX() * _v.get(_degree).getY() - _v.get(_degree).getX() * _v.get(0).getY();
        double abSquared = a * a + b * b;
        ArrayList<Double> distance = new ArrayList<Double>();
        distance.add(0.0);
        for (int i = 1; i < _degree; ++i) {
            distance.add(a * _v.get(i).getX() + b * _v.get(i).getY() + c);
            if ((Double)distance.get(i) > 0.0) {
                distance.set(i, (Double)distance.get(i) * (Double)distance.get(i) / abSquared);
            }
            if (!((Double)distance.get(i) < 0.0)) continue;
            distance.set(i, -((Double)distance.get(i) * (Double)distance.get(i) / abSquared));
        }
        double maxDistanceAbove = 0.0;
        double maxDistanceBelow = 0.0;
        for (int i = 1; i < _degree; ++i) {
            if ((Double)distance.get(i) < 0.0) {
                maxDistanceBelow = Math.min(maxDistanceBelow, (Double)distance.get(i));
            }
            if (!((Double)distance.get(i) > 0.0)) continue;
            maxDistanceAbove = Math.max(maxDistanceAbove, (Double)distance.get(i));
        }
        double a1 = 0.0;
        double b1 = 1.0;
        double c1 = 0.0;
        double a2 = a;
        double b2 = b;
        double c2 = c + maxDistanceAbove;
        double det = a1 * b2 - a2 * b1;
        double dInv = 1.0 / det;
        double intercept1 = (b1 * c2 - b2 * c1) * dInv;
        a2 = a;
        b2 = b;
        c2 = c + maxDistanceBelow;
        double intercept2 = (b1 * c2 - b2 * c1) * dInv;
        double leftIntercept = Math.min(intercept1, intercept2);
        double rightIntercept = Math.max(intercept1, intercept2);
        double error = 0.5 * (rightIntercept - leftIntercept);
        return error < EPSILON;
    }

    private List<Double> findRoots(List<Point2D> _w, int _degree, int _depth) {
        ArrayList<Double> t = new ArrayList<Double>();
        int m = 2 * _degree - 1;
        switch (this.crossingCount(_w, _degree)) {
            case 0: {
                return new ArrayList<Double>();
            }
            case 1: {
                if (_depth >= 64) {
                    t.add(0.5 * (_w.get(0).getX() + _w.get(m).getX()));
                    return t;
                }
                if (!this.isControlPolygonLinear(_w, _degree)) break;
                t.add(this.computeXIntercept(_w, _degree));
                return t;
            }
        }
        ArrayList<Point2D> left = new ArrayList<Point2D>();
        ArrayList<Point2D> right = new ArrayList<Point2D>();
        this.subdivide(_w, 0.5, left, right);
        List<Double> leftT = this.findRoots(left, _degree, _depth + 1);
        List<Double> rightT = this.findRoots(right, _degree, _depth + 1);
        t.addAll(leftT);
        t.addAll(rightT);
        return t;
    }

    private double computeXIntercept(List<Point2D> _v, int _degree) {
        double XNM = _v.get(_degree).getX() - _v.get(0).getX();
        double YNM = _v.get(_degree).getY() - _v.get(0).getY();
        double XMK = _v.get(0).getX();
        double YMK = _v.get(0).getY();
        double detInv = -1.0 / YNM;
        return (XNM * YMK - YNM * XMK) * detInv;
    }
}

