/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import com.jpexs.decompiler.flash.math.BezierEdge;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Distances {
    public static double getBatchDistance(List<BezierEdge> batch1, List<BezierEdge> batch2) {
        Area a1 = Distances.batchToArea(batch1);
        Area a2 = Distances.batchToArea(batch2);
        return Distances.areaDist(a1, a2);
    }

    private static Area batchToArea(List<BezierEdge> batch) {
        GeneralPath path = new GeneralPath(0);
        if (batch.isEmpty()) {
            return new Area();
        }
        path.moveTo(batch.get(0).getBeginPoint().getX(), batch.get(0).getBeginPoint().getY());
        for (BezierEdge be : batch) {
            if (be.points.size() == 3) {
                path.quadTo(be.points.get(1).getX(), be.points.get(1).getY(), be.points.get(2).getX(), be.points.get(2).getY());
                continue;
            }
            path.lineTo(be.getEndPoint().getX(), be.getEndPoint().getY());
        }
        path.closePath();
        return new Area(path);
    }

    private static double areaDist(Area a1, Area a2) {
        List<Point2D> points1 = Distances.getAreaPoints(a1);
        List<Point2D> points2 = Distances.getAreaPoints(a2);
        double minDist = Double.MAX_VALUE;
        double maxDist = 0.0;
        for (Point2D p : points1) {
            double dist = Double.MAX_VALUE;
            for (Point2D p2 : points2) {
                double d = p.distance(p2);
                if (!(d < dist)) continue;
                dist = d;
            }
            if (dist < minDist) {
                minDist = dist;
            }
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        return maxDist;
    }

    private static List<Point2D> getAreaPoints(Area area) {
        double F = 1.0;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        PathIterator pi = area.getPathIterator(null, 0.1);
        double[] coords = new double[6];
        double xPrev = 0.0;
        double yPrev = 0.0;
        double xBegin = 0.0;
        double yBegin = 0.0;
        while (!pi.isDone()) {
            int code = pi.currentSegment(coords);
            switch (code) {
                case 0: {
                    xBegin = coords[0];
                    yBegin = coords[1];
                    points.add(new Point2D.Double(xBegin, yBegin));
                    break;
                }
                case 1: {
                    double dx = coords[0] - xPrev;
                    double dy = coords[1] - yPrev;
                    double dz = Math.sqrt(dx * dx + dy * dy);
                    double divisor = dz / F;
                    int d = 1;
                    while ((double)d <= divisor) {
                        Point2D.Double p2 = new Point2D.Double(xPrev + (double)d * dx / divisor, yPrev + (double)d * dy / divisor);
                        points.add(p2);
                        ++d;
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("Curved edge not expected");
                }
            }
            xPrev = coords[0];
            yPrev = coords[1];
            pi.next();
        }
        return points;
    }
}

