/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Polynomial {
    private double[] coefs;
    private String _variable;
    private int _s;

    public Polynomial(List<Double> coefs) {
        this.coefs = new double[coefs.size()];
        for (int i = 0; i < coefs.size(); ++i) {
            this.coefs[i] = coefs.get(coefs.size() - 1 - i);
        }
        this._variable = "t";
        this._s = 0;
    }

    public int getDegree() {
        return this.coefs.length - 1;
    }

    private List<Double> getLinearRoot() {
        ArrayList<Double> result = new ArrayList<Double>();
        double a = this.coefs[1];
        if (a != 0.0) {
            result.add(-this.coefs[0] / a);
        }
        return result;
    }

    private List<Double> getQuadraticRoots() {
        ArrayList<Double> results = new ArrayList<Double>();
        if (this.getDegree() == 2) {
            double a = this.coefs[2];
            double b = this.coefs[1] / a;
            double c = this.coefs[0] / a;
            double d = b * b - 4.0 * c;
            if (d > 0.0) {
                double e = Math.sqrt(d);
                results.add(0.5 * (-b + e));
                results.add(0.5 * (-b - e));
            } else if (d == 0.0) {
                results.add(0.5 * -b);
            }
        }
        return results;
    }

    private boolean coefSelectionFunc(int i, int n, double[] a) {
        return i < n && a[i] < 0.0;
    }

    private void find2Max(Reference<Double> max, Reference<Double> nearmax, double bi, int i, int n, double[] a) {
        if (this.coefSelectionFunc(i, n, a)) {
            if (max.getVal() < bi) {
                nearmax.setVal(max.getVal());
                max.setVal(bi);
            } else if (nearmax.getVal() < bi) {
                nearmax.setVal(bi);
            }
        }
    }

    private double[] boundsUpperRealFujiwara() {
        double[] ax = this.coefs;
        double[] a = ax;
        int n = a.length - 1;
        double an = a[n];
        if (an != 1.0) {
            a = new double[a.length];
            for (int i = 0; i < this.coefs.length; ++i) {
                a[i] = ax[i] / an;
            }
        }
        double[] b = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            double v = a[i];
            b[i] = i < n ? Math.pow(Math.abs(i == 0 ? v / 2.0 : v), 1.0 / (double)(n - i)) : v;
        }
        double max_pos = 0.0;
        double nearmax_pos = 0.0;
        for (int i = 0; i < b.length; ++i) {
            if (i >= n || !(a[i] < 0.0)) continue;
            if (max_pos < b[i]) {
                nearmax_pos = max_pos;
                max_pos = b[i];
                continue;
            }
            if (!(nearmax_pos < b[i])) continue;
            nearmax_pos = b[i];
        }
        double max_neg = 0.0;
        double nearmax_neg = 0.0;
        for (int i = 0; i < b.length; ++i) {
            if (i >= n || !(n % 2 == i % 2 ? a[i] < 0.0 : a[i] > 0.0)) continue;
            if (max_neg < b[i]) {
                nearmax_neg = max_neg;
                max_neg = b[i];
                continue;
            }
            if (!(nearmax_neg < b[i])) continue;
            nearmax_neg = b[i];
        }
        return new double[]{-2.0 * max_neg, 2.0 * max_pos};
    }

    private double[] boundsLowerRealFujiwara() {
        Polynomial poly = new Polynomial(new ArrayList<Double>());
        poly.coefs = new double[this.coefs.length];
        for (int i = 0; i < this.coefs.length; ++i) {
            poly.coefs[this.coefs.length - 1 - i] = this.coefs[i];
        }
        double[] res = poly.boundsUpperRealFujiwara();
        res[0] = 1.0 / res[0];
        res[1] = 1.0 / res[1];
        return res;
    }

    private Rect bounds() {
        double[] urb = this.boundsUpperRealFujiwara();
        Rect rb = new Rect(urb[0], 0.0, urb[1], 0.0);
        if (urb[0] == 0.0 && urb[1] == 0.0) {
            return rb;
        }
        if (urb[0] == 0.0) {
            rb.minX = this.boundsLowerRealFujiwara()[1];
        } else if (urb[1] == 0.0) {
            rb.maxX = this.boundsLowerRealFujiwara()[0];
        }
        if (rb.minX > rb.maxX) {
            rb.maxX = 0.0;
            rb.minX = 0.0;
        }
        return rb;
    }

    private double eval(double x) {
        if (Double.isNaN(x)) {
            throw new RuntimeException("Parameter must be a number");
        }
        double result = 0.0;
        for (int i = this.coefs.length - 1; i >= 0; --i) {
            result = result * x + this.coefs[i];
        }
        return result;
    }

    public double zeroErrorEstimate() {
        return this.zeroErrorEstimate(null);
    }

    public double zeroErrorEstimate(Double maxAbsX) {
        Polynomial poly = this;
        double ERRF = 1.0E-15;
        if (maxAbsX == null) {
            Rect rb = poly.bounds();
            maxAbsX = Math.max(Math.abs(rb.minX), Math.abs(rb.maxX));
        }
        if (maxAbsX < 0.001) {
            return 2.0 * Math.abs(poly.eval(ERRF));
        }
        int n = poly.coefs.length - 1;
        double an = poly.coefs[n];
        double m = 0.0;
        for (int i = 0; i < poly.coefs.length; ++i) {
            double v = poly.coefs[i];
            double nm = v / an * Math.pow(maxAbsX, i);
            m = nm > m ? nm : m;
        }
        double x = 10.0 * ERRF * m;
        return x;
    }

    public List<Double> getCubicRoots() {
        ArrayList<Double> results = new ArrayList<Double>();
        if (this.getDegree() == 3) {
            double c3 = this.coefs[3];
            double c2 = this.coefs[2] / c3;
            double c1 = this.coefs[1] / c3;
            double c0 = this.coefs[0] / c3;
            double a = (3.0 * c1 - c2 * c2) / 3.0;
            double b = (2.0 * c2 * c2 * c2 - 9.0 * c1 * c2 + 27.0 * c0) / 27.0;
            double offset = c2 / 3.0;
            double discrim = b * b / 4.0 + a * a * a / 27.0;
            double halfB = b / 2.0;
            double ZEROepsilon = this.zeroErrorEstimate();
            if (Math.abs(discrim) <= ZEROepsilon) {
                discrim = 0.0;
            }
            if (discrim > 0.0) {
                double e = Math.sqrt(discrim);
                double tmp = -halfB + e;
                double root = tmp >= 0.0 ? Math.pow(tmp, 0.3333333333333333) : -Math.pow(-tmp, 0.3333333333333333);
                tmp = -halfB - e;
                root = tmp >= 0.0 ? (root += Math.pow(tmp, 0.3333333333333333)) : (root -= Math.pow(-tmp, 0.3333333333333333));
                results.add(root - offset);
            } else if (discrim < 0.0) {
                double distance = Math.sqrt(-a / 3.0);
                double angle = Math.atan2(Math.sqrt(-discrim), -halfB) / 3.0;
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                double sqrt3 = Math.sqrt(3.0);
                results.add(2.0 * distance * cos - offset);
                results.add(-distance * (cos + sqrt3 * sin) - offset);
                results.add(-distance * (cos - sqrt3 * sin) - offset);
            } else {
                double tmp = halfB >= 0.0 ? -Math.pow(halfB, 0.3333333333333333) : Math.pow(-halfB, 0.3333333333333333);
                results.add(2.0 * tmp - offset);
                results.add(-tmp - offset);
            }
        }
        return results;
    }

    public void simplifyEquals() {
        this.simplifyEquals(1.0E-12);
    }

    public void simplifyEquals(double tolerance) {
        for (int i = this.getDegree(); i >= 0 && Math.abs(this.coefs[i]) <= tolerance; --i) {
            double[] newc = new double[this.coefs.length - 1];
            for (int j = 0; j < newc.length; ++j) {
                newc[j] = this.coefs[j];
            }
            this.coefs = newc;
        }
    }

    private void divideEqualsScalar(double scalar) {
        int i = 0;
        while (i < this.coefs.length) {
            int n = i++;
            this.coefs[n] = this.coefs[n] / scalar;
        }
    }

    private Polynomial getDerivative() {
        Polynomial pol = new Polynomial(new ArrayList<Double>());
        ArrayList newCoefs = new ArrayList();
        pol.coefs = new double[this.coefs.length - 1];
        for (int i = 1; i < this.coefs.length; ++i) {
            pol.coefs[i - 1] = (double)i * this.coefs[i];
        }
        return pol;
    }

    public List<Double> getRoots() {
        List<Double> result;
        this.simplifyEquals();
        switch (this.getDegree()) {
            case 0: {
                result = new ArrayList<Double>();
                break;
            }
            case 1: {
                result = this.getLinearRoot();
                break;
            }
            case 2: {
                result = this.getQuadraticRoots();
                break;
            }
            case 3: {
                result = this.getCubicRoots();
                break;
            }
            case 4: {
                result = this.getQuarticRoots();
                break;
            }
            default: {
                result = new ArrayList<Double>();
            }
        }
        return result;
    }

    private static Double sign(Double x) {
        if (x == null) {
            return null;
        }
        return x < 0.0 ? -1.0 : 1.0;
    }

    private static double newtonSecantBisection(double x0, DoubleFunc f, DoubleFunc df, int max_iterations, Double min, Double max) {
        boolean isBounded;
        double prev_dfx = 0.0;
        double prev_x_ef_correction = 0.0;
        Double y_atmin = null;
        Double y_atmax = null;
        double x = x0;
        double ACCURACY = 14.0;
        double min_correction_factor = Math.pow(10.0, -ACCURACY);
        boolean bl = isBounded = min != null && max != null;
        if (isBounded) {
            if (min > max) {
                throw new RuntimeException("Min must be greater than max");
            }
            y_atmin = f.apply(min);
            y_atmax = f.apply(max);
            if (Double.compare(Polynomial.sign(y_atmin), Polynomial.sign(y_atmax)) == 0) {
                throw new RuntimeException("Y values of bounds must be of opposite sign");
            }
        }
        for (int i = 0; i < max_iterations; ++i) {
            boolean isEnoughCorrection;
            double dfx = df.apply(x);
            if (dfx == 0.0) {
                if (prev_dfx == 0.0) {
                    throw new RuntimeException("df(x) is zero");
                }
                dfx = prev_dfx;
            }
            prev_dfx = dfx;
            double y = f.apply(x);
            double x_correction = y / dfx;
            double x_new = x - x_correction;
            boolean bl2 = isEnoughCorrection = Math.abs(x_correction) <= min_correction_factor * Math.abs(x) || prev_x_ef_correction == x - x_correction - x;
            if (isEnoughCorrection) break;
            if (isBounded) {
                if (Double.compare(Polynomial.sign(y), Polynomial.sign(y_atmax)) == 0) {
                    max = x;
                    y_atmax = y;
                } else if (Double.compare(Polynomial.sign(y), Polynomial.sign(y_atmin)) == 0) {
                    min = x;
                    y_atmin = y;
                } else {
                    x = x_new;
                    break;
                }
                if (x_new < min || x_new > max) {
                    if (Double.compare(Polynomial.sign(y_atmin), Polynomial.sign(y_atmax)) == 0) break;
                    double RATIO_LIMIT = 50.0;
                    double AIMED_BISECT_OFFSET = 0.25;
                    double dy = y_atmax - y_atmin;
                    double dx = max - min;
                    x_correction = dy == 0.0 ? x - (min + dx * 0.5) : (Math.abs(dy / Math.min(y_atmin, y_atmax)) > RATIO_LIMIT ? x - (min + dx * (0.5 + (Math.abs(y_atmin) < Math.abs(y_atmax) ? -AIMED_BISECT_OFFSET : AIMED_BISECT_OFFSET))) : x - (min - y_atmin / dy * dx));
                    x_new = x - x_correction;
                    boolean bl3 = isEnoughCorrection = Math.abs(x_correction) <= min_correction_factor * Math.abs(x) || prev_x_ef_correction == x - x_correction - x;
                    if (isEnoughCorrection) break;
                }
            }
            prev_x_ef_correction = x - x_new;
            x = x_new;
        }
        return x;
    }

    private List<Double> getQuarticRoots() {
        ArrayList<Double> results = new ArrayList<Double>();
        int n = this.getDegree();
        if (n == 4) {
            int i;
            final Polynomial poly = new Polynomial(new ArrayList<Double>());
            poly.coefs = Arrays.copyOf(this.coefs, this.coefs.length);
            poly.divideEqualsScalar(poly.coefs[n]);
            double ERRF = 1.0E-15;
            if (Math.abs(poly.coefs[0]) < 10.0 * ERRF * Math.abs(poly.coefs[3])) {
                poly.coefs[0] = 0.0;
            }
            final Polynomial poly_d = poly.getDerivative();
            List<Double> derrt = poly_d.getRoots();
            derrt.sort(new Comparator<Double>(){

                @Override
                public int compare(Double a, Double b) {
                    if (Double.compare(a, b) == 0) {
                        return 0;
                    }
                    if (a - b < 0.0) {
                        return -1;
                    }
                    return 1;
                }
            });
            ArrayList<Double> dery = new ArrayList<Double>();
            int nr = derrt.size() - 1;
            Rect rb = this.bounds();
            double maxabsX = Math.max(Math.abs(rb.minX), Math.abs(rb.maxX));
            double ZEROepsilon = this.zeroErrorEstimate(maxabsX);
            for (i = 0; i <= nr; ++i) {
                dery.add(poly.eval(derrt.get(i)));
            }
            for (i = 0; i <= nr; ++i) {
                if (!(Math.abs((Double)dery.get(i)) < ZEROepsilon)) continue;
                dery.set(i, 0.0);
            }
            i = 0;
            double dx = Math.max(0.1 * (rb.maxX - rb.minX) / (double)n, ERRF);
            ArrayList<Double> guesses = new ArrayList<Double>();
            ArrayList<double[]> minmax = new ArrayList<double[]>();
            if (nr > -1) {
                if ((Double)dery.get(0) != 0.0) {
                    if (Double.compare(Polynomial.sign((Double)dery.get(0)), Polynomial.sign(poly.eval(derrt.get(0) - dx) - (Double)dery.get(0))) != 0) {
                        guesses.add(derrt.get(0) - dx);
                        minmax.add(new double[]{rb.minX, derrt.get(0)});
                    }
                } else {
                    results.add(derrt.get(0));
                    results.add(derrt.get(0));
                    ++i;
                }
                while (i < nr) {
                    if ((Double)dery.get(i + 1) == 0.0) {
                        results.add(derrt.get(i + 1));
                        results.add(derrt.get(i + 1));
                        ++i;
                    } else if (Double.compare(Polynomial.sign((Double)dery.get(i)), Polynomial.sign((Double)dery.get(i + 1))) != 0) {
                        guesses.add((derrt.get(i) + derrt.get(i + 1)) / 2.0);
                        minmax.add(new double[]{derrt.get(i), derrt.get(i + 1)});
                    }
                    ++i;
                }
                if ((Double)dery.get(nr) != 0.0 && Double.compare(Polynomial.sign((Double)dery.get(nr)), Polynomial.sign(poly.eval(derrt.get(nr) + dx) - (Double)dery.get(nr))) != 0) {
                    guesses.add(derrt.get(nr) + dx);
                    minmax.add(new double[]{derrt.get(nr), rb.maxX});
                }
            }
            DoubleFunc f = new DoubleFunc(){

                @Override
                public double apply(double x) {
                    return poly.eval(x);
                }
            };
            DoubleFunc df = new DoubleFunc(){

                @Override
                public double apply(double x) {
                    return poly_d.eval(x);
                }
            };
            if (!guesses.isEmpty()) {
                for (i = 0; i < guesses.size(); ++i) {
                    guesses.set(i, Polynomial.newtonSecantBisection((Double)guesses.get(i), f, df, 32, ((double[])minmax.get(i))[0], ((double[])minmax.get(i))[1]));
                }
            }
            results.addAll(guesses);
        }
        return results;
    }

    private static interface DoubleFunc {
        public double apply(double var1);
    }

    private class Rect {
        double minX;
        double minY;
        double maxX;
        double maxY;

        public Rect(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }
}

