/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.packers;

import com.jpexs.decompiler.flash.harman.HarmanBinaryDataEncrypt;
import com.jpexs.decompiler.flash.packers.Packer;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HarmanAirPackerWithKey
implements Packer {
    @Override
    public Boolean suitableForBinaryData(DefineBinaryDataTag dataTag) {
        if (dataTag.binaryData.getLength() < 32) {
            return false;
        }
        return null;
    }

    @Override
    public Boolean suitableForData(byte[] data) {
        if (data.length < 32) {
            return false;
        }
        return null;
    }

    @Override
    public boolean decrypt(InputStream is, OutputStream os, String key) throws IOException {
        byte[] encryptedData = Helper.readStream(is);
        byte[] decryptedData = HarmanBinaryDataEncrypt.decrypt(encryptedData, key);
        if (decryptedData == null) {
            return false;
        }
        os.write(decryptedData);
        return true;
    }

    @Override
    public boolean encrypt(InputStream is, OutputStream os, String key) throws IOException {
        byte[] data = Helper.readStream(is);
        byte[] encryptedData = HarmanBinaryDataEncrypt.encrypt(data, key);
        if (encryptedData == null) {
            return false;
        }
        os.write(encryptedData);
        return true;
    }

    @Override
    public String getName() {
        return "Harman AIR SDK with custom key";
    }

    @Override
    public String getIdentifier() {
        return "harmanair_key";
    }

    @Override
    public boolean usesKey() {
        return true;
    }
}

