/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.packers;

import com.jpexs.decompiler.flash.packers.Packer;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class MochiCryptPacker32Bit
implements Packer {
    @Override
    public Boolean suitableForBinaryData(DefineBinaryDataTag dataTag) {
        return null;
    }

    @Override
    public boolean decrypt(InputStream is, OutputStream os, String key) throws IOException {
        byte[] payload = Helper.readStream(is);
        if (!this.handleXor(payload)) {
            return false;
        }
        try {
            Helper.copyStreamEx(new InflaterInputStream(new ByteArrayInputStream(payload)), os);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private boolean handleXor(byte[] payload) {
        int u;
        int i;
        if (payload.length < 32) {
            return false;
        }
        int[] S = new int[256];
        int n = payload.length - 32;
        for (i = 0; i < 256; ++i) {
            S[i] = i;
        }
        int j = 0;
        for (i = 0; i < 256; ++i) {
            j = j + S[i] + (payload[n + (i & 0x1F)] & 0xFF) & 0xFF;
            u = S[i];
            S[i] = S[j];
            S[j] = u;
        }
        if (n > 131072) {
            n = 131072;
        }
        j = 0;
        i = 0;
        for (int k = 0; k < n; ++k) {
            int v;
            i = i + 1 & 0xFF;
            u = S[i];
            j = j + u & 0xFF;
            S[i] = v = S[j];
            S[j] = u;
            payload[k] = (byte)(payload[k] & 0xFF ^ S[u + v & 0xFF]);
        }
        return true;
    }

    @Override
    public boolean encrypt(InputStream is, OutputStream os, String key) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream def = new DeflaterOutputStream(baos);
        Helper.copyStreamEx(is, def);
        def.finish();
        byte[] payload = baos.toByteArray();
        if (!this.handleXor(payload)) {
            return false;
        }
        os.write(payload);
        return true;
    }

    @Override
    public String getName() {
        return "MochiCrypt 32bit";
    }

    @Override
    public Boolean suitableForData(byte[] data) {
        return null;
    }

    @Override
    public String getIdentifier() {
        return "mochicrypt32";
    }

    @Override
    public boolean usesKey() {
        return false;
    }
}

