/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.shapes;

import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class ShapeTransformer {
    public void transformStyles(Matrix matrix, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles, int shapeNum) {
        ArrayList<FILLSTYLE> fillStyleToTransform = new ArrayList<FILLSTYLE>();
        for (FILLSTYLE fs : fillStyles.fillStyles) {
            fillStyleToTransform.add(fs);
        }
        double strokeScale = Math.max(Math.abs(matrix.scaleX), Math.abs(matrix.scaleY));
        if (shapeNum >= 4) {
            for (ILINESTYLE iLINESTYLE : lineStyles.lineStyles2) {
                if (((LINESTYLE2)iLINESTYLE).hasFillFlag) {
                    fillStyleToTransform.add(((LINESTYLE2)iLINESTYLE).fillType);
                }
                ((LINESTYLE2)iLINESTYLE).width = (int)((double)((LINESTYLE2)iLINESTYLE).width * strokeScale);
            }
        } else {
            for (ILINESTYLE iLINESTYLE : lineStyles.lineStyles) {
                ((LINESTYLE)iLINESTYLE).width = (int)((double)((LINESTYLE)iLINESTYLE).width * strokeScale);
            }
        }
        for (FILLSTYLE fs : fillStyleToTransform) {
            switch (fs.fillStyleType) {
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    fs.bitmapMatrix = new Matrix(fs.bitmapMatrix).preConcatenate(matrix).toMATRIX();
                    break;
                }
                case 16: 
                case 18: 
                case 19: {
                    fs.gradientMatrix = new Matrix(fs.gradientMatrix).preConcatenate(matrix).toMATRIX();
                }
            }
        }
    }

    public void transformMorphStyles(Matrix matrix, MORPHFILLSTYLEARRAY fillStyles, MORPHLINESTYLEARRAY lineStyles, int morphShapeNum, boolean doStart, boolean doEnd) {
        ArrayList<MORPHFILLSTYLE> fillStyleToTransform = new ArrayList<MORPHFILLSTYLE>();
        for (MORPHFILLSTYLE fs : fillStyles.fillStyles) {
            fillStyleToTransform.add(fs);
        }
        if (morphShapeNum == 2) {
            for (MORPHLINESTYLE2 ls : lineStyles.lineStyles2) {
                if (!ls.hasFillFlag) continue;
                fillStyleToTransform.add(ls.fillType);
            }
        }
        for (MORPHFILLSTYLE fs : fillStyleToTransform) {
            switch (fs.fillStyleType) {
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    if (doStart) {
                        fs.startBitmapMatrix = new Matrix(fs.startBitmapMatrix).preConcatenate(matrix).toMATRIX();
                    }
                    if (!doEnd) break;
                    fs.endBitmapMatrix = new Matrix(fs.endBitmapMatrix).preConcatenate(matrix).toMATRIX();
                    break;
                }
                case 16: 
                case 18: 
                case 19: {
                    if (doStart) {
                        fs.startGradientMatrix = new Matrix(fs.startGradientMatrix).preConcatenate(matrix).toMATRIX();
                    }
                    if (!doEnd) break;
                    fs.endGradientMatrix = new Matrix(fs.endGradientMatrix).preConcatenate(matrix).toMATRIX();
                }
            }
        }
    }

    public void transformSHAPE(Matrix matrix, SHAPE shape, int shapeNum) {
        this.transformShapeRecords(matrix, shape.shapeRecords, shapeNum);
    }

    public void transformShapeRecords(Matrix matrix, List<SHAPERECORD> shapeRecords, int shapeNum) {
        int x = 0;
        int y = 0;
        StyleChangeRecord lastStyleChangeRecord = null;
        boolean wasMoveTo = false;
        for (SHAPERECORD rec : shapeRecords) {
            Point currentPoint;
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr;
                lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                if (scr.stateNewStyles) {
                    this.transformStyles(matrix, scr.fillStyles, scr.lineStyles, shapeNum);
                }
                if (scr.stateMoveTo) {
                    Point nextPoint = new Point(scr.moveDeltaX, scr.moveDeltaY);
                    x = scr.changeX(x);
                    y = scr.changeY(y);
                    Point nextPoint2 = matrix.transform(nextPoint);
                    scr.moveDeltaX = nextPoint2.x;
                    scr.moveDeltaY = nextPoint2.y;
                    scr.calculateBits();
                    wasMoveTo = true;
                }
            }
            if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                Point nextPoint2 = matrix.transform(new Point(x, y));
                if (nextPoint2.x != 0 || nextPoint2.y != 0) {
                    lastStyleChangeRecord.stateMoveTo = true;
                    lastStyleChangeRecord.moveDeltaX = nextPoint2.x;
                    lastStyleChangeRecord.moveDeltaY = nextPoint2.y;
                    lastStyleChangeRecord.calculateBits();
                    wasMoveTo = true;
                }
            }
            if (rec instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                ser.generalLineFlag = true;
                ser.vertLineFlag = false;
                currentPoint = new Point(x, y);
                Point nextPoint = new Point(x + ser.deltaX, y + ser.deltaY);
                x = ser.changeX(x);
                y = ser.changeY(y);
                Point currentPoint2 = matrix.transform(currentPoint);
                Point nextPoint2 = matrix.transform(nextPoint);
                ser.deltaX = nextPoint2.x - currentPoint2.x;
                ser.deltaY = nextPoint2.y - currentPoint2.y;
                ser.simplify();
            }
            if (!(rec instanceof CurvedEdgeRecord)) continue;
            CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
            currentPoint = new Point(x, y);
            Point controlPoint = new Point(x + cer.controlDeltaX, y + cer.controlDeltaY);
            Point anchorPoint = new Point(x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY);
            x = cer.changeX(x);
            y = cer.changeY(y);
            Point currentPoint2 = matrix.transform(currentPoint);
            Point controlPoint2 = matrix.transform(controlPoint);
            Point anchorPoint2 = matrix.transform(anchorPoint);
            cer.controlDeltaX = controlPoint2.x - currentPoint2.x;
            cer.controlDeltaY = controlPoint2.y - currentPoint2.y;
            cer.anchorDeltaX = anchorPoint2.x - controlPoint2.x;
            cer.anchorDeltaY = anchorPoint2.y - controlPoint2.y;
            cer.calculateBits();
        }
    }
}

