/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.sol;

import com.jpexs.decompiler.flash.amf.amf0.Amf0InputStream;
import com.jpexs.decompiler.flash.amf.amf0.Amf0OutputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3InputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3OutputStream;
import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.amf.amf3.ObjectTypeSerializeHandler;
import com.jpexs.decompiler.flash.amf.amf3.Traits;
import com.jpexs.decompiler.flash.sol.Tag;
import com.jpexs.helpers.MemoryInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LsoTag
extends Tag {
    public static final int ID = 2;
    public String fileName;
    public int amfVersion;
    public Map<String, Object> amfValues = new LinkedHashMap<String, Object>();

    public LsoTag(byte[] data, boolean forceWriteAsLong) {
        super(2, "DefineLso", data, forceWriteAsLong);
    }

    public LsoTag(String fileName, int amfVersion, Map<String, Object> amfValues) {
        super(2, "DefineLso", new byte[0], true);
        this.fileName = fileName;
        this.amfVersion = amfVersion;
        this.amfValues = amfValues;
    }

    @Override
    public void readData() throws IOException {
        InputStream ais;
        Amf0InputStream is = new Amf0InputStream(new MemoryInputStream(this.data));
        byte[] expectedSig = new byte[]{84, 67, 83, 79};
        byte[] actualSig = is.readBytes(4);
        if (!Arrays.equals(actualSig, expectedSig)) {
            throw new IllegalArgumentException("Not a SOL file - invalid signature");
        }
        is.skip(6L);
        int filenameLen = is.readU16("filenameLen");
        this.fileName = new String(is.readBytes(filenameLen), "UTF-8");
        this.amfVersion = (int)is.readU32("amfVersion");
        if (this.amfVersion != 0 && this.amfVersion != 3) {
            throw new IllegalArgumentException("Unsupported AMF version");
        }
        byte[] amfData = is.readBytes(is.available());
        if (this.amfVersion == 0) {
            ais = new Amf0InputStream(new MemoryInputStream(amfData));
            ArrayList complexObjects = new ArrayList();
            while (((Amf0InputStream)ais).available() > 0) {
                String varName = ((Amf0InputStream)ais).readUtf8("varName");
                try {
                    Object varValue = ((Amf0InputStream)ais).readValue("varValue");
                    this.amfValues.put(varName, varValue);
                }
                catch (NoSerializerExistsException ex) {
                    throw new IllegalArgumentException("Serializer for class " + ex.getClassName() + " not found");
                }
                ((Amf0InputStream)ais).read();
            }
            ((Amf0InputStream)ais).resolveMapReferences(this.amfValues);
        }
        if (this.amfVersion == 3) {
            ais = new Amf3InputStream(new MemoryInputStream(amfData));
            ArrayList<Object> objectsTable = new ArrayList<Object>();
            ArrayList<Traits> traitsTable = new ArrayList<Traits>();
            ArrayList<String> stringTable = new ArrayList<String>();
            while (((Amf3InputStream)ais).available() > 0) {
                String varName = ((Amf3InputStream)ais).readUtf8Vr("varName", stringTable);
                try {
                    Object varValue = ((Amf3InputStream)ais).readValue("varValue", new HashMap<String, ObjectTypeSerializeHandler>(), objectsTable, traitsTable, stringTable);
                    this.amfValues.put(varName, varValue);
                }
                catch (NoSerializerExistsException ex) {
                    throw new IllegalArgumentException("Serializer for class " + ex.getClassName() + " not found");
                }
                ((Amf3InputStream)ais).read();
            }
        }
    }

    @Override
    public void writeData(OutputStream os) throws IOException {
        Amf0OutputStream aos = new Amf0OutputStream(os);
        aos.write(new byte[]{84, 67, 83, 79});
        aos.write(new byte[]{0, 4, 0, 0, 0, 0});
        byte[] fileNameData = this.fileName.getBytes("UTF-8");
        aos.writeU16(fileNameData.length);
        aos.write(fileNameData);
        aos.writeU32(this.amfVersion);
        if (this.amfVersion == 0) {
            ArrayList<Object> complexObjects = new ArrayList<Object>();
            for (String key : this.amfValues.keySet()) {
                aos.writeUtf8(key);
                aos.writeValue(this.amfValues.get(key), complexObjects);
                aos.write(0);
            }
        }
        if (this.amfVersion == 3) {
            Amf3OutputStream a3os = new Amf3OutputStream(os);
            ArrayList<String> stringTable = new ArrayList<String>();
            ArrayList<Traits> traitTable = new ArrayList<Traits>();
            ArrayList<Object> objectTable = new ArrayList<Object>();
            for (String key : this.amfValues.keySet()) {
                try {
                    a3os.writeUtf8Vr(key, stringTable);
                    a3os.writeValue(this.amfValues.get(key), new HashMap<String, ObjectTypeSerializeHandler>(), stringTable, traitTable, objectTable);
                }
                catch (NoSerializerExistsException ex) {
                    throw new IllegalArgumentException("Serializer not found for class " + ex.getClassName());
                }
                aos.write(0);
            }
        }
    }
}

