/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonAction;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@SWFVersion(from=1)
public class DefineButtonTag
extends ButtonTag
implements ASMSourceContainer {
    public static final int ID = 7;
    public static final String NAME = "DefineButton";
    @SWFType(value=BasicType.UI16)
    public int buttonId;
    public List<BUTTONRECORD> characters;
    @HideInRawEdit
    public ByteArrayRange actionBytes;

    public DefineButtonTag(SWF swf) {
        super(swf, 7, NAME, null);
        this.buttonId = swf.getNextCharacterId();
        this.characters = new ArrayList<BUTTONRECORD>();
        this.actionBytes = ByteArrayRange.EMPTY;
    }

    public DefineButtonTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 7, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.buttonId = sis.readUI16("buttonId");
        this.characters = sis.readBUTTONRECORDList(this.swf, this, "characters");
        this.actionBytes = sis.readByteRangeEx(sis.available(), "actionBytes", DumpInfoSpecialType.ACTION_BYTES, sis.getPos());
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.buttonId);
        sos.writeBUTTONRECORDList(this.characters, false);
        sos.write(this.getActionBytes());
    }

    @Override
    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.buttonId);
        sos.writeBUTTONRECORDList(this.characters, false);
    }

    @Override
    public int getCharacterId() {
        return this.buttonId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.buttonId = characterId;
    }

    @Override
    public List<BUTTONRECORD> getRecords() {
        return this.characters;
    }

    public List<ButtonAction> getSubItems() {
        return Arrays.asList(new ButtonAction(this));
    }

    public void setActions(List<Action> actions) {
        this.actionBytes = Action.actionsToByteArrayRange(actions, true, this.swf.version);
    }

    public ByteArrayRange getActionBytes() {
        return this.actionBytes;
    }

    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = new ByteArrayRange(actionBytes);
    }

    public void setModified() {
        this.setModified(true);
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.characters.size(); ++i) {
            BUTTONRECORD character = this.characters.get(i);
            if (character.characterId != oldCharacterId) continue;
            character.characterId = newCharacterId;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (int i = 0; i < this.characters.size(); ++i) {
            if (this.characters.get((int)i).characterId != characterId) continue;
            this.characters.remove(i);
            modified = true;
            --i;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT ret;
        Cache<CharacterTag, RECT> cache = this.swf == null ? null : this.swf.getRectCache();
        RECT rECT = ret = cache == null ? null : cache.get(this);
        if (ret != null) {
            return ret;
        }
        RECT rect = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        boolean foundSomething = false;
        for (BUTTONRECORD r : this.characters) {
            BoundedTag bt;
            CharacterTag ch = this.swf.getCharacter(r.characterId);
            if (!(ch instanceof BoundedTag) || added.contains(bt = (BoundedTag)((Object)ch))) continue;
            added.add(bt);
            RECT r2 = bt.getRect(added);
            added.remove(bt);
            MATRIX mat = r.placeMatrix;
            if (mat != null) {
                r2 = mat.apply(r2);
            }
            rect.Xmin = Math.min(r2.Xmin, rect.Xmin);
            rect.Ymin = Math.min(r2.Ymin, rect.Ymin);
            rect.Xmax = Math.max(r2.Xmax, rect.Xmax);
            rect.Ymax = Math.max(r2.Ymax, rect.Ymax);
            foundSomething = true;
        }
        if (!foundSomething) {
            rect = new RECT();
        }
        if (cache != null) {
            cache.put(this, rect);
        }
        return rect;
    }

    @Override
    public boolean trackAsMenu() {
        return false;
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    protected void initTimeline(Timeline timeline) {
        DefineButtonCxformTag cxformTag = (DefineButtonCxformTag)this.swf.getCharacterIdTag(this.buttonId, 23);
        CXFORM clrTrans = cxformTag == null ? null : cxformTag.buttonColorTransform;
        int maxDepth = 0;
        Frame frameUp = new Frame(timeline, 0);
        Frame frameDown = new Frame(timeline, 0);
        Frame frameOver = new Frame(timeline, 0);
        Frame frameHit = new Frame(timeline, 0);
        for (BUTTONRECORD r : this.characters) {
            if (this.swf.getCyclicCharacters().contains(r.characterId)) continue;
            DepthState layer = new DepthState(this.swf, null, null);
            layer.colorTransForm = clrTrans;
            layer.blendMode = r.blendMode;
            layer.filters = r.filterList;
            layer.matrix = r.placeMatrix;
            layer.characterId = r.characterId;
            if (r.placeDepth > maxDepth) {
                maxDepth = r.placeDepth;
            }
            if (r.buttonStateUp) {
                frameUp.layers.put(r.placeDepth, new DepthState(layer, frameUp, frameUp, false));
            }
            if (r.buttonStateOver) {
                frameOver.layers.put(r.placeDepth, new DepthState(layer, frameOver, frameOver, false));
                if (!r.buttonStateUp) {
                    frameOver.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
                }
            }
            if (r.buttonStateDown) {
                frameDown.layers.put(r.placeDepth, new DepthState(layer, frameDown, frameDown, false));
                if (!r.buttonStateOver) {
                    frameDown.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
                }
            }
            if (!r.buttonStateHitTest) continue;
            frameHit.layers.put(r.placeDepth, new DepthState(layer, frameHit, frameHit, false));
            if (r.buttonStateDown) continue;
            frameHit.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
        }
        timeline.addFrame(frameUp);
        if (frameOver.layers.isEmpty()) {
            frameOver = frameUp;
        }
        timeline.addFrame(frameOver);
        if (frameDown.layers.isEmpty()) {
            frameDown = frameOver;
        }
        timeline.addFrame(frameDown);
        if (frameHit.layers.isEmpty()) {
            frameHit = frameUp;
        }
        timeline.addFrame(frameHit);
    }

    @Override
    public int getFrameCount() {
        return 4;
    }

    @Override
    public void setFrameCount(int frameCount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        for (BUTTONRECORD rec : this.characters) {
            needed.add(rec.characterId);
        }
    }
}

