/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.FontInfoTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SWFVersion(from=1)
public class DefineFontTag
extends FontTag {
    public static final int ID = 10;
    public static final String NAME = "DefineFont";
    @SWFType(value=BasicType.UI16)
    public int fontId;
    @Conditional(value={"!strippedShapes"})
    public List<SHAPE> glyphShapeTable;
    @Internal
    private FontInfoTag fontInfoTag = null;
    @Internal
    public long unknownGfx;
    @Internal
    public boolean strippedShapes = false;

    public DefineFontTag(SWF swf) {
        super(swf, 10, NAME, null);
        this.fontId = swf.getNextCharacterId();
        this.glyphShapeTable = new ArrayList<SHAPE>();
    }

    public DefineFontTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 10, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.fontId = sis.readUI16("fontId");
        this.glyphShapeTable = new ArrayList<SHAPE>();
        this.strippedShapes = this.swf.hasStrippedShapesFromFonts();
        if (!this.strippedShapes && sis.available() > 0) {
            int i;
            long pos = sis.getPos();
            int firstOffset = sis.readUI16("firstOffset");
            int nGlyphs = firstOffset / 2;
            long[] offsetTable = new long[nGlyphs];
            offsetTable[0] = firstOffset;
            for (i = 1; i < nGlyphs; ++i) {
                offsetTable[i] = sis.readUI16("offset");
            }
            for (i = 0; i < nGlyphs; ++i) {
                sis.seek(pos + offsetTable[i]);
                this.glyphShapeTable.add(sis.readSHAPE(1, false, "shape"));
            }
        }
        if (this.strippedShapes) {
            this.unknownGfx = sis.readUI32("unknownGfx");
        }
    }

    @Override
    public synchronized void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.fontId);
        if (!this.swf.hasStrippedShapesFromFonts()) {
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            ArrayList<Integer> offsetTable = new ArrayList<Integer>();
            SWFOutputStream sos2 = new SWFOutputStream(baos2, this.getVersion(), this.getCharset());
            for (SHAPE shape : this.glyphShapeTable) {
                offsetTable.add(this.glyphShapeTable.size() * 2 + (int)sos2.getPos());
                sos2.writeSHAPE(shape, 1);
            }
            Iterator<SHAPE> iterator = offsetTable.iterator();
            while (iterator.hasNext()) {
                int offset = (Integer)((Object)iterator.next());
                sos.writeUI16(offset);
            }
            sos.write(baos2.toByteArray());
        } else {
            sos.writeUI32(this.unknownGfx);
        }
    }

    @Override
    public boolean isSmall() {
        return false;
    }

    @Override
    public double getGlyphAdvance(int glyphIndex) {
        return -1.0;
    }

    @Override
    public void setGlyphAdvance(int glyphIndex, double advanceValue) {
    }

    @Override
    public void updateBounds() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized int getGlyphWidth(int glyphIndex) {
        return this.glyphShapeTable.get(glyphIndex).getBounds(1).getWidth();
    }

    private void ensureFontInfo() {
        List<CharacterIdTag> characterIdTags;
        if (this.fontInfoTag == null && (characterIdTags = this.swf.getCharacterIdTags(this.fontId)) != null) {
            for (CharacterIdTag t : characterIdTags) {
                if (!(t instanceof FontInfoTag) || ((FontInfoTag)t).fontID != this.fontId) continue;
                this.fontInfoTag = (FontInfoTag)t;
                break;
            }
        }
    }

    @Override
    public synchronized char glyphToChar(int glyphIndex) {
        this.ensureFontInfo();
        if (this.fontInfoTag != null) {
            return Utf8Helper.codePointToChar(this.fontInfoTag.getCodeTable().get(glyphIndex), this.getCodesCharset());
        }
        return '?';
    }

    @Override
    public int charToGlyph(char c) {
        this.ensureFontInfo();
        if (this.fontInfoTag != null) {
            return this.fontInfoTag.getCodeTable().indexOf(Utf8Helper.charToCodePoint(c, this.getCodesCharset()));
        }
        return -1;
    }

    @Override
    public synchronized List<SHAPE> getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    @Override
    public int getCharacterId() {
        return this.fontId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.fontId = characterId;
    }

    @Override
    public String getFontNameIntag() {
        this.ensureFontInfo();
        if (this.fontInfoTag != null) {
            return this.fontInfoTag.getFontName();
        }
        return null;
    }

    @Override
    public boolean isBold() {
        if (this.fontInfoTag != null) {
            return this.fontInfoTag.getFontFlagsBold();
        }
        return false;
    }

    @Override
    public boolean isItalic() {
        if (this.fontInfoTag != null) {
            return this.fontInfoTag.getFontFlagsItalic();
        }
        return false;
    }

    @Override
    public boolean isSmallEditable() {
        return false;
    }

    @Override
    public boolean isBoldEditable() {
        return this.fontInfoTag != null;
    }

    @Override
    public boolean isItalicEditable() {
        return this.fontInfoTag != null;
    }

    @Override
    public void setSmall(boolean value) {
    }

    @Override
    public void setBold(boolean value) {
        if (this.fontInfoTag != null) {
            this.fontInfoTag.setFontFlagsBold(value);
        }
    }

    @Override
    public void setItalic(boolean value) {
        if (this.fontInfoTag != null) {
            this.fontInfoTag.setFontFlagsItalic(value);
        }
    }

    @Override
    public int getAscent() {
        return -1;
    }

    @Override
    public int getDescent() {
        return -1;
    }

    @Override
    public int getLeading() {
        return -1;
    }

    @Override
    public double getDivider() {
        return 1.0;
    }

    @Override
    public String getCodesCharset() {
        if (this.fontInfoTag != null && this.fontInfoTag.isShiftJIS()) {
            return "Shift_JIS";
        }
        return this.getCharset();
    }

    @Override
    public synchronized boolean addCharacter(char character, Font font) {
        SHAPE shp = SHAPERECORD.fontCharacterToSHAPE(font, (int)Math.round(this.getDivider() * 1024.0), character);
        this.ensureFontInfo();
        int code = Utf8Helper.charToCodePoint(character, this.getCodesCharset());
        if (code == -1) {
            code = 0;
        }
        int pos = -1;
        boolean exists = false;
        if (this.fontInfoTag != null) {
            List<Integer> codeTable = this.fontInfoTag.getCodeTable();
            pos = codeTable.indexOf(code);
            boolean bl = exists = pos != -1;
            if (!exists) {
                for (int i = 0; i < codeTable.size(); ++i) {
                    if (codeTable.get(i) <= code) continue;
                    pos = i;
                    break;
                }
            }
            if (pos == -1) {
                pos = codeTable.size();
            }
        } else {
            pos = 0;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos2 = new SWFOutputStream(baos, this.getVersion(), this.getCharset());
        for (int s = 0; s <= this.glyphShapeTable.size(); ++s) {
            SHAPE shape;
            if (s == this.glyphShapeTable.size() || pos == s) {
                if (pos != s) break;
                shape = shp;
            } else {
                shape = this.glyphShapeTable.get(s);
            }
            int offset = this.glyphShapeTable.size() * 2 + (int)sos2.getPos();
            if (offset > 65535) {
                return false;
            }
            try {
                sos2.writeSHAPE(shape, 1);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!exists) {
            this.shiftGlyphIndices(this.fontId, pos, true);
            this.glyphShapeTable.add(pos, shp);
            if (this.fontInfoTag != null) {
                this.fontInfoTag.addFontCharacter(pos, code);
            }
        } else {
            this.glyphShapeTable.set(pos, shp);
        }
        this.setModified(true);
        this.getSwf().clearImageCache();
        return true;
    }

    @Override
    public synchronized boolean removeCharacter(char character) {
        this.ensureFontInfo();
        if (this.fontInfoTag == null) {
            return false;
        }
        char code = character;
        int pos = -1;
        List<Integer> codeTable = this.fontInfoTag.getCodeTable();
        pos = codeTable.indexOf(code);
        if (pos == -1) {
            return false;
        }
        this.glyphShapeTable.remove(pos);
        this.fontInfoTag.removeFontCharacter(pos);
        this.shiftGlyphIndices(this.fontId, pos + 1, false);
        this.setModified(true);
        this.getSwf().clearImageCache();
        return true;
    }

    @Override
    public void setAdvanceValues(Font font) {
        throw new UnsupportedOperationException("Setting the advance values for DefineFontTag is not supported.");
    }

    @Override
    public synchronized int getCharacterCount() {
        this.ensureFontInfo();
        if (this.fontInfoTag != null) {
            List<Integer> codeTable = this.fontInfoTag.getCodeTable();
            return codeTable.size();
        }
        return 0;
    }

    @Override
    public synchronized String getCharacters() {
        this.ensureFontInfo();
        if (this.fontInfoTag != null) {
            List<Integer> codeTable = this.fontInfoTag.getCodeTable();
            StringBuilder ret = new StringBuilder(codeTable.size());
            for (int i : codeTable) {
                ret.append(Utf8Helper.codePointToChar(i, this.getCodesCharset()));
            }
            return ret.toString();
        }
        return "";
    }

    @Override
    public int getGlyphKerningAdjustment(int glyphIndex, int nextGlyphIndex) {
        return 0;
    }

    @Override
    public int getCharKerningAdjustment(char c1, char c2) {
        return 0;
    }

    @Override
    public void setAscent(int ascent) {
    }

    @Override
    public void setDescent(int descent) {
    }

    @Override
    public void setLeading(int leading) {
    }

    @Override
    public void setHasLayout(boolean hasLayout) {
    }

    @Override
    public void setFontNameIntag(String name) {
    }

    @Override
    public boolean isFontNameInTagEditable() {
        return false;
    }

    @Override
    public boolean isAscentEditable() {
        return false;
    }

    @Override
    public boolean isDescentEditable() {
        return false;
    }

    @Override
    public boolean isLeadingEditable() {
        return false;
    }
}

