/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;

@SWFVersion(from=8)
public class DefineShape4Tag
extends ShapeTag {
    public static final int ID = 83;
    public static final String NAME = "DefineShape4";
    public RECT edgeBounds;
    @Reserved
    @SWFType(value=BasicType.UB, count=5)
    public int reserved;
    public boolean usesFillWindingRule;
    public boolean usesNonScalingStrokes;
    public boolean usesScalingStrokes;

    public DefineShape4Tag(SWF swf) {
        super(swf, 83, NAME, null);
        this.shapeId = swf.getNextCharacterId();
        this.shapeBounds = new RECT();
        this.edgeBounds = new RECT();
        this.shapes = SHAPEWITHSTYLE.createEmpty(4);
    }

    public DefineShape4Tag(SWFInputStream sis, ByteArrayRange data, boolean lazy) throws IOException {
        super(sis.getSwf(), 83, NAME, data);
        this.readData(sis, data, 0, false, false, lazy);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.shapeId = sis.readUI16("shapeId");
        this.shapeBounds = sis.readRECT("shapeBounds");
        this.edgeBounds = sis.readRECT("edgeBounds");
        this.reserved = (int)sis.readUB(5, "reserved");
        this.usesFillWindingRule = sis.readUB(1, "usesFillWindingRule") == 1L;
        this.usesNonScalingStrokes = sis.readUB(1, "usesNonScalingStrokes") == 1L;
        boolean bl = this.usesScalingStrokes = sis.readUB(1, "usesScalingStrokes") == 1L;
        if (!lazy) {
            this.shapes = sis.readSHAPEWITHSTYLE(this.getShapeNum(), false, "shapes");
        } else {
            this.shapeData = new ByteArrayRange(data.getArray(), (int)sis.getPos(), sis.available());
            sis.skipBytes(sis.available());
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.shapeId);
        sos.writeRECT(this.shapeBounds);
        sos.writeRECT(this.edgeBounds);
        sos.writeUB(5, this.reserved);
        sos.writeUB(1, this.usesFillWindingRule ? 1L : 0L);
        sos.writeUB(1, this.usesNonScalingStrokes ? 1L : 0L);
        sos.writeUB(1, this.usesScalingStrokes ? 1L : 0L);
        sos.writeSHAPEWITHSTYLE(this.getShapes(), this.getShapeNum());
    }

    @Override
    public int getShapeNum() {
        return 4;
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        this.updateEdgeBounds();
    }

    public void updateEdgeBounds() {
        this.edgeBounds = SHAPERECORD.getBounds(this.shapes.shapeRecords, null, 4, true);
    }

    @Override
    public int getWindingRule() {
        if (this.usesFillWindingRule) {
            return 1;
        }
        return 0;
    }
}

