/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=8)
public class PlaceObject3Tag
extends PlaceObjectTypeTag
implements ASMSourceContainer {
    public static final int ID = 70;
    public static final String NAME = "PlaceObject3";
    public boolean placeFlagHasClipActions;
    public boolean placeFlagHasClipDepth;
    public boolean placeFlagHasName;
    public boolean placeFlagHasRatio;
    public boolean placeFlagHasColorTransform;
    public boolean placeFlagHasMatrix;
    public boolean placeFlagHasCharacter;
    public boolean placeFlagMove;
    public boolean placeFlagHasImage;
    public boolean placeFlagHasClassName;
    public boolean placeFlagHasCacheAsBitmap;
    public boolean placeFlagHasBlendMode;
    public boolean placeFlagHasFilterList;
    public boolean placeFlagOpaqueBackground;
    public boolean placeFlagHasVisible;
    @SWFType(value=BasicType.UI16)
    public int depth;
    @Conditional(value={"placeFlagHasClassName"})
    public String className;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"placeFlagHasCharacter"})
    public int characterId;
    @Conditional(value={"placeFlagHasMatrix"})
    public MATRIX matrix;
    @Conditional(value={"placeFlagHasColorTransform"})
    public CXFORMWITHALPHA colorTransform;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"placeFlagHasRatio"})
    public int ratio;
    @Conditional(value={"placeFlagHasName"})
    @DottedIdentifier
    public String name;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"placeFlagHasClipDepth"})
    public int clipDepth;
    @Conditional(value={"placeFlagHasFilterList"})
    @SWFArray(value="filter")
    public List<FILTER> surfaceFilterList;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"placeFlagHasBlendMode"})
    @EnumValues(value={@EnumValue(value=0, text="normal"), @EnumValue(value=1, text="normal"), @EnumValue(value=2, text="layer"), @EnumValue(value=3, text="multiply"), @EnumValue(value=4, text="screen"), @EnumValue(value=5, text="lighten"), @EnumValue(value=6, text="darken"), @EnumValue(value=7, text="difference"), @EnumValue(value=8, text="add"), @EnumValue(value=9, text="subtract"), @EnumValue(value=10, text="invert"), @EnumValue(value=11, text="alpha"), @EnumValue(value=12, text="erase"), @EnumValue(value=13, text="overlay"), @EnumValue(value=14, text="hardlight")})
    public int blendMode;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"placeFlagHasCacheAsBitmap"})
    public int bitmapCache;
    @Conditional(value={"placeFlagHasClipActions"}, minSwfVersion=5)
    public CLIPACTIONS clipActions;
    @Conditional(value={"placeFlagHasVisible"})
    public int visible;
    @Conditional(value={"placeFlagOpaqueBackground"})
    public RGBA backgroundColor;
    @Internal
    private boolean bitmapCacheBug;
    @Reserved
    public boolean reserved;

    public PlaceObject3Tag(SWF swf) {
        super(swf, 70, NAME, null);
    }

    public PlaceObject3Tag(SWF swf, boolean placeFlagMove, int depth, String className, int characterId, MATRIX matrix, CXFORMWITHALPHA colorTransform, int ratio, String name, int clipDepth, List<FILTER> surfaceFilterList, int blendMode, Integer bitmapCache, int visible, RGBA backgroundColor, CLIPACTIONS clipActions, boolean placeFlagHasImage) {
        super(swf, 70, NAME, null);
        this.placeFlagHasClassName = className != null;
        this.placeFlagHasFilterList = surfaceFilterList != null;
        this.placeFlagHasBlendMode = blendMode >= 0;
        this.placeFlagHasCacheAsBitmap = bitmapCache != null;
        this.placeFlagHasVisible = visible >= 0;
        this.placeFlagOpaqueBackground = backgroundColor != null;
        this.placeFlagHasClipActions = clipActions != null;
        this.placeFlagHasClipDepth = clipDepth >= 0;
        this.placeFlagHasName = name != null;
        this.placeFlagHasRatio = ratio >= 0;
        this.placeFlagHasColorTransform = colorTransform != null;
        this.placeFlagHasMatrix = matrix != null;
        this.placeFlagHasCharacter = characterId >= 0;
        this.placeFlagMove = placeFlagMove;
        this.depth = depth;
        this.className = className;
        this.characterId = characterId;
        this.matrix = matrix;
        this.colorTransform = colorTransform;
        this.ratio = ratio;
        this.name = name;
        this.clipDepth = clipDepth;
        this.surfaceFilterList = surfaceFilterList;
        this.blendMode = blendMode;
        this.bitmapCache = bitmapCache == null ? 0 : bitmapCache;
        this.visible = visible;
        this.backgroundColor = backgroundColor;
        this.clipActions = clipActions;
        this.placeFlagHasImage = placeFlagHasImage;
    }

    public PlaceObject3Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 70, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.placeFlagHasClipActions = sis.readUB(1, "placeFlagHasClipActions") == 1L;
        this.placeFlagHasClipDepth = sis.readUB(1, "placeFlagHasClipDepth") == 1L;
        this.placeFlagHasName = sis.readUB(1, "placeFlagHasName") == 1L;
        this.placeFlagHasRatio = sis.readUB(1, "placeFlagHasRatio") == 1L;
        this.placeFlagHasColorTransform = sis.readUB(1, "placeFlagHasColorTransform") == 1L;
        this.placeFlagHasMatrix = sis.readUB(1, "placeFlagHasMatrix") == 1L;
        this.placeFlagHasCharacter = sis.readUB(1, "placeFlagHasCharacter") == 1L;
        this.placeFlagMove = sis.readUB(1, "placeFlagMove") == 1L;
        this.reserved = sis.readUB(1, "reserved") == 1L;
        this.placeFlagOpaqueBackground = sis.readUB(1, "placeFlagOpaqueBackground") == 1L;
        this.placeFlagHasVisible = sis.readUB(1, "placeFlagHasVisible") == 1L;
        this.placeFlagHasImage = sis.readUB(1, "placeFlagHasImage") == 1L;
        this.placeFlagHasClassName = sis.readUB(1, "placeFlagHasClassName") == 1L;
        this.placeFlagHasCacheAsBitmap = sis.readUB(1, "placeFlagHasCacheAsBitmap") == 1L;
        this.placeFlagHasBlendMode = sis.readUB(1, "placeFlagHasBlendMode") == 1L;
        this.placeFlagHasFilterList = sis.readUB(1, "placeFlagHasFilterList") == 1L;
        this.depth = sis.readUI16("depth");
        if (this.placeFlagHasClassName) {
            this.className = sis.readString("className");
        }
        if (this.placeFlagHasCharacter) {
            this.characterId = sis.readUI16("characterId");
        }
        if (this.placeFlagHasMatrix) {
            this.matrix = sis.readMatrix("matrix");
        }
        if (this.placeFlagHasColorTransform) {
            this.colorTransform = sis.readCXFORMWITHALPHA("colorTransform");
        }
        if (this.placeFlagHasRatio) {
            this.ratio = sis.readUI16("ratio");
        }
        if (this.placeFlagHasName) {
            this.name = sis.readString("name");
        }
        if (this.placeFlagHasClipDepth) {
            this.clipDepth = sis.readUI16("clipDepth");
        }
        if (this.placeFlagHasFilterList) {
            this.surfaceFilterList = sis.readFILTERLIST("surfaceFilterList");
        }
        if (this.placeFlagHasBlendMode) {
            this.blendMode = sis.readUI8("blendMode");
        }
        this.bitmapCacheBug = false;
        if (this.placeFlagHasCacheAsBitmap) {
            try {
                this.bitmapCache = sis.readUI8("bitmapCache");
            }
            catch (EndOfStreamException eex) {
                this.bitmapCacheBug = true;
                this.bitmapCache = 1;
            }
        }
        if (this.placeFlagHasVisible) {
            this.visible = sis.readUI8("visible");
        }
        if (this.placeFlagOpaqueBackground) {
            this.backgroundColor = sis.readRGBA("backgroundColor");
        }
        if (this.placeFlagHasClipActions) {
            this.clipActions = sis.readCLIPACTIONS(this.swf, this, "clipActions");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUB(1, this.placeFlagHasClipActions ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasClipDepth ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasRatio ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasColorTransform ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasMatrix ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCharacter ? 1L : 0L);
        sos.writeUB(1, this.placeFlagMove ? 1L : 0L);
        sos.writeUB(1, this.reserved ? 1L : 0L);
        sos.writeUB(1, this.placeFlagOpaqueBackground ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasVisible ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasImage ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasClassName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCacheAsBitmap ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasBlendMode ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasFilterList ? 1L : 0L);
        sos.writeUI16(this.depth);
        if (this.placeFlagHasClassName) {
            sos.writeString(this.className);
        }
        if (this.placeFlagHasCharacter) {
            sos.writeUI16(this.characterId);
        }
        if (this.placeFlagHasMatrix) {
            sos.writeMatrix(this.matrix);
        }
        if (this.placeFlagHasColorTransform) {
            sos.writeCXFORMWITHALPHA(this.colorTransform);
        }
        if (this.placeFlagHasRatio) {
            sos.writeUI16(this.ratio);
        }
        if (this.placeFlagHasName) {
            sos.writeString(this.name);
        }
        if (this.placeFlagHasClipDepth) {
            sos.writeUI16(this.clipDepth);
        }
        if (this.placeFlagHasFilterList) {
            sos.writeFILTERLIST(this.surfaceFilterList);
        }
        if (this.placeFlagHasBlendMode) {
            sos.writeUI8(this.blendMode);
        }
        if (this.placeFlagHasCacheAsBitmap && !this.bitmapCacheBug) {
            sos.writeUI8(this.bitmapCache);
        }
        if (this.placeFlagHasVisible) {
            sos.writeUI8(this.visible);
        }
        if (this.placeFlagOpaqueBackground) {
            sos.writeRGBA(this.backgroundColor);
        }
        if (this.placeFlagHasClipActions) {
            sos.writeCLIPACTIONS(this.clipActions);
        }
    }

    @Override
    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        sos.writeUB(1, 0L);
        sos.writeUB(1, this.placeFlagHasClipDepth ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasRatio ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasColorTransform ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasMatrix ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCharacter ? 1L : 0L);
        sos.writeUB(1, this.placeFlagMove ? 1L : 0L);
        sos.writeUB(1, this.reserved ? 1L : 0L);
        sos.writeUB(1, this.placeFlagOpaqueBackground ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasVisible ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasImage ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasClassName ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasCacheAsBitmap ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasBlendMode ? 1L : 0L);
        sos.writeUB(1, this.placeFlagHasFilterList ? 1L : 0L);
        sos.writeUI16(this.depth);
        if (this.placeFlagHasClassName) {
            sos.writeString(this.className);
        }
        if (this.placeFlagHasCharacter) {
            sos.writeUI16(this.characterId);
        }
        if (this.placeFlagHasMatrix) {
            sos.writeMatrix(this.matrix);
        }
        if (this.placeFlagHasColorTransform) {
            sos.writeCXFORMWITHALPHA(this.colorTransform);
        }
        if (this.placeFlagHasRatio) {
            sos.writeUI16(this.ratio);
        }
        if (this.placeFlagHasName) {
            sos.writeString(this.name);
        }
        if (this.placeFlagHasClipDepth) {
            sos.writeUI16(this.clipDepth);
        }
        if (this.placeFlagHasFilterList) {
            sos.writeFILTERLIST(this.surfaceFilterList);
        }
        if (this.placeFlagHasBlendMode) {
            sos.writeUI8(this.blendMode);
        }
        if (this.placeFlagHasCacheAsBitmap && !this.bitmapCacheBug) {
            sos.writeUI8(this.bitmapCache);
        }
        if (this.placeFlagHasVisible) {
            sos.writeUI8(this.visible);
        }
        if (this.placeFlagOpaqueBackground) {
            sos.writeRGBA(this.backgroundColor);
        }
    }

    @Override
    public int getPlaceObjectNum() {
        return 3;
    }

    @Override
    public int getClipDepth() {
        if (this.placeFlagHasClipDepth) {
            return this.clipDepth;
        }
        return -1;
    }

    @Override
    public List<FILTER> getFilters() {
        if (this.placeFlagHasFilterList) {
            return this.surfaceFilterList;
        }
        return null;
    }

    public List<CLIPACTIONRECORD> getSubItems() {
        if (this.placeFlagHasClipActions) {
            return this.clipActions.clipActionRecords;
        }
        return new ArrayList<CLIPACTIONRECORD>();
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        int chId;
        if (this.placeFlagHasCharacter) {
            needed.add(this.characterId);
        }
        if (this.placeFlagHasClassName && (chId = swf.getCharacterId(swf.getCharacterByClass(this.className))) != -1) {
            needed.add(chId);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        return false;
    }

    @Override
    public int getCharacterId() {
        if (this.placeFlagHasCharacter) {
            return this.characterId;
        }
        return -1;
    }

    @Override
    public void setCharacterId(int characterId) {
        if (characterId >= 0) {
            this.placeFlagHasCharacter = true;
            this.characterId = characterId;
        } else {
            this.placeFlagHasCharacter = false;
            this.characterId = -1;
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public MATRIX getMatrix() {
        if (this.placeFlagHasMatrix) {
            return this.matrix;
        }
        return null;
    }

    @Override
    public void setMatrix(MATRIX matrix) {
        this.matrix = matrix;
    }

    @Override
    public String getInstanceName() {
        if (this.placeFlagHasName) {
            return this.name;
        }
        return null;
    }

    @Override
    public ColorTransform getColorTransform() {
        if (this.placeFlagHasColorTransform) {
            return this.colorTransform;
        }
        return null;
    }

    @Override
    public int getBlendMode() {
        return this.blendMode;
    }

    @Override
    public String getClassName() {
        if (this.placeFlagHasClassName) {
            return this.className;
        }
        return null;
    }

    @Override
    public boolean cacheAsBitmap() {
        return this.placeFlagHasCacheAsBitmap && this.bitmapCache == 1;
    }

    @Override
    public boolean isVisible() {
        if (this.placeFlagHasVisible) {
            return this.visible == 1;
        }
        return true;
    }

    @Override
    public Integer getVisible() {
        if (this.placeFlagHasVisible) {
            return this.visible;
        }
        return null;
    }

    @Override
    public RGBA getBackgroundColor() {
        if (this.placeFlagOpaqueBackground) {
            return this.backgroundColor;
        }
        return null;
    }

    @Override
    public boolean flagMove() {
        return this.placeFlagMove;
    }

    @Override
    public int getRatio() {
        if (!this.placeFlagHasRatio) {
            return -1;
        }
        return this.ratio;
    }

    @Override
    public void setInstanceName(String name) {
        this.placeFlagHasName = true;
        this.name = name;
    }

    @Override
    public void setClassName(String className) {
        this.placeFlagHasClassName = true;
        this.className = className;
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        if (this.placeFlagHasName) {
            ret.put("nm", "\"" + Helper.escapePCodeString(this.name) + "\"");
        }
        return ret;
    }

    @Override
    public CLIPACTIONS getClipActions() {
        if (this.placeFlagHasClipActions) {
            return this.clipActions;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTagWithMatrix(SWFOutputStream sos, MATRIX m) throws IOException {
        MATRIX old = this.matrix;
        this.matrix = m;
        boolean mod = this.isModified();
        this.setModified(true);
        try {
            super.writeTag(sos);
        }
        finally {
            this.setModified(mod);
            this.matrix = old;
        }
    }

    @Override
    public Amf3Value getAmfData() {
        return null;
    }

    @Override
    public Integer getBitmapCache() {
        if (this.placeFlagHasCacheAsBitmap) {
            return this.bitmapCache;
        }
        return null;
    }

    @Override
    public void setClipActions(CLIPACTIONS clipActions) {
        this.clipActions = clipActions;
    }

    @Override
    public void setPlaceFlagHasClipActions(boolean placeFlagHasClipActions) {
        this.placeFlagHasClipActions = placeFlagHasClipActions;
    }

    @Override
    public void setPlaceFlagHasMatrix(boolean placeFlagHasMatrix) {
        this.placeFlagHasMatrix = placeFlagHasMatrix;
    }

    @Override
    public void setPlaceFlagMove(boolean placeFlagMove) {
        this.placeFlagMove = placeFlagMove;
    }

    @Override
    public boolean hasImage() {
        return this.placeFlagHasImage;
    }

    @Override
    public void setColorTransform(ColorTransform colorTransform) {
        this.colorTransform = new CXFORMWITHALPHA(colorTransform);
        this.placeFlagHasColorTransform = true;
    }

    @Override
    public void setVisible(int value) {
        this.visible = value;
        this.placeFlagHasVisible = true;
    }

    @Override
    public void setPlaceFlagHasVisible(boolean value) {
        this.placeFlagHasVisible = value;
    }

    @Override
    public void setBlendMode(int value) {
        this.blendMode = value;
        this.placeFlagHasBlendMode = true;
    }

    @Override
    public void setPlaceFlagHasBlendMode(boolean value) {
        this.placeFlagHasBlendMode = value;
    }

    @Override
    public void setBitmapCache(int value) {
        this.bitmapCache = value;
        this.placeFlagHasCacheAsBitmap = true;
    }

    @Override
    public void setPlaceFlagHasCacheAsBitmap(boolean value) {
        this.placeFlagHasCacheAsBitmap = value;
    }

    @Override
    public void setBackgroundColor(RGBA value) {
        this.backgroundColor = value;
        this.placeFlagOpaqueBackground = true;
    }

    @Override
    public void setPlaceFlagOpaqueBackground(boolean value) {
        this.placeFlagOpaqueBackground = value;
    }

    @Override
    public void setPlaceFlagHasFilterList(boolean placeFlagHasFilterList) {
        this.placeFlagHasFilterList = placeFlagHasFilterList;
    }

    @Override
    public void setFilters(List<FILTER> filters) {
        this.surfaceFilterList = new ArrayList<FILTER>(filters);
        this.placeFlagHasFilterList = true;
    }

    @Override
    public void setPlaceFlagHasRatio(boolean placeFlagHasRatio) {
        this.placeFlagHasRatio = placeFlagHasRatio;
    }

    @Override
    public void setRatio(int ratio) {
        this.ratio = ratio;
        this.placeFlagHasRatio = true;
    }
}

