/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=9)
public class SymbolClassTag
extends SymbolClassTypeTag {
    public static final int ID = 76;
    public static final String NAME = "SymbolClass";
    @SWFType(value=BasicType.UI16)
    @SWFArray(value="tag", countField="numSymbols")
    @Table(value="symbols", itemName="symbol")
    public List<Integer> tags;
    @SWFArray(value="name", countField="numSymbols")
    @Table(value="symbols", itemName="symbol")
    @DottedIdentifier(as3=true)
    public List<String> names;

    @Override
    public Map<Integer, String> getTagToNameMap() {
        HashMap<Integer, String> exportNames = new HashMap<Integer, String>();
        for (int i = 0; i < this.tags.size(); ++i) {
            int tagId = this.tags.get(i);
            String name = this.names.get(i);
            if (exportNames.containsKey(tagId) || exportNames.containsValue(name)) continue;
            exportNames.put(tagId, name);
        }
        return exportNames;
    }

    public SymbolClassTag(SWF swf) {
        super(swf, 76, NAME, null);
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
    }

    public SymbolClassTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 76, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        int numSymbols = sis.readUI16("numSymbols");
        this.tags = new ArrayList<Integer>(numSymbols);
        this.names = new ArrayList<String>(numSymbols);
        for (int i = 0; i < numSymbols; ++i) {
            int tagID = sis.readUI16("tagID");
            String className = sis.readString("className");
            this.tags.add(tagID);
            this.names.add(className);
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        int numSymbols = this.tags.size();
        sos.writeUI16(numSymbols);
        for (int i = 0; i < numSymbols; ++i) {
            sos.writeUI16(this.tags.get(i));
            sos.writeString(this.names.get(i));
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i) != oldCharacterId) continue;
            this.tags.set(i, newCharacterId);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i) != characterId) continue;
            this.tags.remove(i);
            this.names.remove(i);
            --i;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        for (int t : this.tags) {
            if (t == 0) continue;
            needed.add(t);
        }
    }
}

