/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.Map;

public class DefineExternalGradient
extends Tag {
    public static final int ID = 1003;
    public static final String NAME = "DefineExternalGradient";
    public static final int BITMAP_FORMAT_DEFAULT = 0;
    public static final int BITMAP_FORMAT_TGA = 1;
    public static final int BITMAP_FORMAT_DDS = 2;
    public int gradientId;
    public int bitmapsFormat;
    public int gradientSize;
    public String fileName;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.gradientId);
        sos.writeUI16(this.bitmapsFormat);
        sos.writeUI16(this.gradientSize);
        sos.writeNetString(this.fileName);
    }

    public DefineExternalGradient(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1003, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public DefineExternalGradient(SWF swf) {
        super(swf, 1003, NAME, null);
        this.fileName = "";
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.gradientId = sis.readUI16("gradientId");
        this.bitmapsFormat = sis.readUI16("bitmapsFormat");
        this.gradientSize = sis.readUI16("gradientSize");
        this.fileName = sis.readNetString("fileName");
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        ret.put("gid", "" + this.getUniqueId());
        return ret;
    }

    @Override
    public String getUniqueId() {
        return "g" + this.gradientId;
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        tagInfo.addInfo("general", "fileName", this.fileName);
        String bitmapFormatStr = "0x" + Integer.toHexString(this.bitmapsFormat);
        switch (this.bitmapsFormat) {
            case 0: {
                bitmapFormatStr = "default (0)";
                break;
            }
            case 1: {
                bitmapFormatStr = "TGA (1)";
                break;
            }
            case 2: {
                bitmapFormatStr = "DDS (2)";
            }
        }
        tagInfo.addInfo("general", "bitmapsFormat", bitmapFormatStr);
        tagInfo.addInfo("general", "gradientSize", this.gradientSize);
    }
}

