/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.gfx.AbstractGfxImageTag;
import com.jpexs.decompiler.flash.tags.gfx.enums.FileFormatType;
import com.jpexs.decompiler.flash.tags.gfx.enums.IdType;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public class DefineExternalImage2
extends AbstractGfxImageTag {
    public static final int ID = 1009;
    public static final String NAME = "DefineExternalImage2";
    public int imageID;
    public int idType;
    public int bitmapFormat;
    public int targetWidth;
    public int targetHeight;
    public String exportName;
    public String fileName;
    public byte[] extraData;
    @HideInRawEdit
    private SerializableImage serImage;
    @HideInRawEdit
    private String cachedImageFilename = null;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.imageID);
        sos.writeUI16(this.idType);
        sos.writeUI16(this.bitmapFormat);
        sos.writeUI16(this.targetWidth);
        sos.writeUI16(this.targetHeight);
        sos.writeNetString(this.exportName);
        sos.writeNetString(this.fileName);
        if (this.extraData != null) {
            sos.write(this.extraData);
        }
    }

    public DefineExternalImage2(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1009, NAME, data);
        this.readData(sis, data, 0, false, false, false);
        this.characterID = this.idType == 0 ? this.imageID : -1;
    }

    public DefineExternalImage2(SWF swf) {
        super(swf, 1009, NAME, null);
        this.exportName = "";
        this.fileName = "";
        this.targetWidth = 1;
        this.targetHeight = 1;
        this.idType = 0;
        this.bitmapFormat = 14;
        this.characterID = -1;
        this.createFailedImage();
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.imageID = sis.readUI16("imageID");
        this.idType = sis.readUI16("idType");
        this.bitmapFormat = sis.readUI16("bitmapFormat");
        this.targetWidth = sis.readUI16("targetWidth");
        this.targetHeight = sis.readUI16("targetHeight");
        this.exportName = sis.readNetString("exportName");
        this.fileName = sis.readNetString("fileName");
        if (sis.available() > 0) {
            this.extraData = sis.readBytesEx(sis.available(), "extraData");
        }
    }

    private void createFailedImage() {
        if (this.targetWidth <= 0 || this.targetHeight <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        this.serImage = new SerializableImage(this.targetWidth, this.targetHeight, 3);
        Graphics g = this.serImage.getGraphics();
        g.setColor(SWF.ERROR_COLOR);
        g.fillRect(0, 0, this.targetWidth, this.targetHeight);
        this.cachedImageFilename = null;
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        this.serImage = new SerializableImage(ImageHelper.read(data));
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    public SerializableImage getImage() {
        this.initImage();
        return this.serImage;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.targetWidth, this.targetHeight);
    }

    private void initImage() {
        if (Objects.equals(this.cachedImageFilename, this.fileName) && this.serImage != null && this.serImage.getWidth() == this.targetWidth && this.serImage.getHeight() == this.targetHeight) {
            return;
        }
        if (this.targetWidth <= 0 || this.targetHeight <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        BufferedImage bufImage = this.getExternalBufferedImage(this.fileName, this.bitmapFormat);
        if (bufImage == null) {
            this.createFailedImage();
            return;
        }
        Image scaled = bufImage.getScaledInstance(this.targetWidth, this.targetHeight, 1);
        bufImage = new BufferedImage(this.targetWidth, this.targetHeight, 2);
        bufImage.getGraphics().drawImage(scaled, 0, 0, null);
        this.serImage = new SerializableImage(bufImage);
        this.cachedImageFilename = this.fileName;
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        ret.put("iid", "" + this.getUniqueId());
        return ret;
    }

    @Override
    public String getUniqueId() {
        if (this.idType == 0) {
            return super.getUniqueId();
        }
        return "i" + this.imageID;
    }

    @Override
    public void setCharacterId(int characterId) {
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        tagInfo.addInfo("general", "exportName", this.exportName);
        tagInfo.addInfo("general", "fileName", this.fileName);
        String bitmapFormatStr = "0x" + Integer.toHexString(this.bitmapFormat);
        String fileFormatStr = FileFormatType.fileFormatToString(this.bitmapFormat);
        if (fileFormatStr != null) {
            bitmapFormatStr = fileFormatStr + " (" + this.bitmapFormat + ")";
        }
        tagInfo.addInfo("general", "bitmapFormat", bitmapFormatStr);
        if (this.idType != 0) {
            tagInfo.addInfo("general", "imageId", this.imageID);
        }
        tagInfo.addInfo("general", "idType", IdType.idTypeToString(this.idType) + " (" + this.idType + ")");
    }
}

