/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DefineExternalStreamSound
extends Tag
implements CharacterIdTag,
SoundTag {
    public static final int ID = 1007;
    public static final String NAME = "DefineExternalStreamSound";
    public int soundFormat;
    public int bits;
    public int channels;
    public long sampleRate;
    public long sampleCount;
    public long seekSample;
    public long startFrame;
    public long lastFrame;
    public String fileName;
    public static final int SOUND_FORMAT_WAV = 0;
    @Internal
    private int virtualCharacterId = -1;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.soundFormat);
        sos.writeUI16(this.bits);
        sos.writeUI16(this.channels);
        sos.writeUI32(this.sampleRate);
        sos.writeUI32(this.sampleCount);
        sos.writeUI32(this.seekSample);
        sos.writeUI32(this.startFrame);
        sos.writeUI32(this.lastFrame);
        sos.writeNetString(this.fileName);
    }

    public DefineExternalStreamSound(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1007, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public DefineExternalStreamSound(SWF swf) {
        super(swf, 1007, NAME, null);
        this.fileName = "";
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.soundFormat = sis.readUI16("soundFormat");
        this.bits = sis.readUI16("bits");
        this.channels = sis.readUI16("channels");
        this.sampleRate = sis.readUI32("sampleRate");
        this.sampleCount = sis.readUI32("sampleCount");
        this.seekSample = sis.readUI32("seekSample");
        this.startFrame = sis.readUI32("startFrame");
        this.lastFrame = sis.readUI32("lastFrame");
        this.fileName = sis.readNetString("fileName");
    }

    @Override
    public SoundExportFormat getExportFormat() {
        return SoundExportFormat.WAV;
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public int getSoundRate() {
        switch ((int)this.sampleRate) {
            case 5512: {
                return 0;
            }
            case 11025: {
                return 1;
            }
            case 22050: {
                return 2;
            }
            case 44100: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public boolean getSoundType() {
        return this.channels == 2;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ByteArrayRange> getRawSoundData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getSoundFormatId() {
        return 3;
    }

    @Override
    public long getTotalSoundSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean getSoundSize() {
        return this.bits == 16;
    }

    @Override
    public SoundFormat getSoundFormat() {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        return new SoundFormat(this.getSoundFormatId(), rateMap[this.getSoundRate()], this.getSoundType());
    }

    @Override
    public void setSoundSize(boolean soundSize) {
        this.bits = soundSize ? 16 : 8;
    }

    @Override
    public void setSoundType(boolean soundType) {
        this.channels = soundType ? 2 : 1;
    }

    @Override
    public void setSoundSampleCount(long soundSampleCount) {
        this.sampleCount = soundSampleCount;
    }

    @Override
    public void setSoundCompression(int soundCompression) {
    }

    @Override
    public void setSoundRate(int soundRate) {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        this.sampleRate = rateMap[soundRate];
    }

    @Override
    public int getCharacterId() {
        return this.virtualCharacterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.virtualCharacterId = characterId;
    }

    @Override
    public String getCharacterExportFileName() {
        return "" + this.getCharacterId();
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        ret.put("chid", "" + this.virtualCharacterId);
        return ret;
    }

    @Override
    public String getUniqueId() {
        return "" + this.virtualCharacterId;
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        SoundFormat soundFormat = this.getSoundFormat();
        tagInfo.addInfo("general", "fileName", this.fileName);
        tagInfo.addInfo("general", "codecName", soundFormat.getFormatName());
        tagInfo.addInfo("general", "exportFormat", (Object)soundFormat.getNativeExportFormat());
        tagInfo.addInfo("general", "samplingRate", soundFormat.samplingRate);
        tagInfo.addInfo("general", "stereo", soundFormat.stereo);
        tagInfo.addInfo("general", "sampleCount", this.sampleCount);
    }

    @Override
    public String getFlaExportName() {
        return "sound" + this.getCharacterId();
    }

    @Override
    public int getInitialLatency() {
        return 0;
    }
}

