/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject4Tag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class DepthState {
    public int depth = -1;
    public int characterId = -1;
    public MATRIX matrix;
    public MATRIX temporaryMatrix;
    public String instanceName;
    public String className;
    public ColorTransform colorTransForm;
    public boolean cacheAsBitmap = false;
    public int blendMode = 0;
    public List<FILTER> filters = new ArrayList<FILTER>();
    public boolean isVisible = true;
    public RGBA backGroundColor;
    public CLIPACTIONS clipActions;
    public byte[] amfData;
    public int ratio = -1;
    public boolean key = false;
    public int clipDepth = -1;
    public int time = 0;
    private final SWF swf;
    public Frame frame;
    public Frame placeFrame;
    public PlaceObjectTypeTag placeObjectTag;
    public int minPlaceObjectNum;
    public long instanceId;
    public boolean motionTween = false;
    public boolean hasImage = false;
    private static AtomicLong lastInstanceId = new AtomicLong(0L);

    public static long getNewInstanceId() {
        return lastInstanceId.addAndGet(1L);
    }

    public DepthState(SWF swf, Frame frame, Frame placeFrame) {
        this.swf = swf;
        this.frame = frame;
        this.placeFrame = placeFrame;
        this.instanceId = DepthState.getNewInstanceId();
    }

    public DepthState(DepthState obj, Frame frame, Frame placeFrame, boolean sameInstance) {
        this.frame = frame;
        this.placeFrame = placeFrame;
        this.swf = obj.swf;
        this.characterId = obj.characterId;
        this.matrix = obj.matrix;
        this.instanceName = obj.instanceName;
        this.colorTransForm = obj.colorTransForm;
        this.className = obj.className;
        this.cacheAsBitmap = obj.cacheAsBitmap;
        this.blendMode = obj.blendMode;
        this.filters = obj.filters;
        this.isVisible = obj.isVisible;
        this.backGroundColor = obj.backGroundColor;
        this.clipActions = obj.clipActions;
        this.ratio = obj.ratio;
        this.clipDepth = obj.clipDepth;
        this.time = obj.time;
        this.placeObjectTag = obj.placeObjectTag;
        this.minPlaceObjectNum = obj.minPlaceObjectNum;
        this.depth = obj.depth;
        if (sameInstance) {
            ++this.time;
            this.instanceId = obj.instanceId;
        } else {
            this.instanceId = DepthState.getNewInstanceId();
        }
    }

    public void setMATRIX(MATRIX matrix) {
        this.matrix = matrix;
        this.placeObjectTag.setMatrix(matrix);
        this.placeObjectTag.setPlaceFlagHasMatrix(matrix != null);
    }

    public boolean cacheAsBitmap() {
        return this.placeObjectTag != null && this.placeObjectTag.cacheAsBitmap() || this.filters != null && !this.filters.isEmpty();
    }

    public PlaceObjectTypeTag toPlaceObjectTag(int depth) {
        if (this.minPlaceObjectNum <= 1) {
            CXFORM cxForm0 = this.colorTransForm == null ? null : new CXFORM(this.colorTransForm);
            return new PlaceObjectTag(this.swf, this.characterId, depth, this.matrix, cxForm0);
        }
        if (this.minPlaceObjectNum == 2) {
            CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
            return new PlaceObject2Tag(this.swf, false, depth, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.clipActions);
        }
        if (this.minPlaceObjectNum == 3) {
            CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
            return new PlaceObject3Tag(this.swf, false, depth, this.className, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.filters, this.blendMode, this.cacheAsBitmap ? 1 : 0, this.isVisible ? 1 : 0, this.backGroundColor, this.clipActions, this.hasImage);
        }
        CXFORMWITHALPHA cxForm = this.colorTransForm == null ? null : new CXFORMWITHALPHA(this.colorTransForm);
        return new PlaceObject4Tag(this.swf, false, depth, this.className, this.characterId, this.matrix, cxForm, this.ratio, this.instanceName, this.clipDepth, this.filters, this.blendMode, this.cacheAsBitmap ? 1 : 0, this.isVisible ? 1 : 0, this.backGroundColor, this.clipActions, null, this.hasImage);
    }

    public CharacterTag getCharacter() {
        if (this.characterId == -1) {
            if (this.className != null) {
                return this.swf.getCharacterByClass(this.className);
            }
            return null;
        }
        return this.swf.getCharacter(this.characterId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.depth;
        hash = 29 * hash + this.characterId;
        hash = 29 * hash + Objects.hashCode(this.matrix);
        hash = 29 * hash + Objects.hashCode(this.instanceName);
        hash = 29 * hash + Objects.hashCode(this.className);
        hash = 29 * hash + Objects.hashCode(this.colorTransForm);
        hash = 29 * hash + (this.cacheAsBitmap ? 1 : 0);
        hash = 29 * hash + this.blendMode;
        hash = 29 * hash + Objects.hashCode(this.filters);
        hash = 29 * hash + (this.isVisible ? 1 : 0);
        hash = 29 * hash + Objects.hashCode(this.backGroundColor);
        hash = 29 * hash + Objects.hashCode(this.clipActions);
        hash = 29 * hash + Arrays.hashCode(this.amfData);
        hash = 29 * hash + this.ratio;
        hash = 29 * hash + this.clipDepth;
        hash = 29 * hash + this.time;
        hash = 29 * hash + (this.hasImage ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DepthState other = (DepthState)obj;
        if (this.depth != other.depth) {
            return false;
        }
        if (this.characterId != other.characterId) {
            return false;
        }
        if (this.cacheAsBitmap != other.cacheAsBitmap) {
            return false;
        }
        if (this.blendMode != other.blendMode) {
            return false;
        }
        if (this.isVisible != other.isVisible) {
            return false;
        }
        if (this.ratio != other.ratio) {
            return false;
        }
        if (this.clipDepth != other.clipDepth) {
            return false;
        }
        if (this.hasImage != other.hasImage) {
            return false;
        }
        if (!Objects.equals(this.instanceName, other.instanceName)) {
            return false;
        }
        if (!Objects.equals(this.className, other.className)) {
            return false;
        }
        if (!Objects.equals(this.matrix, other.matrix)) {
            return false;
        }
        if (!Objects.equals(this.colorTransForm, other.colorTransForm)) {
            return false;
        }
        if (!Objects.equals(this.filters, other.filters)) {
            return false;
        }
        if (!Objects.equals(this.backGroundColor, other.backGroundColor)) {
            return false;
        }
        if (!Objects.equals(this.clipActions, other.clipActions)) {
            return false;
        }
        return Arrays.equals(this.amfData, other.amfData);
    }

    public MATRIX getDrawingMatrix() {
        MATRIX temp = this.temporaryMatrix;
        if (temp != null) {
            return temp;
        }
        return this.matrix;
    }
}

