/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.timeline.SceneFrame;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.Objects;

public class Scene
implements TreeItem {
    private SWF swf;
    public int startFrame;
    public int endFrame;
    public String name;

    public Scene(SWF swf, int startFrame, int endFrame, String name) {
        this.swf = swf;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.name = name;
    }

    public int getSceneFrameCount() {
        return this.endFrame - this.startFrame + 1;
    }

    public SceneFrame getSceneFrame(int sceneFrameIndex) {
        if (sceneFrameIndex >= this.getSceneFrameCount()) {
            throw new IndexOutOfBoundsException("Invalid sceneframe index");
        }
        return new SceneFrame(this.swf, this, this.startFrame + sceneFrameIndex);
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.swf);
        hash = 97 * hash + this.startFrame;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scene other = (Scene)obj;
        if (this.startFrame != other.startFrame) {
            return false;
        }
        return Objects.equals(this.swf, other.swf);
    }

    public String toString() {
        return this.name;
    }
}

