/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.image.RescaleOp;

public class ColorTransform
implements Cloneable {
    private int redAdd;
    private int greenAdd;
    private int blueAdd;
    private int alphaAdd;
    private int redMulti;
    private int greenMulti;
    private int blueMulti;
    private int alphaMulti;

    public RescaleOp toRescaleOp() {
        return new RescaleOp(new float[]{(float)this.getRedMulti() / 256.0f, (float)this.getGreenMulti() / 256.0f, (float)this.getBlueMulti() / 256.0f, (float)this.getAlphaMulti() / 256.0f}, new float[]{this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd()}, null);
    }

    public SerializableImage apply(SerializableImage src) {
        return Filtering.colorEffect(src, this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd(), this.getRedMulti(), this.getGreenMulti(), this.getBlueMulti(), this.getAlphaMulti());
    }

    public int apply(int color) {
        return Filtering.colorEffect(color, this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd(), this.getRedMulti(), this.getGreenMulti(), this.getBlueMulti(), this.getAlphaMulti());
    }

    public RGB apply(RGB color) {
        if (color == null) {
            return null;
        }
        return new RGBA(Filtering.colorEffect(color.toInt(), this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd(), this.getRedMulti(), this.getGreenMulti(), this.getBlueMulti(), this.getAlphaMulti()));
    }

    public RGBA apply(RGBA color) {
        if (color == null) {
            return null;
        }
        return new RGBA(Filtering.colorEffect(color.toInt(), this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd(), this.getRedMulti(), this.getGreenMulti(), this.getBlueMulti(), this.getAlphaMulti()));
    }

    public Color apply(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(Filtering.colorEffect(color.getRGB(), this.getRedAdd(), this.getGreenAdd(), this.getBlueAdd(), this.getAlphaAdd(), this.getRedMulti(), this.getGreenMulti(), this.getBlueMulti(), this.getAlphaMulti()));
    }

    public GRADRECORD[] apply(GRADRECORD[] gradRecords) {
        GRADRECORD[] ret = new GRADRECORD[gradRecords.length];
        for (int i = 0; i < gradRecords.length; ++i) {
            GRADRECORD r = gradRecords[i];
            GRADRECORD r2 = new GRADRECORD();
            r2.inShape3 = r.inShape3;
            r2.ratio = r.ratio;
            r2.color = this.apply(r.color);
            ret[i] = r2;
        }
        return ret;
    }

    public int getRedAdd() {
        return 0;
    }

    public int getGreenAdd() {
        return 0;
    }

    public int getBlueAdd() {
        return 0;
    }

    public int getAlphaAdd() {
        return 0;
    }

    public int getRedMulti() {
        return 256;
    }

    public int getGreenMulti() {
        return 256;
    }

    public int getBlueMulti() {
        return 256;
    }

    public int getAlphaMulti() {
        return 256;
    }

    public ColorTransform merge(final ColorTransform c) {
        final ColorTransform t = this;
        return new ColorTransform(){

            @Override
            public int getRedAdd() {
                return t.getRedAdd() + c.getRedAdd();
            }

            @Override
            public int getGreenAdd() {
                return t.getGreenAdd() + c.getGreenAdd();
            }

            @Override
            public int getBlueAdd() {
                return t.getBlueAdd() + c.getBlueAdd();
            }

            @Override
            public int getAlphaAdd() {
                return t.getAlphaAdd() + c.getAlphaAdd();
            }

            @Override
            public int getRedMulti() {
                return (int)((float)t.getRedMulti() / 256.0f * (float)c.getRedMulti());
            }

            @Override
            public int getGreenMulti() {
                return (int)((float)t.getGreenMulti() / 256.0f * (float)c.getGreenMulti());
            }

            @Override
            public int getBlueMulti() {
                return (int)((float)t.getBlueMulti() / 256.0f * (float)c.getBlueMulti());
            }

            @Override
            public int getAlphaMulti() {
                return (int)((float)t.getAlphaMulti() / 256.0f * (float)c.getAlphaMulti());
            }
        };
    }

    public String toString() {
        return "[colorTransform redAdd=" + this.getRedAdd() + ", greenAdd=" + this.getGreenAdd() + ", blueAdd=" + this.getBlueAdd() + ", alphaAdd=" + this.getAlphaAdd() + ", redMulti=" + this.getRedMulti() + ", greenMulti=" + this.getGreenMulti() + ", blueMulti=" + this.getBlueMulti() + ", alphaMulti=" + this.getAlphaMulti() + "]";
    }

    public ColorTransform clone() {
        try {
            return (ColorTransform)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.getRedAdd();
        hash = 97 * hash + this.getGreenAdd();
        hash = 97 * hash + this.getBlueAdd();
        hash = 97 * hash + this.getAlphaAdd();
        hash = 97 * hash + this.getRedMulti();
        hash = 97 * hash + this.getGreenMulti();
        hash = 97 * hash + this.getBlueMulti();
        hash = 97 * hash + this.getAlphaMulti();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorTransform)) {
            return false;
        }
        ColorTransform other = (ColorTransform)obj;
        if (this.getRedAdd() != other.getRedAdd()) {
            return false;
        }
        if (this.getGreenAdd() != other.getGreenAdd()) {
            return false;
        }
        if (this.getBlueAdd() != other.getBlueAdd()) {
            return false;
        }
        if (this.getAlphaAdd() != other.getAlphaAdd()) {
            return false;
        }
        if (this.getRedMulti() != other.getRedMulti()) {
            return false;
        }
        if (this.getGreenMulti() != other.getGreenMulti()) {
            return false;
        }
        if (this.getBlueMulti() != other.getBlueMulti()) {
            return false;
        }
        return this.getAlphaMulti() == other.getAlphaMulti();
    }
}

