/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Calculated;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.awt.Point;
import java.io.Serializable;

public class MATRIX
implements Serializable {
    public boolean hasScale;
    @Conditional(value={"hasScale"})
    @SWFType(value=BasicType.FB, countField="nScaleBits")
    public float scaleX;
    @Conditional(value={"hasScale"})
    @SWFType(value=BasicType.FB, countField="nScaleBits")
    public float scaleY;
    public boolean hasRotate;
    @Conditional(value={"hasRotate"})
    @SWFType(value=BasicType.FB, countField="nRotateBits")
    public float rotateSkew0;
    @Conditional(value={"hasRotate"})
    @SWFType(value=BasicType.FB, countField="nRotateBits")
    public float rotateSkew1;
    @SWFType(value=BasicType.SB, countField="nTranslateBits")
    public int translateX;
    @SWFType(value=BasicType.SB, countField="nTranslateBits")
    public int translateY;
    @Calculated
    @SWFType(value=BasicType.UB, count=5)
    public int nTranslateBits;
    @Calculated
    @SWFType(value=BasicType.UB, count=5)
    public int nRotateBits;
    @Calculated
    @SWFType(value=BasicType.UB, count=5)
    public int nScaleBits;

    public MATRIX() {
    }

    public MATRIX(MATRIX m) {
        if (m == null) {
            return;
        }
        this.hasScale = m.hasScale;
        this.hasRotate = m.hasRotate;
        this.scaleX = m.scaleX;
        this.scaleY = m.scaleY;
        this.rotateSkew0 = m.rotateSkew0;
        this.rotateSkew1 = m.rotateSkew1;
        this.translateX = m.translateX;
        this.translateY = m.translateY;
    }

    public String toString() {
        return "[MATRIX scale:" + this.getScaleXFloat() + "," + this.getScaleYFloat() + ", rotate:" + this.getRotateSkew0Float() + "," + this.getRotateSkew1Float() + ", translate:" + this.translateX + "," + this.translateY + "]";
    }

    public static float toFloat(int i) {
        return (float)i / 65536.0f;
    }

    public Point apply(Point p) {
        Point ret = new Point();
        ret.x = (int)((float)p.x * (this.hasScale ? this.scaleX : 1.0f) + (float)p.y * (this.hasRotate ? this.rotateSkew1 : 0.0f) + (float)this.translateX);
        ret.y = (int)((float)p.x * (this.hasRotate ? this.rotateSkew0 : 0.0f) + (float)p.y * (this.hasScale ? this.scaleY : 1.0f) + (float)this.translateY);
        return ret;
    }

    public RECT apply(RECT r) {
        Point topLeft = this.apply(r.getTopLeft());
        Point bottomRight = this.apply(r.getBottomRight());
        int Xmin = Math.min(topLeft.x, bottomRight.x);
        int Ymin = Math.min(topLeft.y, bottomRight.y);
        int Xmax = Math.max(topLeft.x, bottomRight.x);
        int Ymax = Math.max(topLeft.y, bottomRight.y);
        return new RECT(Xmin, Xmax, Ymin, Ymax);
    }

    private int fromFloat(double f) {
        return (int)(f * 65536.0);
    }

    public int getRotateSkew0Integer() {
        return this.hasRotate ? this.fromFloat(this.rotateSkew0) : 0;
    }

    public int getRotateSkew1Integer() {
        return this.hasRotate ? this.fromFloat(this.rotateSkew1) : 0;
    }

    public float getRotateSkew0Float() {
        return this.hasRotate ? this.rotateSkew0 : 0.0f;
    }

    public float getRotateSkew1Float() {
        return this.hasRotate ? this.rotateSkew1 : 0.0f;
    }

    public float getScaleXFloat() {
        return this.hasScale ? this.scaleX : 1.0f;
    }

    public float getScaleYFloat() {
        return this.hasScale ? this.scaleY : 1.0f;
    }

    public int getScaleXInteger() {
        return this.hasScale ? this.fromFloat(this.scaleX) : 65536;
    }

    public int getScaleYInteger() {
        return this.hasScale ? this.fromFloat(this.scaleY) : 65536;
    }

    public boolean isEmpty() {
        return this.translateX == 0 && this.translateY == 0 && !this.hasRotate && !this.hasScale;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.getScaleXInteger();
        hash = 37 * hash + this.getScaleYInteger();
        hash = 37 * hash + this.getRotateSkew0Integer();
        hash = 37 * hash + this.getRotateSkew1Integer();
        hash = 37 * hash + this.translateX;
        hash = 37 * hash + this.translateY;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MATRIX other = (MATRIX)obj;
        if (this.getScaleXInteger() != other.getScaleXInteger()) {
            return false;
        }
        if (this.getScaleYInteger() != other.getScaleYInteger()) {
            return false;
        }
        if (this.getRotateSkew0Integer() != other.getRotateSkew0Integer()) {
            return false;
        }
        if (this.getRotateSkew1Integer() != other.getRotateSkew1Integer()) {
            return false;
        }
        if (this.translateX != other.translateX) {
            return false;
        }
        return this.translateY == other.translateY;
    }
}

