/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.awt.Color;
import java.io.Serializable;

public class RGB
implements Serializable {
    @SWFType(value=BasicType.UI8)
    public int red;
    @SWFType(value=BasicType.UI8)
    public int green;
    @SWFType(value=BasicType.UI8)
    public int blue;

    public RGB(RGB color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
    }

    public RGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public RGB() {
    }

    public String toHexRGB() {
        String bh;
        String gh;
        String rh = Integer.toHexString(this.red);
        if (rh.length() < 2) {
            rh = "0" + rh;
        }
        if ((gh = Integer.toHexString(this.green)).length() < 2) {
            gh = "0" + gh;
        }
        if ((bh = Integer.toHexString(this.blue)).length() < 2) {
            bh = "0" + bh;
        }
        return "#" + rh + gh + bh;
    }

    public Color toColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public int toInt() {
        return RGB.toInt(this.red, this.green, this.blue);
    }

    public static int toInt(int red, int green, int blue) {
        return 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public RGB(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
    }

    public RGB(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
    }

    public String toString() {
        if (Configuration.useHexColorFormat.get().booleanValue()) {
            return "[RGB " + this.toHexRGB() + "]";
        }
        return "[RGB red:" + this.red + ", green:" + this.green + ", blue:" + this.blue + "]";
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.red;
        hash = 97 * hash + this.green;
        hash = 97 * hash + this.blue;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGB other = (RGB)obj;
        if (this.red != other.red) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.blue == other.blue;
    }
}

