/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RGBA
extends RGB
implements Serializable {
    @SWFType(value=BasicType.UI8)
    public int alpha;

    public float getAlphaFloat() {
        return (float)this.alpha / 255.0f;
    }

    public String toHexARGB() {
        String bh;
        String gh;
        String rh;
        String ah = Integer.toHexString(this.alpha);
        if (ah.length() < 2) {
            ah = "0" + ah;
        }
        if ((rh = Integer.toHexString(this.red)).length() < 2) {
            rh = "0" + rh;
        }
        if ((gh = Integer.toHexString(this.green)).length() < 2) {
            gh = "0" + gh;
        }
        if ((bh = Integer.toHexString(this.blue)).length() < 2) {
            bh = "0" + bh;
        }
        return "#" + ah + rh + gh + bh;
    }

    public RGBA(int red, int green, int blue, int alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public RGBA(Color color) {
        super(color);
        this.alpha = color.getAlpha();
    }

    public RGBA(int rgb) {
        super(rgb);
        this.alpha = rgb >> 24 & 0xFF;
    }

    public RGBA(RGB color) {
        super(color);
        this.alpha = color instanceof RGBA ? ((RGBA)color).alpha : 255;
    }

    public static RGBA fromHexARGB(String hex) {
        Pattern hexPat = Pattern.compile("^#(?<a>[0-9a-fA-F]{2})(?<r>[0-9a-fA-F]{2})(?<g>[0-9a-fA-F]{2})(?<b>[0-9a-fA-F]{2})$");
        Matcher m = hexPat.matcher(hex);
        if (!m.matches()) {
            throw new NumberFormatException("Not a valid color code with alpha");
        }
        int a = Integer.parseInt(m.group("a"), 16);
        int r = Integer.parseInt(m.group("r"), 16);
        int g = Integer.parseInt(m.group("g"), 16);
        int b = Integer.parseInt(m.group("b"), 16);
        return new RGBA(r, g, b, a);
    }

    public RGBA() {
    }

    @Override
    public Color toColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public int toInt() {
        return RGBA.toInt(this.red, this.green, this.blue, this.alpha);
    }

    public static int toInt(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    @Override
    public String toString() {
        if (Configuration.useHexColorFormat.get().booleanValue()) {
            return "[RGB " + this.toHexRGB() + "]";
        }
        return "[RGB red:" + this.red + ", green:" + this.green + ", blue:" + this.blue + ", alpha:" + this.alpha + "]";
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.red;
        hash = 97 * hash + this.green;
        hash = 97 * hash + this.blue;
        hash = 97 * hash + this.alpha;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RGB && !(obj instanceof RGBA)) {
            RGBA other = (RGBA)obj;
            if (this.alpha != 255) {
                return false;
            }
            if (this.red != other.red) {
                return false;
            }
            if (this.green != other.green) {
                return false;
            }
            return this.blue == other.blue;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBA other = (RGBA)obj;
        if (this.red != other.red) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        return this.alpha == other.alpha;
    }
}

