/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BEVELFILTER
extends FILTER {
    public RGBA shadowColor = new RGBA(Color.BLACK);
    public RGBA highlightColor = new RGBA(Color.WHITE);
    @SWFType(value=BasicType.FIXED)
    public double blurX = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double blurY = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double angle = 0.7853981633974483;
    @SWFType(value=BasicType.FIXED)
    public double distance = 5.0;
    @SWFType(value=BasicType.UFIXED8)
    public float strength = 1.0f;
    public boolean innerShadow = true;
    public boolean knockout = false;
    public boolean compositeSource = true;
    public boolean onTop = false;
    @SWFType(value=BasicType.UB, count=4)
    public int passes = 1;

    public BEVELFILTER() {
        super(3);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        int type = 1;
        if (this.onTop && !this.innerShadow) {
            type = 3;
        } else if (!this.innerShadow) {
            type = 2;
        }
        return Filtering.bevel(src, (int)Math.round(this.blurX * zoom), (int)Math.round(this.blurY * zoom), this.strength, type, this.highlightColor.toInt(), this.shadowColor.toInt(), (int)(this.angle * 180.0 / Math.PI), (float)(this.distance * zoom), this.knockout, this.compositeSource, this.passes);
    }

    @Override
    public double getDeltaX() {
        return this.blurX + Math.abs(this.distance * Math.cos(this.angle));
    }

    @Override
    public double getDeltaY() {
        return this.blurY + Math.abs(this.distance * Math.sin(this.angle));
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        Element feComposite4;
        Element feComposite2;
        Element feComposite1;
        String shadow;
        String hilight;
        int type = 1;
        if (this.onTop && !this.innerShadow) {
            type = 3;
        } else if (!this.innerShadow) {
            type = 2;
        }
        String shadowInner = null;
        String hilightInner = null;
        if (type != 2) {
            String hilight2 = this.dropShadowSvg(this.distance, this.angle, this.highlightColor, true, true, true, 0.0, 0.0, this.strength, this.passes, document, filtersElement, exporter, in);
            String shadow2 = this.dropShadowSvg(this.distance, this.angle + Math.PI, this.shadowColor, true, true, true, 0.0, 0.0, this.strength, this.passes, document, filtersElement, exporter, in);
            Element feComposite12 = document.createElement("feComposite");
            feComposite12.setAttribute("in", hilight2);
            feComposite12.setAttribute("in2", shadow2);
            feComposite12.setAttribute("operator", "out");
            hilightInner = exporter.getUniqueId("filterResult");
            feComposite12.setAttribute("result", hilightInner);
            filtersElement.appendChild(feComposite12);
            Element feComposite22 = document.createElement("feComposite");
            feComposite22.setAttribute("in", shadow2);
            feComposite22.setAttribute("in2", hilight2);
            feComposite22.setAttribute("operator", "out");
            shadowInner = exporter.getUniqueId("filterResult");
            feComposite22.setAttribute("result", shadowInner);
            filtersElement.appendChild(feComposite22);
        }
        String shadowOuter = null;
        String hilightOuter = null;
        if (type != 1) {
            hilight = this.dropShadowSvg(this.distance, this.angle + Math.PI, this.highlightColor, false, true, true, 0.0, 0.0, this.strength, this.passes, document, filtersElement, exporter, in);
            shadow = this.dropShadowSvg(this.distance, this.angle, this.shadowColor, false, true, true, 0.0, 0.0, this.strength, this.passes, document, filtersElement, exporter, in);
            feComposite1 = document.createElement("feComposite");
            feComposite1.setAttribute("in", hilight);
            feComposite1.setAttribute("in2", shadow);
            feComposite1.setAttribute("operator", "out");
            shadowOuter = exporter.getUniqueId("filterResult");
            feComposite1.setAttribute("result", shadowOuter);
            filtersElement.appendChild(feComposite1);
            feComposite2 = document.createElement("feComposite");
            feComposite2.setAttribute("in", shadow);
            feComposite2.setAttribute("in2", hilight);
            feComposite2.setAttribute("operator", "out");
            hilightOuter = exporter.getUniqueId("filterResult");
            feComposite2.setAttribute("result", hilightOuter);
            filtersElement.appendChild(feComposite2);
        }
        hilight = null;
        shadow = null;
        switch (type) {
            case 2: {
                hilight = hilightOuter;
                shadow = shadowOuter;
                break;
            }
            case 1: {
                hilight = hilightInner;
                shadow = shadowInner;
                break;
            }
            case 3: {
                feComposite1 = document.createElement("feComposite");
                feComposite1.setAttribute("in", hilightInner);
                feComposite1.setAttribute("in2", hilightOuter);
                feComposite1.setAttribute("operator", "over");
                hilight = exporter.getUniqueId("filterResult");
                feComposite1.setAttribute("result", hilight);
                filtersElement.appendChild(feComposite1);
                feComposite2 = document.createElement("feComposite");
                feComposite2.setAttribute("in", shadowInner);
                feComposite2.setAttribute("in2", shadowOuter);
                feComposite2.setAttribute("operator", "over");
                shadow = exporter.getUniqueId("filterResult");
                feComposite2.setAttribute("result", shadow);
                filtersElement.appendChild(feComposite2);
            }
        }
        Element feComposite3 = document.createElement("feComposite");
        feComposite3.setAttribute("in", shadow);
        feComposite3.setAttribute("in2", hilight);
        feComposite3.setAttribute("operator", "over");
        String result = exporter.getUniqueId("filterResult");
        feComposite3.setAttribute("result", result);
        filtersElement.appendChild(feComposite3);
        result = this.blurSvg(this.blurX, this.blurY, this.passes, document, filtersElement, exporter, result);
        if (type == 1) {
            feComposite4 = document.createElement("feComposite");
            feComposite4.setAttribute("in", result);
            feComposite4.setAttribute("in2", in);
            feComposite4.setAttribute("operator", "in");
            result = exporter.getUniqueId("filterResult");
            feComposite4.setAttribute("result", result);
            filtersElement.appendChild(feComposite4);
        }
        if (type == 2) {
            feComposite4 = document.createElement("feComposite");
            feComposite4.setAttribute("in", result);
            feComposite4.setAttribute("in2", in);
            feComposite4.setAttribute("operator", "out");
            result = exporter.getUniqueId("filterResult");
            feComposite4.setAttribute("result", result);
            filtersElement.appendChild(feComposite4);
        }
        if (!this.knockout) {
            feComposite4 = document.createElement("feComposite");
            feComposite4.setAttribute("in", result);
            feComposite4.setAttribute("in2", in);
            feComposite4.setAttribute("operator", "over");
            result = exporter.getUniqueId("filterResult");
            feComposite4.setAttribute("result", result);
            filtersElement.appendChild(feComposite4);
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.shadowColor);
        hash = 47 * hash + Objects.hashCode(this.highlightColor);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.blurX) ^ Double.doubleToLongBits(this.blurX) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.blurY) ^ Double.doubleToLongBits(this.blurY) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.angle) ^ Double.doubleToLongBits(this.angle) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        hash = 47 * hash + Float.floatToIntBits(this.strength);
        hash = 47 * hash + (this.innerShadow ? 1 : 0);
        hash = 47 * hash + (this.knockout ? 1 : 0);
        hash = 47 * hash + (this.compositeSource ? 1 : 0);
        hash = 47 * hash + (this.onTop ? 1 : 0);
        hash = 47 * hash + this.passes;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BEVELFILTER other = (BEVELFILTER)obj;
        if (Double.doubleToLongBits(this.blurX) != Double.doubleToLongBits(other.blurX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.blurY) != Double.doubleToLongBits(other.blurY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.angle) != Double.doubleToLongBits(other.angle)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        if (Float.floatToIntBits(this.strength) != Float.floatToIntBits(other.strength)) {
            return false;
        }
        if (this.innerShadow != other.innerShadow) {
            return false;
        }
        if (this.knockout != other.knockout) {
            return false;
        }
        if (this.compositeSource != other.compositeSource) {
            return false;
        }
        if (this.onTop != other.onTop) {
            return false;
        }
        if (this.passes != other.passes) {
            return false;
        }
        if (!Objects.equals(this.shadowColor, other.shadowColor)) {
            return false;
        }
        return Objects.equals(this.highlightColor, other.highlightColor);
    }
}

