/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BLURFILTER
extends FILTER {
    @SWFType(value=BasicType.FIXED)
    public double blurX = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double blurY = 5.0;
    @SWFType(value=BasicType.UB, count=5)
    public int passes = 1;
    @Reserved
    @SWFType(value=BasicType.UB, count=3)
    public int reserved;

    public BLURFILTER() {
        super(1);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        return Filtering.blur(src, (int)Math.round(this.blurX * zoom), (int)Math.round(this.blurY * zoom), this.passes);
    }

    @Override
    public double getDeltaX() {
        return this.blurX;
    }

    @Override
    public double getDeltaY() {
        return this.blurY;
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        return this.blurSvg(this.blurX, this.blurY, this.passes, document, filtersElement, exporter, in);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.blurX) ^ Double.doubleToLongBits(this.blurX) >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.blurY) ^ Double.doubleToLongBits(this.blurY) >>> 32);
        hash = 37 * hash + this.passes;
        hash = 37 * hash + this.reserved;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BLURFILTER other = (BLURFILTER)obj;
        if (Double.doubleToLongBits(this.blurX) != Double.doubleToLongBits(other.blurX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.blurY) != Double.doubleToLongBits(other.blurY)) {
            return false;
        }
        if (this.passes != other.passes) {
            return false;
        }
        return this.reserved == other.reserved;
    }
}

