/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class COLORMATRIXFILTER
extends FILTER {
    @SWFType(value=BasicType.FLOAT)
    @SWFArray(count=20)
    public float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    public COLORMATRIXFILTER() {
        super(6);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        float[][] matrix2 = new float[4][5];
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                matrix2[y][x] = this.matrix[y * 5 + x];
            }
        }
        return Filtering.colorMatrix(src, matrix2);
    }

    @Override
    public double getDeltaX() {
        return 0.0;
    }

    @Override
    public double getDeltaY() {
        return 0.0;
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        Element element = document.createElement("feColorMatrix");
        element.setAttribute("type", "matrix");
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < this.matrix.length; ++i) {
            if (i % 5 == 4) {
                parts.add("" + this.matrix[i] / 255.0f);
                continue;
            }
            parts.add("" + this.matrix[i]);
        }
        element.setAttribute("values", String.join((CharSequence)" ", parts));
        element.setAttribute("in", in);
        String result = exporter.getUniqueId("filterResult");
        element.setAttribute("result", result);
        filtersElement.appendChild(element);
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Arrays.hashCode(this.matrix);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        COLORMATRIXFILTER other = (COLORMATRIXFILTER)obj;
        return Arrays.equals(this.matrix, other.matrix);
    }
}

