/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CONVOLUTIONFILTER
extends FILTER {
    @SWFType(value=BasicType.UI8)
    public int matrixX = 3;
    @SWFType(value=BasicType.UI8)
    public int matrixY = 3;
    @SWFType(value=BasicType.FLOAT)
    public float divisor = 1.0f;
    @SWFType(value=BasicType.FLOAT)
    public float bias = 0.0f;
    @SWFType(value=BasicType.FLOAT, countField="matrixX * matrixY", canAdd=false)
    public float[] matrix = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public RGBA defaultColor = new RGBA(0, 0, 0, 0);
    @Reserved
    @SWFType(value=BasicType.UB, count=6)
    public int reserved;
    public boolean clamp = true;
    public boolean preserveAlpha = false;

    public CONVOLUTIONFILTER() {
        super(5);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        return Filtering.convolution(src, this.matrix, this.matrixX, this.matrixY, this.divisor, this.bias, this.defaultColor.toColor(), this.clamp, this.preserveAlpha, srcX, srcY, srcW, srcH);
    }

    @Override
    public double getDeltaX() {
        return 0.0;
    }

    @Override
    public double getDeltaY() {
        return 0.0;
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        Element element = document.createElement("feConvolveMatrix");
        element.setAttribute("order", "" + this.matrixX + " " + this.matrixY);
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < this.matrix.length; ++i) {
            parts.add("" + this.matrix[i]);
        }
        element.setAttribute("kernelMatrix", String.join((CharSequence)" ", parts));
        if (this.clamp) {
            element.setAttribute("edgeMode", "duplicate");
        } else {
            element.setAttribute("edgeMode", "none");
        }
        element.setAttribute("preserveAlpha", this.preserveAlpha ? "true" : "false");
        element.setAttribute("divisor", "" + this.divisor);
        element.setAttribute("bias", "" + this.bias);
        element.setAttribute("in", in);
        String result = exporter.getUniqueId("filterResult");
        element.setAttribute("result", result);
        filtersElement.appendChild(element);
        return result;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.matrixX;
        hash = 53 * hash + this.matrixY;
        hash = 53 * hash + Float.floatToIntBits(this.divisor);
        hash = 53 * hash + Float.floatToIntBits(this.bias);
        hash = 53 * hash + Arrays.hashCode(this.matrix);
        hash = 53 * hash + Objects.hashCode(this.defaultColor);
        hash = 53 * hash + this.reserved;
        hash = 53 * hash + (this.clamp ? 1 : 0);
        hash = 53 * hash + (this.preserveAlpha ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CONVOLUTIONFILTER other = (CONVOLUTIONFILTER)obj;
        if (this.matrixX != other.matrixX) {
            return false;
        }
        if (this.matrixY != other.matrixY) {
            return false;
        }
        if (Float.floatToIntBits(this.divisor) != Float.floatToIntBits(other.divisor)) {
            return false;
        }
        if (Float.floatToIntBits(this.bias) != Float.floatToIntBits(other.bias)) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        if (this.clamp != other.clamp) {
            return false;
        }
        if (this.preserveAlpha != other.preserveAlpha) {
            return false;
        }
        if (!Arrays.equals(this.matrix, other.matrix)) {
            return false;
        }
        return Objects.equals(this.defaultColor, other.defaultColor);
    }
}

