/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.helpers.ConcreteClasses;
import com.jpexs.helpers.SerializableImage;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ConcreteClasses(value={BLURFILTER.class, GRADIENTBEVELFILTER.class, GLOWFILTER.class, GRADIENTGLOWFILTER.class, COLORMATRIXFILTER.class, CONVOLUTIONFILTER.class, BEVELFILTER.class, DROPSHADOWFILTER.class})
public abstract class FILTER
implements Serializable {
    @SWFType(value=BasicType.UI8)
    public int id;
    @Internal
    public boolean enabled = true;

    public FILTER(int id) {
        this.id = id;
    }

    public abstract SerializableImage apply(SerializableImage var1, double var2, int var4, int var5, int var6, int var7);

    public abstract double getDeltaX();

    public abstract double getDeltaY();

    public abstract String toSvg(Document var1, Element var2, SVGExporter var3, String var4);

    protected String dropShadowSvg(double distance, double angle, RGBA dropShadowColor, boolean innerShadow, boolean knockout, boolean compositeSource, double blurX, double blurY, double strength, int iterations, Document document, Element filtersElement, SVGExporter exporter, String in) {
        double dx = distance * Math.cos(angle);
        double dy = distance * Math.sin(angle);
        if (innerShadow) {
            Element feFlood = document.createElement("feFlood");
            feFlood.setAttribute("flood-color", dropShadowColor.toHexRGB());
            feFlood.setAttribute("flood-opacity", "" + dropShadowColor.getAlphaFloat());
            filtersElement.appendChild(feFlood);
            String feFloodResult = exporter.getUniqueId("filterResult");
            feFlood.setAttribute("result", feFloodResult);
            Element feOffset = document.createElement("feOffset");
            feOffset.setAttribute("dx", "" + dx);
            feOffset.setAttribute("dy", "" + dy);
            feOffset.setAttribute("in", in);
            String feOffsetResult = exporter.getUniqueId("filterResult");
            feOffset.setAttribute("result", feOffsetResult);
            filtersElement.appendChild(feOffset);
            Element feComposite1 = document.createElement("feComposite");
            feComposite1.setAttribute("in", feFloodResult);
            feComposite1.setAttribute("in2", feOffsetResult);
            feComposite1.setAttribute("operator", "out");
            String feComposite1Result = exporter.getUniqueId("filterResult");
            feComposite1.setAttribute("result", feComposite1Result);
            filtersElement.appendChild(feComposite1);
            String blurResult = this.blurSvg(blurX, blurY, iterations, document, filtersElement, exporter, feComposite1Result);
            Element feComposite2 = document.createElement("feComposite");
            feComposite2.setAttribute("in", blurResult);
            feComposite2.setAttribute("in2", in);
            feComposite2.setAttribute("operator", "in");
            String result = exporter.getUniqueId("filterResult");
            feComposite2.setAttribute("result", result);
            filtersElement.appendChild(feComposite2);
            if (Double.compare(strength, 1.0) != 0) {
                Element feColorMatrix2 = document.createElement("feColorMatrix");
                feColorMatrix2.setAttribute("type", "matrix");
                feColorMatrix2.setAttribute("in", result);
                feColorMatrix2.setAttribute("values", "1 0 0 0 0,0 1 0 0 0,0 0 1 0 0,0 0 0 " + strength + " 0");
                result = exporter.getUniqueId("filterResult");
                feColorMatrix2.setAttribute("result", result);
                filtersElement.appendChild(feColorMatrix2);
            }
            if (knockout || !compositeSource) {
                return result;
            }
            Element feComposite3 = document.createElement("feComposite");
            feComposite3.setAttribute("in", result);
            feComposite3.setAttribute("in2", in);
            feComposite3.setAttribute("operator", "over");
            result = exporter.getUniqueId("filterResult");
            feComposite3.setAttribute("result", result);
            filtersElement.appendChild(feComposite3);
            return result;
        }
        Element feOffset = document.createElement("feOffset");
        feOffset.setAttribute("dx", "" + dx);
        feOffset.setAttribute("dy", "" + dy);
        feOffset.setAttribute("in", in);
        String feOffsetResult = exporter.getUniqueId("filterResult");
        feOffset.setAttribute("result", feOffsetResult);
        filtersElement.appendChild(feOffset);
        Element feColorMatrix = document.createElement("feColorMatrix");
        feColorMatrix.setAttribute("type", "matrix");
        feColorMatrix.setAttribute("in", feOffsetResult);
        feColorMatrix.setAttribute("values", "0 0 0 0 " + (float)dropShadowColor.red / 255.0f + ",0 0 0 0 " + (float)dropShadowColor.green / 255.0f + ",0 0 0 0 " + (float)dropShadowColor.blue / 255.0f + ",0 0 0 1 0");
        String feColorMatrixResult = exporter.getUniqueId("filterResult");
        feColorMatrix.setAttribute("result", feColorMatrixResult);
        filtersElement.appendChild(feColorMatrix);
        String result = this.blurSvg(blurX, blurY, iterations, document, filtersElement, exporter, feColorMatrixResult);
        if (Double.compare(strength, 1.0) != 0) {
            Element feColorMatrix2 = document.createElement("feColorMatrix");
            feColorMatrix2.setAttribute("type", "matrix");
            feColorMatrix2.setAttribute("in", result);
            feColorMatrix2.setAttribute("values", "1 0 0 0 0,0 1 0 0 0,0 0 1 0 0,0 0 0 " + strength + " 0");
            result = exporter.getUniqueId("filterResult");
            feColorMatrix2.setAttribute("result", result);
            filtersElement.appendChild(feColorMatrix2);
        }
        if (!knockout && !compositeSource) {
            return result;
        }
        Element feComposite = document.createElement("feComposite");
        if (knockout) {
            feComposite.setAttribute("in", result);
            feComposite.setAttribute("in2", in);
            feComposite.setAttribute("operator", "out");
        } else {
            feComposite.setAttribute("in", in);
            feComposite.setAttribute("in2", result);
            feComposite.setAttribute("operator", "over");
        }
        result = exporter.getUniqueId("filterResult");
        feComposite.setAttribute("result", result);
        filtersElement.appendChild(feComposite);
        return result;
    }

    protected String blurSvg(double blurX, double blurY, int iterations, Document document, Element filtersElement, SVGExporter exporter, String in) {
        double divisor;
        int orderX;
        if (iterations == 0) {
            return in;
        }
        if (Double.compare(blurX, 0.0) == 0 && Double.compare(blurY, 0.0) == 0) {
            return in;
        }
        Element element = document.createElement("feConvolveMatrix");
        ArrayList<String> parts = new ArrayList<String>();
        if (Double.compare(blurX, 0.0) == 0) {
            orderX = (int)Math.ceil(blurX);
            divisor = orderX;
            element.setAttribute("order", "" + orderX + " 1");
        } else if (Double.compare(blurY, 0.0) == 0) {
            int orderY = (int)Math.ceil(blurY);
            divisor = orderY;
            element.setAttribute("order", "1 " + orderY);
        } else {
            orderX = (int)Math.ceil(blurX);
            int orderY = (int)Math.ceil(blurY);
            divisor = orderX * orderY;
            element.setAttribute("order", "" + orderX + " " + orderY);
        }
        int i = 0;
        while ((double)i < divisor) {
            parts.add("1");
            ++i;
        }
        element.setAttribute("divisor", "" + divisor);
        element.setAttribute("kernelMatrix", String.join((CharSequence)" ", parts));
        element.setAttribute("in", in);
        String result = exporter.getUniqueId("filterResult");
        element.setAttribute("result", result);
        filtersElement.appendChild(element);
        return this.blurSvg(blurX, blurY, iterations - 1, document, filtersElement, exporter, result);
    }

    public static float[] convertRatiosToJavaGradient(int[] input) {
        int i;
        int n = input.length;
        float[] output = new float[n];
        float max = 1.0f;
        float epsilon = 1.0E-6f;
        for (i = 0; i < n; ++i) {
            output[i] = (float)input[i] / 255.0f;
        }
        for (i = 1; i < n; ++i) {
            if (!(output[i] <= output[i - 1])) continue;
            float proposed = output[i - 1] + 1.0E-6f;
            if (proposed > 1.0f) {
                int k;
                int j;
                for (j = i - 1; j >= 0 && output[j] >= 1.0f - (float)(i - j) * 1.0E-6f; --j) {
                }
                if (j < 0) {
                    for (k = i - i; k <= i; ++k) {
                        output[k] = 1.0f - (float)(i - k) * 1.0E-6f;
                    }
                    continue;
                }
                for (k = j + 1; k <= i; ++k) {
                    output[k] = output[k - 1] + 1.0E-6f;
                }
                continue;
            }
            output[i] = proposed;
        }
        return output;
    }
}

