/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.ConvolveOp;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;

public class Filtering {
    public static final int INNER = 1;
    public static final int OUTER = 2;
    public static final int FULL = 3;
    private static final Color ALPHA = new Color(0, 0, 0, 0);
    private static final Point POINT_0_0 = new Point(0, 0);
    private static final Point POINT_255_0 = new Point(255, 0);
    private static final Point POINT_511_0 = new Point(511, 0);
    private static final Rectangle RECTANGLE_256_1 = new Rectangle(256, 1);
    private static final Rectangle RECTANGLE_512_1 = new Rectangle(512, 1);

    private static void boxBlurSingleIteration(int[] pixels, int[] newColors, int w, int h, int radiusX, int radiusY) {
        Filtering.boxBlurSingleIterationTwoPass(pixels, newColors, w, h, radiusX, radiusY);
    }

    private static void boxBlurSingleIterationTwoPass(int[] pixels, int[] newColors, int w, int h, int radiusX, int radiusY) {
        long limit;
        if (radiusX == 0) {
            radiusX = 1;
        }
        if (radiusY == 0) {
            radiusY = 1;
        }
        if ((long)w * (long)h > (limit = (long)Configuration.boxBlurPixelsLimit.get().intValue() * 100000L)) {
            return;
        }
        while ((long)radiusY * (long)radiusX * (long)w * (long)h > limit) {
            if (radiusY > 1) {
                --radiusY;
            }
            if (radiusX <= 1) continue;
            --radiusX;
        }
        int[] secondPass = new int[w * h];
        Filtering.boxBlurHorizontal(pixels, secondPass, w, h, radiusX);
        Filtering.boxBlurVertical(secondPass, newColors, w, h, radiusY);
        System.arraycopy(newColors, 0, pixels, 0, newColors.length);
    }

    private static void boxBlurHorizontal(int[] pixels, int[] result, int w, int h, int radius) {
        if (radius == 0) {
            radius = 1;
        }
        int radiusHalf = radius / 2;
        double divisor = radius;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int da;
                double sumR = 0.0;
                double sumG = 0.0;
                double sumB = 0.0;
                double sumA = 0.0;
                double cnt = 0.0;
                for (int j = x - radiusHalf; j < x - radiusHalf + radius; ++j) {
                    int index2 = y * w + j;
                    if (j < 0 || j >= w) continue;
                    int v = pixels[index2];
                    cnt += 1.0;
                    double a = v >> 24 & 0xFF;
                    double r = v >> 16 & 0xFF;
                    double g = v >> 8 & 0xFF;
                    double b = v & 0xFF;
                    r = r * a / 255.0;
                    g = g * a / 255.0;
                    b = b * a / 255.0;
                    sumA += a;
                    sumR += r;
                    sumG += g;
                    sumB += b;
                }
                if (cnt == 0.0) {
                    cnt = 1.0;
                }
                int da_mod = (da = (int)Math.floor(sumA / cnt)) == 0 ? 255 : da;
                int dr = (int)Math.floor(sumR / cnt * 255.0 / (double)da_mod);
                int dg = (int)Math.floor(sumG / cnt * 255.0 / (double)da_mod);
                int db = (int)Math.floor(sumB / cnt * 255.0 / (double)da_mod);
                if (dr > 255) {
                    dr = 255;
                }
                if (dg > 255) {
                    dg = 255;
                }
                if (db > 255) {
                    db = 255;
                }
                int index = y * w + x;
                result[index] = RGBA.toInt(dr, dg, db, da);
            }
        }
    }

    private static void boxBlurVertical(int[] pixels, int[] result, int w, int h, int radius) {
        if (radius == 0) {
            radius = 1;
        }
        int radiusHalf = radius / 2;
        double divisor = radius;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int da;
                double sumR = 0.0;
                double sumG = 0.0;
                double sumB = 0.0;
                double sumA = 0.0;
                double cnt = 0.0;
                for (int j = y - radiusHalf; j < y - radiusHalf + radius; ++j) {
                    int index2 = j * w + x;
                    if (j < 0 || j >= h) continue;
                    int v = pixels[index2];
                    cnt += 1.0;
                    double a = v >> 24 & 0xFF;
                    double r = v >> 16 & 0xFF;
                    double g = v >> 8 & 0xFF;
                    double b = v & 0xFF;
                    r = r * a / 255.0;
                    g = g * a / 255.0;
                    b = b * a / 255.0;
                    sumA += a;
                    sumR += r;
                    sumG += g;
                    sumB += b;
                }
                if (cnt == 0.0) {
                    cnt = 1.0;
                }
                int da_mod = (da = (int)Math.floor(sumA / cnt)) == 0 ? 255 : da;
                int dr = (int)Math.floor(sumR / cnt * 255.0 / (double)da_mod);
                int dg = (int)Math.floor(sumG / cnt * 255.0 / (double)da_mod);
                int db = (int)Math.floor(sumB / cnt * 255.0 / (double)da_mod);
                if (dr > 255) {
                    dr = 255;
                }
                if (dg > 255) {
                    dg = 255;
                }
                if (db > 255) {
                    db = 255;
                }
                int index = y * w + x;
                result[index] = RGBA.toInt(dr, dg, db, da);
            }
        }
    }

    private static void premultiply(int[] p) {
        int length = p.length;
        int offset = 0;
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            float f = (float)a * 0.003921569f;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private static void unpremultiply(int[] p) {
        int length = p.length;
        int offset = 0;
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (a == 0 || a == 255) continue;
            float f = 255.0f / (float)a;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    public static SerializableImage blur(SerializableImage src, int hRadius, int vRadius, int iterations) {
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        int width = src.getWidth();
        int height = src.getHeight();
        Filtering.blur(pixels, width, height, hRadius, vRadius, iterations);
        BufferedImage ret = new BufferedImage(width, height, src.getType());
        Filtering.setRGB(ret, width, height, pixels);
        return new SerializableImage(ret);
    }

    private static void blur(int[] src, int width, int height, int hRadius, int vRadius, int iterations) {
        int[] inPixels = src;
        int[] temp = new int[width * height];
        for (int i = 0; i < iterations; ++i) {
            Filtering.boxBlurSingleIteration(inPixels, temp, width, height, hRadius, vRadius);
        }
    }

    public static SerializableImage bevel(SerializableImage src, int blurX, int blurY, float strength, int type, int highlightColor, int shadowColor, float angle, float distance, boolean knockout, boolean compositeSource, int iterations) {
        return new SerializableImage(Filtering.gradientBevel(src.getBufferedImage(), new Color[]{new Color(shadowColor, true), new Color(shadowColor & 0xFFFFFF, true), new Color(highlightColor & 0xFFFFFF, true), new Color(highlightColor, true)}, new float[]{0.0f, 0.49803922f, 0.5019608f, 1.0f}, blurX, blurY, strength, type, angle, distance, knockout, compositeSource, iterations));
    }

    public static SerializableImage gradientBevel(SerializableImage src, Color[] colors, float[] ratios, int blurX, int blurY, float strength, int type, float angle, float distance, boolean knockout, boolean compositeSource, int iterations) {
        return new SerializableImage(Filtering.gradientBevel(src.getBufferedImage(), colors, ratios, blurX, blurY, strength, type, angle, distance, knockout, compositeSource, iterations));
    }

    private static BufferedImage gradientBevel(BufferedImage src, Color[] colors, float[] ratios, int blurX, int blurY, float strength, int type, float angle, float distance, boolean knockout, boolean compositeSource, int iterations) {
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImage retImg = new BufferedImage(width, height, src.getType());
        int[] srcPixels = Filtering.getRGB(src);
        BufferedImage gradient = new BufferedImage(512, 1, src.getType());
        Graphics2D gg = gradient.createGraphics();
        Point p1 = POINT_0_0;
        Point p2 = POINT_511_0;
        gg.setPaint(new LinearGradientPaint(p1, p2, ratios, colors));
        gg.fill(RECTANGLE_512_1);
        int[] gradientPixels = Filtering.getRGB(gradient);
        BufferedImage hilightImInner = Filtering.dropShadow(src, 0, 0, angle, (double)distance, Color.red, true, iterations, strength, true, true);
        BufferedImage shadowImInner = Filtering.dropShadow(src, 0, 0, angle + 180.0f, (double)distance, Color.blue, true, iterations, strength, true, true);
        BufferedImage h2Inner = new BufferedImage(width, height, src.getType());
        BufferedImage s2Inner = new BufferedImage(width, height, src.getType());
        Graphics2D hcInner = h2Inner.createGraphics();
        Graphics2D scInner = s2Inner.createGraphics();
        hcInner.drawImage((Image)hilightImInner, 0, 0, null);
        hcInner.setComposite(AlphaComposite.DstOut);
        hcInner.drawImage((Image)shadowImInner, 0, 0, null);
        scInner.drawImage((Image)shadowImInner, 0, 0, null);
        scInner.setComposite(AlphaComposite.DstOut);
        scInner.drawImage((Image)hilightImInner, 0, 0, null);
        BufferedImage shadowInner = s2Inner;
        BufferedImage hilightInner = h2Inner;
        BufferedImage hilightImOuter = Filtering.dropShadow(src, 0, 0, angle + 180.0f, (double)distance, Color.red, false, iterations, strength, true, true);
        BufferedImage shadowImOuter = Filtering.dropShadow(src, 0, 0, angle, (double)distance, Color.blue, false, iterations, strength, true, true);
        BufferedImage h2Outer = new BufferedImage(width, height, src.getType());
        BufferedImage s2Outer = new BufferedImage(width, height, src.getType());
        Graphics2D hcOuter = h2Outer.createGraphics();
        Graphics2D scOuter = s2Outer.createGraphics();
        hcOuter.drawImage((Image)hilightImOuter, 0, 0, null);
        hcOuter.setComposite(AlphaComposite.DstOut);
        hcOuter.drawImage((Image)shadowImOuter, 0, 0, null);
        scOuter.drawImage((Image)shadowImOuter, 0, 0, null);
        scOuter.setComposite(AlphaComposite.DstOut);
        scOuter.drawImage((Image)hilightImOuter, 0, 0, null);
        BufferedImage shadowOuter = s2Outer;
        BufferedImage hilightOuter = h2Outer;
        BufferedImage hilightIm = hilightInner;
        BufferedImage shadowIm = shadowInner;
        Graphics2D hc = hilightIm.createGraphics();
        hc.setComposite(AlphaComposite.SrcOver);
        hc.drawImage((Image)hilightOuter, 0, 0, null);
        Graphics2D sc = shadowIm.createGraphics();
        sc.setComposite(AlphaComposite.SrcOver);
        sc.drawImage((Image)shadowOuter, 0, 0, null);
        Graphics2D retc = retImg.createGraphics();
        retc.setColor(Color.black);
        retc.fillRect(0, 0, width, height);
        retc.setComposite(AlphaComposite.SrcOver);
        retc.drawImage((Image)shadowIm, 0, 0, null);
        retc.drawImage((Image)hilightIm, 0, 0, null);
        int[] bevel = Filtering.getRGB(retImg);
        Filtering.blur(bevel, width, height, blurX, blurY, iterations);
        for (int i = 0; i < srcPixels.length; ++i) {
            int ah = (int)((float)(bevel[i] >> 16 & 0xFF) * strength);
            int as = (int)((float)(bevel[i] & 0xFF) * strength);
            int ra = Filtering.cut(ah - as, -255, 255);
            bevel[i] = gradientPixels[255 + ra];
        }
        return Filtering.compose(width, height, src, bevel, type, knockout, compositeSource);
    }

    public static SerializableImage glow(SerializableImage src, int blurX, int blurY, float strength, Color color, boolean inner, boolean knockout, int iterations) {
        return new SerializableImage(Filtering.dropShadow(src.getBufferedImage(), blurX, blurY, 45.0f, 0.0, color, inner, iterations, strength, knockout, true));
    }

    private static Color over(Color a, Color b) {
        int resultA = a.getAlpha() + b.getAlpha() * (255 - a.getAlpha()) / 255;
        int resultR = Filtering.cut(((double)a.getRed() * ((double)a.getAlpha() / 255.0) + (double)b.getRed() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        int resultG = Filtering.cut(((double)a.getGreen() * ((double)a.getAlpha() / 255.0) + (double)b.getGreen() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        int resultB = Filtering.cut(((double)a.getBlue() * ((double)a.getAlpha() / 255.0) + (double)b.getBlue() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        return new Color(resultR, resultG, resultB, resultA);
    }

    public static SerializableImage dropShadow(SerializableImage src, int blurX, int blurY, float angle, double distance, Color color, boolean inner, int iterations, float strength, boolean knockout, boolean compositeSource) {
        return new SerializableImage(Filtering.dropShadow(src.getBufferedImage(), blurX, blurY, angle, distance, color, inner, iterations, strength, knockout, compositeSource));
    }

    private static BufferedImage dropShadow(BufferedImage src, int blurX, int blurY, float angle, double distance, Color color, boolean inner, int iterations, float strength, boolean knockout, boolean compositeSource) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] srcPixels = Filtering.getRGB(src);
        int[] shadow = new int[srcPixels.length];
        for (int i = 0; i < srcPixels.length; ++i) {
            int alpha = srcPixels[i] >> 24 & 0xFF;
            if (inner) {
                alpha = 255 - alpha;
            }
            Color shadowColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), Filtering.cut((float)(color.getAlpha() * alpha) / 255.0f));
            shadow[i] = shadowColor.getRGB();
        }
        Color colorAlpha = ALPHA;
        double angleRad = (double)(angle / 180.0f) * Math.PI;
        double moveX = distance * Math.cos(angleRad);
        double moveY = distance * Math.sin(angleRad);
        shadow = Filtering.moveRGB(width, height, shadow, moveX, moveY, inner ? color : colorAlpha);
        if (blurX > 0 || blurY > 0) {
            Filtering.blur(shadow, width, height, blurX, blurY, iterations);
        }
        if (strength != 1.0f) {
            for (int i = 0; i < shadow.length; ++i) {
                int alpha = shadow[i] >> 24 & 0xFF;
                alpha = Filtering.cut((float)alpha * strength);
                shadow[i] = shadow[i] & 0xFFFFFF | alpha << 24;
            }
        }
        return Filtering.compose(width, height, src, shadow, inner ? 1 : 2, knockout, compositeSource);
    }

    private static BufferedImage compose(int width, int height, BufferedImage srcImage, int[] pixels, int type, boolean knockout, boolean compositeSource) {
        BufferedImage resultImage = new BufferedImage(width, height, srcImage.getType());
        Filtering.setRGB(resultImage, width, height, pixels);
        Graphics2D g = resultImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (type == 3 && !knockout && compositeSource) {
            g.setComposite(AlphaComposite.DstOver);
            g.drawImage((Image)srcImage, 0, 0, null);
        } else if (type == 1) {
            if (knockout || !compositeSource) {
                g.setComposite(AlphaComposite.DstIn);
            } else {
                g.setComposite(AlphaComposite.DstAtop);
            }
            g.drawImage((Image)srcImage, 0, 0, null);
        } else if (type == 2) {
            if (knockout) {
                g.setComposite(AlphaComposite.DstOut);
                g.drawImage((Image)srcImage, 0, 0, null);
            } else if (compositeSource) {
                g.setComposite(AlphaComposite.SrcOver);
                g.drawImage((Image)srcImage, 0, 0, null);
            }
        }
        return resultImage;
    }

    public static SerializableImage gradientGlow(SerializableImage src, int blurX, int blurY, float angle, double distance, Color[] colors, float[] ratios, int type, int iterations, float strength, boolean knockout, boolean compositeSource) {
        return new SerializableImage(Filtering.gradientGlow(src.getBufferedImage(), blurX, blurY, angle, distance, colors, ratios, type, iterations, strength, knockout, compositeSource));
    }

    private static BufferedImage gradientGlow(BufferedImage src, int blurX, int blurY, float angle, double distance, Color[] colors, float[] ratios, int type, int iterations, float strength, boolean knockout, boolean compositeSource) {
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImage gradCanvas = new BufferedImage(256, 1, src.getType());
        Graphics2D gg = gradCanvas.createGraphics();
        Point p1 = POINT_0_0;
        Point p2 = POINT_255_0;
        gg.setPaint(new LinearGradientPaint(p1, p2, ratios, colors));
        gg.fill(RECTANGLE_256_1);
        int[] gradientPixels = Filtering.getRGB(gradCanvas);
        double angleRad = (double)(angle / 180.0f) * Math.PI;
        double moveX = distance * Math.cos(angleRad);
        double moveY = distance * Math.sin(angleRad);
        int[] srcPixels = Filtering.getRGB(src);
        int[] shadow = new int[srcPixels.length];
        for (int i = 0; i < srcPixels.length; ++i) {
            shadow[i] = 0 + (Filtering.cut(strength * (float)(srcPixels[i] >> 24 & 0xFF)) << 24);
        }
        Color colorAlpha = ALPHA;
        shadow = Filtering.moveRGB(width, height, shadow, moveX, moveY, colorAlpha);
        Filtering.blur(shadow, width, height, blurX, blurY, iterations);
        for (int i = 0; i < shadow.length; ++i) {
            int gp;
            int a = shadow[i] >> 24 & 0xFF;
            shadow[i] = gp = gradientPixels[a];
        }
        return Filtering.compose(width, height, src, shadow, type, knockout, compositeSource);
    }

    private static int[] getRGB(BufferedImage image) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        }
        int width = image.getWidth();
        return image.getRGB(0, 0, width, image.getHeight(), null, 0, width);
    }

    public static void setRGB(BufferedImage image, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            image.getRaster().setDataElements(0, 0, width, height, pixels);
        } else {
            image.setRGB(0, 0, width, height, pixels, 0, width);
        }
    }

    private static int[] moveRGB(int width, int height, int[] rgb, double deltaX, double deltaY, Color fill) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Filtering.setRGB(img, width, height, rgb);
        BufferedImage retImg = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)retImg.getGraphics();
        g.setPaint(fill);
        g.fillRect(0, 0, width, height);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(AffineTransform.getTranslateInstance(deltaX, deltaY));
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)img, 0, 0, null);
        return Filtering.getRGB(retImg);
    }

    public static SerializableImage convolution(SerializableImage src, float[] matrix, int w, int h, float divisor, float bias, Color defaultColor, boolean clamp, boolean preserveAlpha, int srcX, int srcY, int srcWidth, int srcHeight) {
        Kernel kernel = new Kernel(w, h, matrix);
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        ConvolveOp op = new ConvolveOp(kernel, new RenderingHints(null), divisor, bias, defaultColor, clamp, preserveAlpha, srcX, srcY, srcWidth, srcHeight);
        op.filter(src.getBufferedImage(), dst);
        return new SerializableImage(dst);
    }

    public static SerializableImage colorMatrix(SerializableImage src, float[][] matrix) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        for (int i = 0; i < pixels.length; ++i) {
            int rgb = pixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            float[] mr = matrix[0];
            int r2 = Filtering.cut(mr[0] * (float)r + mr[1] * (float)g + mr[2] * (float)b + mr[3] * (float)a + mr[4]);
            float[] mg = matrix[1];
            int g2 = Filtering.cut(mg[0] * (float)r + mg[1] * (float)g + mg[2] * (float)b + mg[3] * (float)a + mg[4]);
            float[] mb = matrix[2];
            int b2 = Filtering.cut(mb[0] * (float)r + mb[1] * (float)g + mb[2] * (float)b + mb[3] * (float)a + mb[4]);
            float[] ma = matrix[3];
            int a2 = Filtering.cut(ma[0] * (float)r + ma[1] * (float)g + ma[2] * (float)b + ma[3] * (float)a + ma[4]);
            pixels[i] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
        }
        Filtering.setRGB(dst, src.getWidth(), src.getHeight(), pixels);
        return new SerializableImage(dst);
    }

    private static int cut(int val, int min, int max) {
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    private static int cut(double val) {
        int i = (int)Math.round(val);
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        return i;
    }

    public static int colorEffect(int rgb, int redAddTerm, int greenAddTerm, int blueAddTerm, int alphaAddTerm, int redMultTerm, int greenMultTerm, int blueMultTerm, int alphaMultTerm) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = Filtering.cut(r * redMultTerm / 256 + redAddTerm);
        g = Filtering.cut(g * greenMultTerm / 256 + greenAddTerm);
        b = Filtering.cut(b * blueMultTerm / 256 + blueAddTerm);
        a = Filtering.cut(a * alphaMultTerm / 256 + alphaAddTerm);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static SerializableImage colorEffect(SerializableImage src, int redAddTerm, int greenAddTerm, int blueAddTerm, int alphaAddTerm, int redMultTerm, int greenMultTerm, int blueMultTerm, int alphaMultTerm) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        for (int i = 0; i < pixels.length; ++i) {
            int rgb = pixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = Filtering.cut(r * redMultTerm / 256 + redAddTerm);
            g = Filtering.cut(g * greenMultTerm / 256 + greenAddTerm);
            b = Filtering.cut(b * blueMultTerm / 256 + blueAddTerm);
            a = Filtering.cut(a * alphaMultTerm / 256 + alphaAddTerm);
            pixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
        Filtering.setRGB(dst, src.getWidth(), src.getHeight(), pixels);
        return new SerializableImage(dst);
    }
}

