/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GRADIENTGLOWFILTER
extends FILTER {
    @SWFArray(value="color", countField="numColors")
    public RGBA[] gradientColors = new RGBA[]{new RGBA(255, 255, 255, 0), new RGBA(Color.BLACK)};
    @SWFType(value=BasicType.UI8)
    @SWFArray(value="ratio", countField="numColors")
    public int[] gradientRatio = new int[]{0, 255};
    @SWFType(value=BasicType.FIXED)
    public double blurX = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double blurY = 5.0;
    @SWFType(value=BasicType.FIXED)
    public double angle = 0.7853981633974483;
    @SWFType(value=BasicType.FIXED)
    public double distance = 5.0;
    @SWFType(value=BasicType.UFIXED8)
    public float strength = 1.0f;
    public boolean innerShadow = false;
    public boolean knockout = false;
    public boolean compositeSource = true;
    public boolean onTop = false;
    @SWFType(value=BasicType.UB, count=4)
    public int passes = 1;

    public GRADIENTGLOWFILTER() {
        super(4);
    }

    @Override
    public SerializableImage apply(SerializableImage src, double zoom, int srcX, int srcY, int srcW, int srcH) {
        Color[] colorsArr = new Color[this.gradientColors.length];
        for (int i = 0; i < this.gradientColors.length; ++i) {
            colorsArr[i] = this.gradientColors[i].toColor();
        }
        float[] ratiosArr = GRADIENTGLOWFILTER.convertRatiosToJavaGradient(this.gradientRatio);
        int type = 1;
        if (this.onTop && !this.innerShadow) {
            type = 3;
        } else if (!this.innerShadow) {
            type = 2;
        }
        return Filtering.gradientGlow(src, (int)Math.round(this.blurX * zoom), (int)Math.round(this.blurY * zoom), (float)((int)(this.angle * 180.0 / Math.PI)), this.distance * zoom, colorsArr, ratiosArr, type, this.passes, this.strength, this.knockout, this.compositeSource);
    }

    @Override
    public double getDeltaX() {
        return this.blurX + Math.abs(this.distance * Math.cos(this.angle));
    }

    @Override
    public double getDeltaY() {
        return this.blurY + Math.abs(this.distance * Math.sin(this.angle));
    }

    @Override
    public String toSvg(Document document, Element filtersElement, SVGExporter exporter, String in) {
        return null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Arrays.deepHashCode(this.gradientColors);
        hash = 67 * hash + Arrays.hashCode(this.gradientRatio);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.blurX) ^ Double.doubleToLongBits(this.blurX) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.blurY) ^ Double.doubleToLongBits(this.blurY) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.angle) ^ Double.doubleToLongBits(this.angle) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        hash = 67 * hash + Float.floatToIntBits(this.strength);
        hash = 67 * hash + (this.innerShadow ? 1 : 0);
        hash = 67 * hash + (this.knockout ? 1 : 0);
        hash = 67 * hash + (this.compositeSource ? 1 : 0);
        hash = 67 * hash + (this.onTop ? 1 : 0);
        hash = 67 * hash + this.passes;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GRADIENTGLOWFILTER other = (GRADIENTGLOWFILTER)obj;
        if (Double.doubleToLongBits(this.blurX) != Double.doubleToLongBits(other.blurX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.blurY) != Double.doubleToLongBits(other.blurY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.angle) != Double.doubleToLongBits(other.angle)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        if (Float.floatToIntBits(this.strength) != Float.floatToIntBits(other.strength)) {
            return false;
        }
        if (this.innerShadow != other.innerShadow) {
            return false;
        }
        if (this.knockout != other.knockout) {
            return false;
        }
        if (this.compositeSource != other.compositeSource) {
            return false;
        }
        if (this.onTop != other.onTop) {
            return false;
        }
        if (this.passes != other.passes) {
            return false;
        }
        if (!Arrays.deepEquals(this.gradientColors, other.gradientColors)) {
            return false;
        }
        return Arrays.equals(this.gradientRatio, other.gradientRatio);
    }
}

