/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import com.jpexs.decompiler.flash.types.gfx.EdgeType;
import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ContourType
implements Serializable {
    public int moveToX;
    public int moveToY;
    public EdgeType[] edges;
    public boolean isReference;
    public long reference;

    public ContourType(List<SHAPERECORD> records) {
        int i;
        int divider = 1;
        for (i = 0; i < records.size(); ++i) {
            SHAPERECORD rec = records.get(i);
            if (!(rec instanceof StyleChangeRecord)) continue;
            StyleChangeRecord scr = (StyleChangeRecord)rec;
            if (!scr.stateMoveTo) continue;
            this.moveToX = scr.moveDeltaX / divider;
            this.moveToY = scr.moveDeltaY / divider;
            break;
        }
        ArrayList<EdgeType> edgesList = new ArrayList<EdgeType>();
        while (i < records.size()) {
            SHAPERECORD rec = records.get(i);
            if (rec instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                if (ser.generalLineFlag) {
                    edgesList.add(new EdgeType(ser.deltaX / divider, ser.deltaY / divider));
                } else if (ser.vertLineFlag) {
                    edgesList.add(new EdgeType(true, ser.deltaY / divider));
                } else {
                    edgesList.add(new EdgeType(false, ser.deltaX / divider));
                }
            } else if (rec instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                edgesList.add(new EdgeType(cer.controlDeltaX / divider, cer.controlDeltaY / divider, cer.anchorDeltaX / divider, cer.anchorDeltaY / divider));
            }
            ++i;
        }
        this.edges = edgesList.toArray(new EdgeType[edgesList.size()]);
    }

    public ContourType() {
        this.edges = new EdgeType[0];
    }

    public ContourType(GFxInputStream sis, long fontOffset) throws IOException {
        int numEdges;
        this.moveToX = sis.readSI15("moveToX");
        this.moveToY = sis.readSI15("moveToY");
        long numEdgesRef = sis.readUI30("numEdgesRef");
        this.isReference = (numEdgesRef & 1L) == 1L;
        numEdgesRef >>= 1;
        long oldPos = sis.getPos();
        if (this.isReference) {
            long referencePos = numEdgesRef;
            sis.setPos(fontOffset + referencePos);
            numEdges = (int)(sis.readUI30("numEdges") >> 1);
        } else {
            numEdges = (int)numEdgesRef;
        }
        this.edges = new EdgeType[numEdges];
        for (int i = 0; i < this.edges.length; ++i) {
            sis.newDumpLevel("edgeType", "EdgeType");
            this.edges[i] = new EdgeType(sis);
            sis.endDumpLevel();
        }
        if (this.isReference) {
            sis.setPos(oldPos);
        }
    }

    public List<SHAPERECORD> toSHAPERECORDS() {
        int multiplier = 1;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        StyleChangeRecord src = new StyleChangeRecord();
        src.stateMoveTo = true;
        src.moveDeltaX = this.moveToX * multiplier;
        src.moveDeltaY = this.moveToY * multiplier;
        src.calculateBits();
        recs.add(src);
        for (EdgeType e : this.edges) {
            recs.add(e.toSHAPERECORD());
        }
        int x = src.moveDeltaX;
        int y = src.moveDeltaY;
        for (SHAPERECORD rec : recs) {
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
        StraightEdgeRecord closeSer = new StraightEdgeRecord();
        closeSer.generalLineFlag = true;
        closeSer.deltaX = src.moveDeltaX - x;
        closeSer.deltaY = src.moveDeltaY - y;
        closeSer.simplify();
        closeSer.calculateBits();
        recs.add(closeSer);
        return recs;
    }

    public void write(GFxOutputStream sos) throws IOException {
        sos.writeSI15(this.moveToX);
        sos.writeSI15(this.moveToY);
        sos.writeUI30(this.edges.length << 1);
        for (int i = 0; i < this.edges.length; ++i) {
            this.edges[i].write(sos);
        }
    }
}

