/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.flash.fla.converter.FlaFormatVersion;

public enum FLAVersion {
    F5("F5", "Flash 5", FlaFormatVersion.F5, null, 5),
    MX("MX", "Flash MX", FlaFormatVersion.MX, null, 6),
    MX2004("MX2004", "Flash MX 2004", FlaFormatVersion.MX2004, null, 7),
    F8("F8", "Flash 8", FlaFormatVersion.F8, null, 8),
    CS3("CS3", "Flash CS 3", FlaFormatVersion.CS3, null, 9),
    CS4("CS4", "Flash CS 4", FlaFormatVersion.CS4, null, 10),
    CS5("CS5", "Flash CS 5", null, "2.0", 10),
    CS5_5("CS5.5", "Flash CS 5.5", null, "2.1", 11),
    CS6("CS6", "Flash CS 6", null, "2.2", 17),
    CC("CC", "Flash CC", null, "2.4", Integer.MAX_VALUE){

        @Override
        public int minASVersion() {
            return 3;
        }
    };

    private final FlaFormatVersion cfbFlaVersion;
    private final String xflVersion;
    private final String shortName;
    private final String applicationName;
    private final int maxSwfVersion;

    private FLAVersion(String shortName, String applicationName, FlaFormatVersion cfbFlaVersion, String xflVersion, int maxSwfVersion) {
        this.cfbFlaVersion = cfbFlaVersion;
        this.xflVersion = xflVersion;
        this.shortName = shortName;
        this.applicationName = applicationName;
        this.maxSwfVersion = maxSwfVersion;
    }

    public FlaFormatVersion getCfbFlaVersion() {
        return this.cfbFlaVersion;
    }

    public String xflVersion() {
        return this.xflVersion;
    }

    public int maxSwfVersion() {
        return this.maxSwfVersion;
    }

    public int minASVersion() {
        return 1;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String shortName() {
        return this.shortName;
    }

    public String toString() {
        return this.shortName;
    }

    public static FLAVersion fromString(String s) {
        if (s == null) {
            return null;
        }
        for (FLAVersion v : FLAVersion.values()) {
            if (v.shortName.toLowerCase().equals(s.toLowerCase())) {
                return v;
            }
            if (v.xflVersion == null || !v.xflVersion.equals(s)) continue;
            return v;
        }
        return null;
    }
}

