/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DottedChain
implements Serializable,
Comparable<DottedChain> {
    public static final DottedChain UNBOUNDED = new DottedChain(new String[]{"*"});
    public static final DottedChain TOPLEVEL;
    public static final DottedChain EMPTY;
    public static final DottedChain BOOLEAN;
    public static final DottedChain STRING;
    public static final DottedChain ARRAY;
    public static final DottedChain NUMBER;
    public static final DottedChain DECIMAL;
    public static final DottedChain OBJECT;
    public static final DottedChain INT;
    public static final DottedChain UINT;
    public static final DottedChain UNDEFINED;
    public static final DottedChain XML;
    public static final DottedChain NULL;
    public static final DottedChain FUNCTION;
    public static final DottedChain VOID;
    public static final DottedChain NAMESPACE;
    public static final DottedChain ALL;
    private List<PathPart> parts;

    public String getNamespaceSuffix(int index) {
        return this.parts.get((int)index).namespaceSuffix;
    }

    public String getLastNamespaceSuffix() {
        if (this.parts.isEmpty()) {
            return "";
        }
        return this.parts.get((int)(this.parts.size() - 1)).namespaceSuffix;
    }

    public static final DottedChain parseNoSuffix(String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String[] parts = name.split("\\.");
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (String part : parts) {
            newParts.add(new PathPart(part, false, ""));
        }
        DottedChain ret = new DottedChain();
        ret.parts = newParts;
        return ret;
    }

    public static final DottedChain parseWithSuffix(String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String[] parts = name.split("\\.");
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        String[] stringArray = parts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String part;
            String nameNoSuffix = part = stringArray[i];
            String namespaceSuffix = "";
            if (part.matches(".*#[0-9]+$")) {
                nameNoSuffix = part.substring(0, part.lastIndexOf("#"));
                namespaceSuffix = part.substring(part.lastIndexOf("#"));
            }
            newParts.add(new PathPart(nameNoSuffix, false, namespaceSuffix));
        }
        DottedChain ret = new DottedChain();
        ret.parts = newParts;
        return ret;
    }

    public static final DottedChain parsePrintable(SWF swf, String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String[] parts = name.split("\\.");
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (String part : parts) {
            newParts.add(new PathPart(IdentifiersDeobfuscation.unescapeOIdentifier(swf, part), false, ""));
        }
        DottedChain ret = new DottedChain();
        ret.parts = newParts;
        return ret;
    }

    private DottedChain() {
        this.parts = new ArrayList<PathPart>();
    }

    public DottedChain(DottedChain src) {
        this.parts = new ArrayList<PathPart>(src.parts);
    }

    public DottedChain(String[] parts) {
        this(Arrays.asList(parts));
    }

    public DottedChain(List<String> parts) {
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (String part : parts) {
            newParts.add(new PathPart(part, false, ""));
        }
        this.parts = newParts;
    }

    public DottedChain(String[] parts, String[] namespaceSuffixes) {
        this(new boolean[parts.length], parts, namespaceSuffixes);
    }

    public DottedChain(boolean[] attributes, String[] parts, String[] namespaceSuffixes) {
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (int i = 0; i < attributes.length; ++i) {
            newParts.add(new PathPart(parts[i], attributes[i], namespaceSuffixes[i]));
        }
        this.parts = newParts;
    }

    public boolean isTopLevel() {
        return this.parts.isEmpty();
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public int size() {
        return this.parts.size();
    }

    public String get(int index) {
        if (index >= this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.parts.get((int)index).name;
    }

    public List<String> getStringParts() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this.parts.size(); ++i) {
            ret.add(this.parts.get((int)i).name);
        }
        return ret;
    }

    public boolean isAttribute(int index) {
        if (index >= this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.parts.get((int)index).attribute;
    }

    public DottedChain subChain(int count) {
        if (count > this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        DottedChain ret = new DottedChain();
        ret.parts = new ArrayList<PathPart>(this.parts.subList(0, count));
        return ret;
    }

    public String getLast() {
        if (this.parts.isEmpty()) {
            return "";
        }
        return this.parts.get((int)(this.parts.size() - 1)).name;
    }

    public boolean isLastAttribute() {
        if (this.parts.isEmpty()) {
            return false;
        }
        return this.parts.get((int)(this.parts.size() - 1)).attribute;
    }

    public DottedChain getWithoutLast() {
        if (this.parts.size() < 2) {
            return TOPLEVEL;
        }
        return this.subChain(this.parts.size() - 1);
    }

    public DottedChain addWithSuffix(String name) {
        String addedNameNoSuffix = name;
        String addedNamespaceSuffix = "";
        if (name != null && name.matches(".*#[0-9]+$")) {
            addedNameNoSuffix = name.substring(0, name.lastIndexOf("#"));
            addedNamespaceSuffix = name.substring(name.lastIndexOf("#"));
        }
        return this.add(addedNameNoSuffix, addedNamespaceSuffix);
    }

    public DottedChain add(String name, String namespaceSuffix) {
        return this.add(false, name, namespaceSuffix);
    }

    public DottedChain add(boolean attribute, String name, String namespaceSuffix) {
        if (name == null) {
            return new DottedChain(this);
        }
        ArrayList<PathPart> newParts = new ArrayList<PathPart>(this.parts);
        newParts.add(new PathPart(name, attribute, namespaceSuffix));
        DottedChain ret = new DottedChain();
        ret.parts = newParts;
        return ret;
    }

    public DottedChain preAdd(String name, String namespaceSuffix) {
        return this.preAdd(false, name, namespaceSuffix);
    }

    public DottedChain preAdd(boolean attribute, String name, String namespaceSuffix) {
        if (name == null) {
            return new DottedChain(this);
        }
        ArrayList<PathPart> newParts = new ArrayList<PathPart>(this.parts);
        newParts.add(0, new PathPart(name, attribute, namespaceSuffix));
        DottedChain ret = new DottedChain();
        ret.parts = newParts;
        return ret;
    }

    public String toString() {
        return this.toRawString();
    }

    protected String toString(Set<String> usedDeobfuscations, SWF swf, boolean as3, boolean raw, boolean withSuffix) {
        if (this.parts.isEmpty()) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            if (i > 0) {
                ret.append(".");
            }
            if (this.parts.get((int)i).attribute) {
                ret.append("@");
            }
            String part = this.parts.get((int)i).name;
            boolean lastStar = i == this.parts.size() - 1 && "*".equals(part);
            ret.append(raw || lastStar ? part : IdentifiersDeobfuscation.printIdentifier(swf, usedDeobfuscations, as3, part, new String[0]));
            if (!withSuffix) continue;
            ret.append(this.parts.get((int)i).namespaceSuffix);
        }
        return ret.toString();
    }

    public String toFilePath(SWF swf) {
        if (this.parts.isEmpty()) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            if (i > 0) {
                ret.append(File.separator);
            }
            ret.append(Helper.makeFileName(IdentifiersDeobfuscation.printIdentifier(swf, new LinkedHashSet<String>(), true, this.parts.get((int)i).name, new String[0])));
        }
        return ret.toString();
    }

    public List<String> toList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (PathPart p : this.parts) {
            ret.add(p.name);
        }
        return ret;
    }

    public String toPrintableString(Set<String> usedDeobfuscations, SWF swf, boolean as3) {
        return this.toString(usedDeobfuscations, swf, as3, false, true);
    }

    public String toRawString() {
        return this.toString(new LinkedHashSet<String>(), null, false, true, true);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.parts);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DottedChain other = (DottedChain)obj;
        return Objects.equals(this.parts, other.parts);
    }

    @Override
    public int compareTo(DottedChain o) {
        return this.toRawString().compareTo(o.toRawString());
    }

    static {
        EMPTY = TOPLEVEL = new DottedChain(new String[0]);
        BOOLEAN = new DottedChain(new String[]{"Boolean"});
        STRING = new DottedChain(new String[]{"String"});
        ARRAY = new DottedChain(new String[]{"Array"});
        NUMBER = new DottedChain(new String[]{"Number"});
        DECIMAL = new DottedChain(new String[]{"decimal"});
        OBJECT = new DottedChain(new String[]{"Object"});
        INT = new DottedChain(new String[]{"int"});
        UINT = new DottedChain(new String[]{"uint"});
        UNDEFINED = new DottedChain(new String[]{"Undefined"});
        XML = new DottedChain(new String[]{"XML"});
        NULL = new DottedChain(new String[]{"null"});
        FUNCTION = new DottedChain(new String[]{"Function"});
        VOID = new DottedChain(new String[]{"void"});
        NAMESPACE = new DottedChain(new String[]{"Namespace"});
        ALL = new DottedChain(new String[]{"*"});
    }

    private static class PathPart
    implements Serializable {
        public String name;
        public boolean attribute;
        public String namespaceSuffix;

        public PathPart(String name, boolean attribute, String namespaceSuffix) {
            this.name = name;
            this.attribute = attribute;
            this.namespaceSuffix = namespaceSuffix;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Objects.hashCode(this.name);
            hash = 79 * hash + (this.attribute ? 1 : 0);
            hash = 79 * hash + Objects.hashCode(this.namespaceSuffix);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathPart other = (PathPart)obj;
            if (this.attribute != other.attribute) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.namespaceSuffix, other.namespaceSuffix);
        }
    }
}

