/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.graph.GraphPart;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Loop
implements Serializable {
    public GraphPart loopContinue;
    public GraphPart loopBreak;
    public GraphPart loopPreContinue;
    public Set<GraphPart> backEdges = new HashSet<GraphPart>();
    public List<GraphPart> breakCandidates = new ArrayList<GraphPart>();
    public List<Integer> breakCandidatesLevels = new ArrayList<Integer>();
    public final long id;
    public int leadsToMark;
    public int reachableMark;
    public int phase;
    public int breakCandidatesLocked = 0;
    public List<GraphPart> stopParts = new ArrayList<GraphPart>();

    public Loop(long id, GraphPart loopContinue, GraphPart loopBreak) {
        this.loopContinue = loopContinue;
        this.loopBreak = loopBreak;
        this.id = id;
    }

    public String toString() {
        HashSet<String> edgesAsStr = new HashSet<String>();
        for (GraphPart p : this.backEdges) {
            edgesAsStr.add(p.toString());
        }
        LinkedHashSet<String> bcAsStr = new LinkedHashSet<String>();
        for (int i = 0; i < this.breakCandidates.size(); ++i) {
            bcAsStr.add(this.breakCandidates.get(i) + " - level " + this.breakCandidatesLevels.get(i) + " - numblocks " + this.breakCandidates.get((int)i).numBlocks);
        }
        return "loop(id:" + this.id + (this.loopPreContinue != null ? ",precontinue:" + this.loopPreContinue : "") + ",continue:" + this.loopContinue + ", break:" + this.loopBreak + ", phase:" + this.phase + ", backedges: " + String.join((CharSequence)",", edgesAsStr) + ", breakCandidates: " + String.join((CharSequence)",", bcAsStr) + ")";
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Loop other = (Loop)obj;
        return this.id == other.id;
    }
}

