/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.Freed;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Component;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    public static String newLine;
    public static String hexData;
    public static String constants;
    public static String decompilationErrorAdd;
    private static final Map<BitSet, Area> shapeCache;
    private static final String[] hexStringCache;
    private static final String SPACES12 = "            ";
    private static final String ZEROS8 = "00000000";
    private static final BitSet fileNameInvalidChars;
    private static final List<String> invalidFilenamesParts;

    public static String intArrToString(int[] array) {
        StringBuilder sb = new StringBuilder();
        Helper.intArrToStringBuilder(array, sb);
        return sb.toString();
    }

    public static void intArrToStringBuilder(int[] array, StringBuilder sb) {
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        sb.append("]");
    }

    public static String byteArrToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(hexStringCache[array[i] & 0xFF]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String formatAddress(long number) {
        return Helper.formatAddress(number, Configuration.decimalAddress.get());
    }

    public static String formatAddress(long number, boolean decimal) {
        if (decimal) {
            return String.format("%05d", number);
        }
        return String.format("%04x", number);
    }

    public static String escapeString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c < ' ') {
                ret.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapeActionScriptString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (c == '\'') {
                ret.append("\\'");
                continue;
            }
            if (c < ' ') {
                ret.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String joinEscapePCodeString(String glue, Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        for (String s : collection) {
            if (sb.length() > 0) {
                sb.append(glue);
            }
            sb.append(Helper.escapePCodeString(s));
        }
        return sb.toString();
    }

    public static String escapeExportname(SWF swf, String s, boolean quote) {
        if (s.startsWith("__Packages.")) {
            return DottedChain.parseNoSuffix(s).toPrintableString(new LinkedHashSet<String>(), swf, false);
        }
        return (quote ? "\"" : "") + Helper.escapePCodeString(s) + (quote ? "\"" : "");
    }

    public static String unescapeExportname(SWF swf, String s) {
        if (s.startsWith("__Packages.")) {
            return DottedChain.parsePrintable(swf, s).toRawString();
        }
        return Helper.unescapePCodeString(s);
    }

    public static String escapePCodeString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (c == '\'') {
                ret.append("\\'");
                continue;
            }
            if (c < ' ') {
                ret.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            int num = 1;
            for (int j = i + 1; j < s.length() && s.charAt(j) == c; ++j) {
                ++num;
            }
            if (num > Configuration.limitSameChars.get()) {
                ret.append("\\{").append(num).append("}");
                i += num - 1;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String unescapePCodeString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                int endPos;
                if (i + 1 >= s.length() - 1) continue;
                if ((c = s.charAt(++i)) == 'n') {
                    ret.append("\n");
                    continue;
                }
                if (c == 'r') {
                    ret.append("\r");
                    continue;
                }
                if (c == 't') {
                    ret.append("\t");
                    continue;
                }
                if (c == 'b') {
                    ret.append("\b");
                    continue;
                }
                if (c == 'f') {
                    ret.append("\f");
                    continue;
                }
                if (c == '\\') {
                    ret.append("\\");
                    continue;
                }
                if (c == '\"') {
                    ret.append("\"");
                    continue;
                }
                if (c == '\'') {
                    ret.append("'");
                    continue;
                }
                if (c == 'x' && i + 2 < s.length() - 1) {
                    ret.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    i += 2;
                    continue;
                }
                if (c != '{' || (endPos = s.indexOf("}", i)) == -1) continue;
                int numRepeat = Integer.parseInt(s.substring(i + 1, endPos));
                i = endPos + 1;
                c = s.charAt(i);
                for (int j = 0; j < numRepeat; ++j) {
                    ret.append(c);
                }
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapePCodeEnglishString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (c == '\'') {
                ret.append("\\'");
                continue;
            }
            if (c < ' ') {
                ret.append("\\x").append(Helper.byteToHex((byte)c));
                continue;
            }
            int num = 1;
            for (int j = i + 1; j < s.length() && s.charAt(j) == c; ++j) {
                ++num;
            }
            if (num > Configuration.limitSameChars.get()) {
                ret.append("\\{").append(num).append("}");
                i += num - 1;
            }
            if (c >= '\u0080') {
                ret.append(String.format("\\u%04x", c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapeJavaString(String s) {
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (c < ' ') {
                ret.append("\\u00").append(Helper.byteToHex((byte)c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeJavaString(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block18: {
                int ch;
                block16: {
                    char nextChar;
                    block17: {
                        if (i >= st.length()) {
                            return sb.toString();
                        }
                        ch = st.charAt(i);
                        if (ch != 92) break block16;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block17;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block18;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block18;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    public static String getValidHtmlId(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || i > 0 && (ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == ':' || ch == '.')) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String formatHex(int value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(value));
        if (width > sb.length()) {
            sb.insert(0, ZEROS8, 0, width - sb.length());
        }
        return sb.toString();
    }

    public static String formatHex(long value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toHexString(value));
        if (width > sb.length()) {
            sb.insert(0, ZEROS8, 0, width - sb.length());
        }
        return sb.toString();
    }

    public static String formatInt(int value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (width > sb.length()) {
            sb.insert(0, SPACES12, 0, width - sb.length());
        }
        return sb.toString();
    }

    public static String indent(int level, String ss, String indentStr) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < level; ++ii) {
            sb.append(indentStr);
        }
        sb.append(ss);
        return sb.toString();
    }

    public static String indentRows(int level, String ss, String indentStr) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < level; ++ii) {
            sb.append(indentStr);
        }
        ss = ss.replaceAll("(\r\n|\r|\n)", "\r\n");
        ss = "\r\n" + ss;
        String repl = "\r\n" + sb.toString();
        if ((ss = ss.replace("\r\n", repl)).endsWith(repl)) {
            ss = ss.substring(0, ss.length() - sb.toString().length());
        }
        ss = ss.substring(2);
        return ss;
    }

    public static String unindentRows(int prefixLineCount, int level, String text) {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(text);
        String indentStr = "";
        for (int i = 0; i < level; ++i) {
            indentStr = indentStr + Configuration.getCodeFormatting().indentString;
        }
        int indentLength = indentStr.length();
        for (int i = 0; i < prefixLineCount; ++i) {
            scanner.nextLine();
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.startsWith(indentStr)) {
                sb.append(line.substring(indentLength)).append(Configuration.getCodeFormatting().newLineChars);
                continue;
            }
            return sb.toString();
        }
        return sb.toString();
    }

    public static int getLineCount(String s) {
        if (s.endsWith("\r\n")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("\r")) {
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        String[] parts = s.split("(\r\n|\r|\n)");
        return parts.length;
    }

    public static String padZeros(String number, int length) {
        int count = length - number.length();
        for (int i = 0; i < count; ++i) {
            number = "0" + number;
        }
        return number;
    }

    public static String padZeros(long number, int length) {
        String ret = Long.toString(number);
        while (ret.length() < length) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String byteToHex(byte b) {
        return hexStringCache[b & 0xFF];
    }

    public static String format(String str, int len) {
        if (len <= str.length()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        for (int ii = str.length(); ii < len; ++ii) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String joinStrings(Iterable<?> arr, String glue) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (Object s : arr) {
            if (!first) {
                ret.append(glue);
            } else {
                first = false;
            }
            ret.append(s);
        }
        return ret.toString();
    }

    public static String joinStrings(String[] arr, String glue) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String s : arr) {
            if (!first) {
                ret.append(glue);
            } else {
                first = false;
            }
            ret.append(s);
        }
        return ret.toString();
    }

    public static String joinStrings(List<String> arr, String formatString, String glue) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String s : arr) {
            if (!first) {
                ret.append(glue);
            } else {
                first = false;
            }
            ret.append(String.format(formatString, s));
        }
        return ret.toString();
    }

    public static String joinStrings(String[] arr, String formatString, String glue) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String s : arr) {
            if (!first) {
                ret.append(glue);
            } else {
                first = false;
            }
            ret.append(String.format(formatString, s));
        }
        return ret.toString();
    }

    public static <E> E deepCopy(E o) {
        try {
            Object copy;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
                oos.flush();
            }
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));){
                copy = ois.readObject();
            }
            return (E)copy;
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(Helper.class.getName()).log(Level.SEVERE, "Copy error", ex);
            return null;
        }
        catch (StackOverflowError se) {
            throw new StackOverflowError("Stack overflow in deepcopy");
        }
    }

    public static List<Object> toList(Object ... rest) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll(Arrays.asList(rest));
        return ret;
    }

    public static int[] toIntArray(Collection<Integer> list) {
        int[] ret = new int[list.size()];
        int i = 0;
        for (int i2 : list) {
            ret[i++] = i2;
        }
        return ret;
    }

    public static ByteArrayInputStream getInputStream(byte[] ... data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (byte[] d : data) {
                baos.write(d);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static byte[] readFile(String ... file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String f : file) {
            try (FileInputStream fis = new FileInputStream(f);){
                int cnt;
                byte[] buf = new byte[4096];
                while ((cnt = fis.read(buf)) > 0) {
                    baos.write(buf, 0, cnt);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Helper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileEx(String ... file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String f : file) {
            FileInputStream fis = null;
            try {
                int cnt;
                fis = new FileInputStream(f);
                byte[] buf = new byte[4096];
                while ((cnt = fis.read(buf)) > 0) {
                    baos.write(buf, 0, cnt);
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return baos.toByteArray();
    }

    public static String readTextFileEx(String ... file) throws IOException {
        byte[] data = Helper.readFileEx(file);
        if (data.length > 1 && data[0] == -17 && data[1] == -69 && data[2] == -65) {
            return new String(data, 3, data.length - 3, Utf8Helper.charset);
        }
        return new String(data, Utf8Helper.charset);
    }

    public static String readTextFile(String ... file) {
        byte[] data = Helper.readFile(file);
        if (data.length > 1 && data[0] == -17 && data[1] == -69 && data[2] == -65) {
            return new String(data, 3, data.length - 3, Utf8Helper.charset);
        }
        return new String(data, Utf8Helper.charset);
    }

    public static byte[] readStream(InputStream is) {
        if (is instanceof MemoryInputStream) {
            return ((MemoryInputStream)is).getAllRead();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Helper.copyStream(is, baos, Long.MAX_VALUE);
        return baos.toByteArray();
    }

    public static void copyStreamEx(InputStream is, OutputStream os) throws IOException {
        int bufSize = 4096;
        byte[] buf = new byte[4096];
        int cnt = 0;
        while ((cnt = is.read(buf)) > 0) {
            os.write(buf, 0, cnt);
        }
    }

    public static void copyStream(InputStream is, OutputStream os) {
        try {
            int bufSize = 4096;
            byte[] buf = new byte[4096];
            int cnt = 0;
            while ((cnt = is.read(buf)) > 0) {
                os.write(buf, 0, cnt);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyStream(InputStream is, OutputStream os, long maxLength) {
        try {
            int bufSize = 4096;
            byte[] buf = new byte[4096];
            int chunkSize = 4096;
            int cnt = 0;
            while (maxLength > 0L) {
                if (maxLength < 4096L) {
                    chunkSize = (int)maxLength;
                }
                if ((cnt = is.read(buf, 0, chunkSize)) > 0) {
                    os.write(buf, 0, cnt);
                    maxLength -= (long)cnt;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void appendFile(String file, byte[] ... data) {
        try (FileOutputStream fos = new FileOutputStream(file, true);){
            for (byte[] d : data) {
                fos.write(d);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeFile(String file, byte[] ... data) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            for (byte[] d : data) {
                fos.write(d);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeFile(String file, InputStream stream) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            Helper.copyStream(stream, fos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String stackToString(TranslateStack stack, LocalData localData) throws InterruptedException {
        String ret = "[";
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (i < stack.size() - 1) {
                ret = ret + ", ";
            }
            ret = ret + stack.get(i).toString(localData);
        }
        ret = ret + "]";
        return ret;
    }

    public static File fixDialogFile(File f) {
        String name;
        Pattern pat = Pattern.compile("\"([^\"]+)\"");
        Matcher m = pat.matcher(name = f.getAbsolutePath());
        if (m.find()) {
            f = new File(m.group(1));
        }
        return f;
    }

    public static String makeFileName(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0100' && fileNameInvalidChars.get(ch)) {
                sb.append("%").append(String.format("%02X", ch));
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            char lastChar = sb.charAt(sb.length() - 1);
            if (lastChar == ' ') {
                sb.setLength(sb.length() - 1);
                sb.append("%20");
            } else if (lastChar == '.') {
                sb.setLength(sb.length() - 1);
                sb.append("%2E");
            }
        }
        str = sb.toString();
        for (String inv : invalidFilenamesParts) {
            if (!str.startsWith(inv) || !str.equals(inv) && !str.startsWith(".")) continue;
            str = "_" + str;
        }
        if (str.isEmpty()) {
            str = "unnamed";
        }
        return str;
    }

    public static String strToHex(String s) {
        byte[] bs = Utf8Helper.getBytes(s);
        String sn = "";
        for (int i = 0; i < bs.length; ++i) {
            sn = sn + "0x" + Integer.toHexString(bs[i] & 0xFF) + " ";
        }
        return sn;
    }

    public static void emptyObject(Object obj) {
        Field[] fields;
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            if ((f.getModifiers() & 8) == 8 || f.getType().isPrimitive()) continue;
            try {
                f.setAccessible(true);
                Object v = f.get(obj);
                if (v == null) continue;
                try {
                    Freed freed;
                    if (v instanceof Collection) {
                        ((Collection)v).clear();
                    }
                    if (v instanceof Component && ((Component)v).getParent() != null) {
                        ((Component)v).getParent().remove((Component)v);
                    }
                    if (v instanceof Freed && !(freed = (Freed)v).isFreeing()) {
                        ((Freed)v).free();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                f.set(obj, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | UnsupportedOperationException ex) {
                throw new Error(ex);
            }
        }
    }

    public static String formatTimeSec(long timeMs) {
        long timeS = timeMs / 1000L;
        timeMs %= 1000L;
        long timeM = timeS / 60L;
        timeS %= 60L;
        long timeH = timeM / 60L;
        timeM %= 60L;
        String timeStr = "";
        if (timeH > 0L) {
            timeStr = timeStr + Helper.padZeros(timeH, 2) + ":";
        }
        timeStr = timeStr + Helper.padZeros(timeM, 2) + ":";
        timeStr = timeStr + Helper.padZeros(timeS, 2) + "." + Helper.padZeros(timeMs, 3);
        return timeStr;
    }

    public static String formatFileSize(long fileSizeLong) {
        double fileSize = fileSizeLong;
        if (fileSize < 1024.0) {
            return String.format("%d bytes", fileSizeLong);
        }
        if ((fileSize /= 1024.0) < 1024.0) {
            return String.format("%.2f KB", fileSize);
        }
        return String.format("%.2f MB", fileSize /= 1024.0);
    }

    public static void freeMem() {
        Cache.clearAll();
        System.gc();
    }

    public static String formatTimeToText(int timeS) {
        long timeM = timeS / 60;
        timeS %= 60;
        long timeH = timeM / 60L;
        timeM %= 60L;
        String timeStr = "";
        String strAnd = AppResources.translate("timeFormat.and");
        String strHour = AppResources.translate("timeFormat.hour");
        String strHours = AppResources.translate("timeFormat.hours");
        String strMinute = AppResources.translate("timeFormat.minute");
        String strMinutes = AppResources.translate("timeFormat.minutes");
        String strSecond = AppResources.translate("timeFormat.second");
        String strSeconds = AppResources.translate("timeFormat.seconds");
        if (timeH > 0L) {
            timeStr = timeStr + timeH + " " + (timeH > 1L ? strHours : strHour);
        }
        if (timeM > 0L) {
            if (timeStr.length() > 0) {
                timeStr = timeStr + " " + strAnd + " ";
            }
            timeStr = timeStr + timeM + " " + (timeM > 1L ? strMinutes : strMinute);
        }
        if (timeS > 0) {
            if (timeStr.length() > 0) {
                timeStr = timeStr + " " + strAnd + " ";
            }
            timeStr = timeStr + timeS + " " + (timeS > 1 ? strSeconds : strSecond);
        }
        return timeStr;
    }

    public static GraphTextWriter byteArrayToHexWithHeader(GraphTextWriter writer, byte[] data) {
        writer.appendNoHilight(hexData).newLine().newLine();
        return Helper.byteArrayToHex(writer, data, 8, 8, false, false);
    }

    public static String bytesToHexString(byte[] bytes) {
        return Helper.bytesToHexString(bytes, 0);
    }

    public static String bytesToHexString(byte[] bytes, int start) {
        StringBuilder sb = new StringBuilder();
        if (start < bytes.length) {
            for (int ii = start; ii < bytes.length; ++ii) {
                sb.append(Helper.formatHex(bytes[ii] & 0xFF, 2));
                sb.append(' ');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String bytesToHexString(int maxByteCountInString, byte[] bytes, int start) {
        if (bytes.length - start <= maxByteCountInString) {
            return Helper.bytesToHexString(bytes, start);
        }
        byte[] trailingBytes = new byte[maxByteCountInString / 2];
        byte[] headingBytes = new byte[maxByteCountInString - trailingBytes.length];
        System.arraycopy(bytes, start, headingBytes, 0, headingBytes.length);
        int startOfTrailingBytes = bytes.length - trailingBytes.length;
        System.arraycopy(bytes, startOfTrailingBytes, trailingBytes, 0, trailingBytes.length);
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.bytesToHexString(headingBytes, 0));
        if (trailingBytes.length > 0) {
            sb.append(" ... ");
            sb.append(Helper.bytesToHexString(trailingBytes, 0));
        }
        return sb.toString();
    }

    public static String byteArrayToHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(hexStringCache[b & 0xFF]);
        }
        return sb.toString();
    }

    public static GraphTextWriter byteArrayToHex(GraphTextWriter writer, byte[] data, int bytesPerRow, int groupSize, boolean addChars, boolean showAddress) {
        int length = data.length;
        int rowCount = length / bytesPerRow;
        if (length % bytesPerRow > 0) {
            ++rowCount;
        }
        long address = 0L;
        for (int row = 0; row < rowCount; ++row) {
            int idx;
            int i;
            if (row > 0) {
                writer.newLine();
            }
            if (showAddress) {
                writer.appendNoHilight("0x" + String.format("%08x ", address));
            }
            for (i = 0; i < bytesPerRow; ++i) {
                idx = row * bytesPerRow + i;
                if (length > idx) {
                    if (i > 0 && i % groupSize == 0) {
                        writer.appendNoHilight(" ");
                    }
                    writer.appendNoHilight(Helper.byteToHex(data[idx])).appendNoHilight(" ");
                } else if (addChars) {
                    if (i > 0 && i % groupSize == 0) {
                        writer.appendNoHilight(" ");
                    }
                    writer.appendNoHilight("   ");
                }
                address += (long)bytesPerRow;
            }
            if (!addChars) continue;
            writer.appendNoHilight("  ");
            for (i = 0; i < bytesPerRow && length != (idx = row * bytesPerRow + i); ++i) {
                int ch;
                if (i > 0 && i % groupSize == 0) {
                    writer.appendNoHilight(" ");
                }
                if ((ch = data[idx]) >= 0 && ch < 32) {
                    ch = 46;
                }
                writer.appendNoHilight((char)ch + "");
            }
        }
        writer.newLine();
        return writer;
    }

    public static byte[] getBytesFromHexaText(String text) {
        Scanner scanner = new Scanner(text);
        scanner.nextLine();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            if (line.startsWith(";")) continue;
            line = line.replace(" ", "");
            for (int i = 0; i < line.length() / 2; ++i) {
                String hexStr = line.substring(i * 2, (i + 1) * 2);
                byte b = (byte)Integer.parseInt(hexStr, 16);
                baos.write(b);
            }
        }
        byte[] data = baos.toByteArray();
        return data;
    }

    public static List<List<String>> getConstantPoolsFromText(String text) {
        Scanner scanner = new Scanner(text);
        scanner.nextLine();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> cPool = new ArrayList<String>();
        result.add(cPool);
        while (scanner.hasNextLine()) {
            String[] parts;
            String line = scanner.nextLine();
            if (line.startsWith("---")) {
                cPool = new ArrayList();
                result.add(cPool);
            }
            if ((parts = line.split("\\|", 2)).length < 2) continue;
            cPool.add(Helper.unescapeJavaString(parts[1]));
        }
        return result;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    public static void saveStream(InputStream is, File output) throws IOException {
        byte[] buf = new byte[4096];
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(output));){
            int cnt;
            while ((cnt = is.read(buf)) > 0) {
                ((OutputStream)fos).write(buf, 0, cnt);
                ((OutputStream)fos).flush();
            }
        }
    }

    public static String getDecompilationSkippedComment() {
        return "// " + AppResources.translate("decompilation.skipped");
    }

    public static void appendTimeoutCommentAs2(GraphTextWriter writer, int timeout, int actionCount) {
        writer.appendNoHilight("/*").newLine();
        writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError")).newLine();
        writer.appendNoHilight(" * ").appendNoHilight(MessageFormat.format(AppResources.translate("decompilationError.timeout"), Helper.formatTimeToText(timeout))).newLine();
        if (actionCount > 0) {
            writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError.actionCount") + " " + actionCount).newLine();
        }
        writer.appendNoHilight(" */").newLine();
        writer.appendNoHilight("throw new Error(\"").appendNoHilight(AppResources.translate("decompilationError.timeout.description")).appendNoHilight("\");").newLine();
    }

    public static void appendTimeoutCommentAs3(GraphTextWriter writer, int timeout, int instructionCount) {
        writer.appendNoHilight("/*").newLine();
        writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError")).newLine();
        writer.appendNoHilight(" * ").appendNoHilight(MessageFormat.format(AppResources.translate("decompilationError.timeout"), Helper.formatTimeToText(timeout))).newLine();
        if (instructionCount > 0) {
            writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError.instructionCount") + " " + instructionCount).newLine();
        }
        writer.appendNoHilight(" */").newLine();
        writer.appendNoHilight("throw new flash.errors.IllegalOperationError(\"").appendNoHilight(AppResources.translate("decompilationError.timeout.description")).appendNoHilight("\");").newLine();
    }

    public static void appendErrorComment(GraphTextWriter writer, Throwable ex) {
        writer.appendNoHilight("/*").newLine();
        writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError")).newLine();
        writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError.obfuscated")).newLine();
        if (decompilationErrorAdd != null) {
            writer.appendNoHilight(" * ").appendNoHilight(decompilationErrorAdd).newLine();
        }
        writer.appendNoHilight(" * ").appendNoHilight(AppResources.translate("decompilationError.errorType")).appendNoHilight(": " + ex.getClass().getSimpleName() + " (" + ex.getMessage() + ")").newLine();
        writer.appendNoHilight(" */").newLine();
        writer.appendNoHilight("throw new flash.errors.IllegalOperationError(\"").appendNoHilight(AppResources.translate("decompilationError.error.description")).appendNoHilight("\");").newLine();
    }

    public static String escapeHTML(String text) {
        String[] from = new String[]{"&", "<", ">", "\"", "'", "/", "\r\n", "\r", "\n"};
        String[] to = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&#x27;", "&#x2F;", "&#xD;", "&#xD;", "&#xD;"};
        for (int i = 0; i < from.length; ++i) {
            text = text.replace(from[i], to[i]);
        }
        return text;
    }

    public static boolean containsInvalidXMLCharacter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Helper.isCharacterValidInXml(ch)) continue;
            return true;
        }
        return false;
    }

    public static String escapeXmlExportString(String s) {
        if (s.matches("^ +$")) {
            StringBuilder ret = new StringBuilder(s.length());
            for (int i = 0; i < s.length(); ++i) {
                ret.append("\\u0020");
            }
            return ret.toString();
        }
        StringBuilder ret = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            if (c == '\b') {
                ret.append("\\b");
                continue;
            }
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c < ' ') {
                ret.append("\\u00").append(Helper.byteToHex((byte)c));
                continue;
            }
            if (!Helper.isCharacterValidInXml(c)) {
                ret.append("\\u").append(String.format("%04x", c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeXmlExportString(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block16: {
                int ch;
                block14: {
                    char nextChar;
                    block15: {
                        if (i >= st.length()) {
                            return sb.toString();
                        }
                        ch = st.charAt(i);
                        if (ch != 92) break block14;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block15;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block16;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block16;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    public static String removeInvalidXMLCharacters(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Helper.isCharacterValidInXml(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isCharacterValidInXml(char ch) {
        return ch > '\u001f' && ch < '\ud800' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd';
    }

    public static Shape imageToShapeOld(BufferedImage image) {
        int y;
        int x;
        Area area = new Area();
        Rectangle rectangle = new Rectangle();
        int width = image.getWidth();
        int height = image.getHeight();
        int type = image.getType();
        int[] imgData = type == 3 || type == 1 ? ((DataBufferInt)image.getRaster().getDataBuffer()).getData() : image.getRGB(0, 0, width, height, null, 0, width);
        BitSet bs = new BitSet(width * height);
        bs.set(type);
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                int idx = width * y + x;
                if (imgData[idx] >>> 24 <= 0) continue;
                bs.set(idx);
            }
        }
        if (shapeCache.containsKey(bs)) {
            return shapeCache.get(bs);
        }
        for (x = 0; x < width; ++x) {
            int y1 = Integer.MAX_VALUE;
            int y2 = -1;
            for (y = 0; y < height; ++y) {
                int rgb = imgData[width * y + x];
                if ((rgb >>>= 24) <= 0) continue;
                if (y1 == Integer.MAX_VALUE) {
                    y1 = y;
                    y2 = y;
                }
                if (y > y2 + 1) {
                    rectangle.setBounds(x, y1, 1, y2 - y1 + 1);
                    area.add(new Area(rectangle));
                    y1 = y;
                }
                y2 = y;
            }
            if (y2 - y1 < 0) continue;
            rectangle.setBounds(x, y1, 1, y2 - y1 + 1);
            area.add(new Area(rectangle));
        }
        shapeCache.put(bs, area);
        return area;
    }

    public static Shape imageToShape(BufferedImage image) {
        Area area = new Area();
        int width = image.getWidth();
        int height = image.getHeight();
        int type = image.getType();
        int[] imgData = type == 3 || type == 1 ? ((DataBufferInt)image.getRaster().getDataBuffer()).getData() : image.getRGB(0, 0, width, height, null, 0, width);
        BitSet bs = new BitSet(width * height);
        bs.set(type);
        int pixelCount = width * height;
        for (int i = 0; i < pixelCount; ++i) {
            if (imgData[i] >>> 24 <= 0) continue;
            bs.set(i);
        }
        if (shapeCache.containsKey(bs)) {
            return shapeCache.get(bs);
        }
        BitSet bsArea = new BitSet(width * height);
        boolean modified = true;
        ArrayList<Integer> leftCoordsX = new ArrayList<Integer>();
        ArrayList<Integer> leftCoordsY = new ArrayList<Integer>();
        ArrayList<Integer> rightCoordsX = new ArrayList<Integer>();
        ArrayList<Integer> rightCoordsY = new ArrayList<Integer>();
        while (modified) {
            modified = false;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int idx = width * y + x;
                    if (imgData[idx] >>> 24 <= 0 || bsArea.get(idx)) continue;
                    leftCoordsX.clear();
                    leftCoordsY.clear();
                    rightCoordsX.clear();
                    rightCoordsY.clear();
                    int leftX = x;
                    int rightX = Helper.findRight(imgData, x, y, width);
                    leftCoordsX.add(leftX);
                    leftCoordsY.add(y);
                    rightCoordsX.add(rightX);
                    rightCoordsY.add(y);
                    Helper.setBitSet(bsArea, leftX, rightX, y, width);
                    for (int y2 = y + 1; y2 < height; ++y2) {
                        leftCoordsX.add(leftX);
                        leftCoordsY.add(y2);
                        rightCoordsX.add(rightX);
                        rightCoordsY.add(y2);
                        int leftX2 = Helper.findFirst(imgData, leftX, rightX, y2, width);
                        if (leftX2 == -1) break;
                        int rightX2 = Helper.findRight(imgData, leftX2, y2, width);
                        if (leftX2 != leftX) {
                            leftCoordsX.add(leftX2);
                            leftCoordsY.add(y2);
                        }
                        if (rightX2 != rightX) {
                            rightCoordsX.add(rightX2);
                            rightCoordsY.add(y2);
                        }
                        leftX = leftX2;
                        rightX = rightX2;
                        Helper.setBitSet(bsArea, leftX, rightX, y2, width);
                    }
                    int cnt = leftCoordsX.size() + rightCoordsX.size();
                    int[] xCoords = new int[cnt];
                    int[] yCoords = new int[cnt];
                    for (int i = 0; i < rightCoordsX.size(); ++i) {
                        xCoords[i] = (Integer)rightCoordsX.get(i);
                        yCoords[i] = (Integer)rightCoordsY.get(i);
                    }
                    int offset = rightCoordsX.size();
                    for (int i = 0; i < leftCoordsX.size(); ++i) {
                        int idx2 = leftCoordsX.size() - i - 1;
                        xCoords[i + offset] = (Integer)leftCoordsX.get(idx2);
                        yCoords[i + offset] = (Integer)leftCoordsY.get(idx2);
                    }
                    Area area2 = new Area(new Polygon(xCoords, yCoords, xCoords.length));
                    area.add(area2);
                    modified = true;
                }
            }
        }
        shapeCache.put(bs, area);
        return area;
    }

    private static void setBitSet(BitSet bitSet, int x1, int x2, int y, int width) {
        int idx2 = width * y + x2;
        for (int idx = width * y + x1; idx < idx2; ++idx) {
            bitSet.set(idx);
        }
    }

    private static int findFirst(int[] imgData, int x1, int x2, int y, int width) {
        int idx = width * y + x1;
        if (imgData[idx] >>> 24 > 0) {
            while (x1 > 0 && imgData[idx - 1] >>> 24 > 0) {
                --x1;
                --idx;
            }
            return x1;
        }
        int idx2 = width * y + x2;
        while (idx < idx2) {
            if (imgData[idx] >>> 24 > 0) {
                return x1;
            }
            ++x1;
            ++idx;
        }
        return -1;
    }

    private static int findRight(int[] imgData, int x, int y, int width) {
        int result = x;
        int idx = width * y + x;
        while (result < width && imgData[idx] >>> 24 > 0) {
            ++result;
            ++idx;
        }
        return result;
    }

    public static void clearShapeCache() {
        shapeCache.clear();
    }

    public static String byteArrayToBase64String(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] base64StringToByteArray(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static String doubleStr(double d) {
        String ret = Double.toString(d);
        if (ret.endsWith(".0")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static String byteCountStr(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String getNextId(String str, Map<String, Integer> lastIds) {
        return Helper.getNextId(str, lastIds, false);
    }

    public static String getNextId(String str, Map<String, Integer> lastIds, boolean addFirst) {
        Integer a = lastIds.get(str);
        if (a == null) {
            lastIds.put(str, 1);
            if (addFirst) {
                str = str + "_1";
            }
            return str;
        }
        Integer n = a;
        Integer n2 = a = Integer.valueOf(a + 1);
        lastIds.put(str, a);
        return str + "_" + a;
    }

    public static boolean is64BitJre() {
        String prop = System.getProperty("sun.arch.data.model");
        return prop != null && prop.contains("64");
    }

    public static boolean is64BitOs() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (arch == null) {
            return false;
        }
        return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
    }

    public static byte[] downloadUrl(String urlString) throws IOException {
        URLConnection uc;
        String proxyAddress = Configuration.updateProxyAddress.get();
        URL url = URI.create(urlString).toURL();
        if (proxyAddress != null && !proxyAddress.isEmpty()) {
            int port = 8080;
            if (proxyAddress.contains(":")) {
                String[] parts = proxyAddress.split(":");
                port = Integer.parseInt(parts[1]);
                proxyAddress = parts[0];
            }
            uc = url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress, port)));
        } else {
            uc = url.openConnection();
        }
        uc.setRequestProperty("User-Agent", ApplicationInfo.shortApplicationVerName);
        uc.connect();
        return Helper.readStream(uc.getInputStream());
    }

    public static String downloadUrlString(String url) throws IOException {
        byte[] data = Helper.downloadUrl(url);
        String text = new String(data, Utf8Helper.charset);
        return text;
    }

    public static int getJavaVersion() {
        int dot;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        }
        if ((dot = version.indexOf(".")) != -1) {
            version = version.substring(0, dot);
        }
        return Integer.parseInt(version);
    }

    public static List<String> splitString(String delimiter, String str) {
        int end;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        while ((end = str.indexOf(delimiter, start)) != -1) {
            result.add(str.substring(start, end));
            start = end + 1;
        }
        result.add(str.substring(start));
        return result;
    }

    static {
        int i;
        newLine = System.getProperty("line.separator");
        hexData = "#hexdata";
        constants = "#constants";
        decompilationErrorAdd = null;
        shapeCache = new HashMap<BitSet, Area>();
        hexStringCache = new String[256];
        for (int i2 = 0; i2 < hexStringCache.length; ++i2) {
            Helper.hexStringCache[i2] = String.format("%02x", i2);
        }
        BitSet toEncode = new BitSet(256);
        for (i = 0; i < 32; ++i) {
            toEncode.set(i);
        }
        toEncode.set(92);
        toEncode.set(47);
        toEncode.set(58);
        toEncode.set(42);
        toEncode.set(63);
        toEncode.set(34);
        toEncode.set(60);
        toEncode.set(62);
        toEncode.set(124);
        fileNameInvalidChars = toEncode;
        invalidFilenamesParts = new ArrayList<String>();
        invalidFilenamesParts.add("CON");
        invalidFilenamesParts.add("PRN");
        invalidFilenamesParts.add("AUX");
        invalidFilenamesParts.add("CLOCK$");
        invalidFilenamesParts.add("NUL");
        for (i = 1; i <= 9; ++i) {
            invalidFilenamesParts.add("COM" + i);
            invalidFilenamesParts.add("LPT" + i);
        }
    }
}

