/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlPrettyFormat {
    private static final String PRETTY_PRINT_XSLT = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n    <xsl:strip-space elements=\"*\"/>\n    <xsl:output method=\"xml\" encoding=\"UTF-8\"/>\n\n    <xsl:template match=\"@*|node()\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"@*|node()\"/>\n        </xsl:copy>\n    </xsl:template>\n\n</xsl:stylesheet>";

    public boolean prettyFormat(Source source, Result result, int indent, boolean withXmlDeclaration) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(PRETTY_PRINT_XSLT)));
            transformer.setOutputProperty("indent", "yes");
            if (!withXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(source, result);
            return true;
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
            Logger.getLogger(XmlPrettyFormat.class.getName()).log(Level.SEVERE, "Pretty print error", e);
            return false;
        }
    }

    public boolean prettyFormat(File source, File result, int indent, boolean withXmlDeclaration) {
        return this.prettyFormat(new StreamSource(source), new StreamResult(result), indent, withXmlDeclaration);
    }

    public String prettyFormat(String input, int indent, boolean withXmlDeclaration) {
        StreamSource xmlInput = new StreamSource(new StringReader(input));
        StringWriter stringWriter = new StringWriter();
        StreamResult xmlOutput = new StreamResult(stringWriter);
        if (!this.prettyFormat(xmlInput, xmlOutput, indent, withXmlDeclaration)) {
            return input;
        }
        return xmlOutput.getWriter().toString();
    }
}

