/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers.utf8.charset;

import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.jpexs.helpers.utf8.charset.AbstractCharsetConverter;
import com.jpexs.helpers.utf8.charset.Gb2312;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Gb18030
extends AbstractCharsetConverter {
    private static int[][] gb18030_index_to_cp_len2_record = new int[126][191];
    private static final int GB18030_NULL = 0;
    private static int[] gb18030_len4_record_shift = new int[]{0, -1546, -2806, -4066, -5326, -6586, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -41987, -43247, -44507, -45767, -47027, -48287, -49547, -50807, -52067, -53327, 11, -59963, -61223, -62483, 12, 13};
    private static int[][] gb18030_index_to_cp_len4_record = new int[14][1260];
    private static int[] gb18030_cp_to_index_record = new int[61339];

    public static int gb18030_index_to_cp_len2(int byte1, int byte2) {
        if (129 <= byte1 && byte1 <= 254 && 64 <= byte2 && byte2 <= 254) {
            return gb18030_index_to_cp_len2_record[byte1 - 129][byte2 - 64];
        }
        return 0;
    }

    public static int gb18030_index_to_cp_len4(int byte1, int byte2, int byte3, int byte4) {
        int pos_1 = (byte1 -= 129) * 10 + (byte2 -= 48);
        int pos_2 = (byte3 -= 129) * 10 + (byte4 -= 48);
        if (pos_1 <= 31 && pos_2 <= 1259) {
            if (gb18030_len4_record_shift[pos_1] < 0) {
                return pos_2 - gb18030_len4_record_shift[pos_1];
            }
            return gb18030_index_to_cp_len4_record[gb18030_len4_record_shift[pos_1]][pos_2];
        }
        return 0;
    }

    @Override
    public int toUnicode(int codepoint) {
        int result = 0;
        if (0 <= codepoint && codepoint <= 55295) {
            result = gb18030_cp_to_index_record[codepoint];
        } else if (59493 <= codepoint && codepoint <= 65535) {
            result = gb18030_cp_to_index_record[codepoint - 4197];
        }
        return result == 0 ? 0 : result;
    }

    @Override
    public int fromUnicode(int codePoint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        InputStream is = Gb18030.class.getResourceAsStream("/com/jpexs/helpers/utf8/charset/Gb18030data.bin");
        if (is == null) {
            System.exit(0);
        }
        ActionScriptLexer lexer = new ActionScriptLexer(new InputStreamReader(is, Utf8Helper.charset));
        try {
            Gb18030.readTwoDimensionalInt(gb18030_index_to_cp_len2_record, lexer);
            Gb18030.readTwoDimensionalInt(gb18030_index_to_cp_len4_record, lexer);
            Gb18030.readOneDimensionalInt(gb18030_cp_to_index_record, lexer);
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(Gb2312.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

