/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontInputStream;
import com.google.typography.font.sfntly.data.FontOutputStream;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.math.Fixed1616;
import com.google.typography.font.sfntly.math.FontMath;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class Font {
    private static final Logger logger = Logger.getLogger(Font.class.getCanonicalName());
    private static final List<Integer> CFF_TABLE_ORDERING;
    private static final List<Integer> TRUE_TYPE_TABLE_ORDERING;
    public static final int SFNTVERSION_1;
    private final int sfntVersion;
    private final byte[] digest;
    private long checksum;
    private Map<Integer, ? extends Table> tables;

    private Font(int n, byte[] byArray) {
        this.sfntVersion = n;
        this.digest = byArray;
    }

    public int sfntVersion() {
        return this.sfntVersion;
    }

    public byte[] digest() {
        if (this.digest == null) {
            return null;
        }
        return Arrays.copyOf(this.digest, this.digest.length);
    }

    public long checksum() {
        return this.checksum;
    }

    public int numTables() {
        return this.tables.size();
    }

    public Iterator<? extends Table> iterator() {
        return this.tables.values().iterator();
    }

    public boolean hasTable(int n) {
        return this.tables.containsKey(n);
    }

    public <T extends Table> T getTable(int n) {
        return (T)this.tables.get(n);
    }

    public Map<Integer, ? extends Table> tableMap() {
        return Collections.unmodifiableMap(this.tables);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digest = ");
        byte[] byArray = this.digest();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = 0xFF & byArray[i];
                if (n < 16) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toHexString(n));
            }
        }
        stringBuilder.append("\n[");
        stringBuilder.append(Fixed1616.toString(this.sfntVersion));
        stringBuilder.append(", ");
        stringBuilder.append(this.numTables());
        stringBuilder.append("]\n");
        Iterator<? extends Table> iterator = this.iterator();
        while (iterator.hasNext()) {
            FontDataTable fontDataTable = iterator.next();
            stringBuilder.append("\t");
            stringBuilder.append(fontDataTable);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    void serialize(OutputStream outputStream, List<Integer> list) throws IOException {
        List<Integer> list2 = this.generateTableOrdering(list);
        List<Header> list3 = this.buildTableHeadersForSerialization(list2);
        FontOutputStream fontOutputStream = new FontOutputStream(outputStream);
        this.serializeHeader(fontOutputStream, list3);
        this.serializeTables(fontOutputStream, list3);
    }

    private List<Header> buildTableHeadersForSerialization(List<Integer> list) {
        List<Integer> list2 = this.generateTableOrdering(list);
        ArrayList<Header> arrayList = new ArrayList<Header>(this.numTables());
        int n = Offset.tableRecordBegin.offset + this.numTables() * Offset.tableRecordSize.offset;
        for (Integer n2 : list2) {
            Table table = this.tables.get(n2);
            if (table == null) continue;
            arrayList.add(new Header(n2, table.calculatedChecksum(), n, table.header().length()));
            n += table.dataLength() + 3 & 0xFFFFFFFC;
        }
        return arrayList;
    }

    private void serializeHeader(FontOutputStream fontOutputStream, List<Header> list) throws IOException {
        fontOutputStream.writeFixed(this.sfntVersion);
        fontOutputStream.writeUShort(list.size());
        int n = FontMath.log2(list.size());
        int n2 = 2 << n - 1 + 4;
        fontOutputStream.writeUShort(n2);
        fontOutputStream.writeUShort(n);
        fontOutputStream.writeUShort(list.size() * 16 - n2);
        ArrayList<Header> arrayList = new ArrayList<Header>(list);
        Collections.sort(arrayList, Header.COMPARATOR_BY_TAG);
        for (Header header : arrayList) {
            fontOutputStream.writeULong(header.tag());
            fontOutputStream.writeULong(header.checksum());
            fontOutputStream.writeULong(header.offset());
            fontOutputStream.writeULong(header.length());
        }
    }

    private void serializeTables(FontOutputStream fontOutputStream, List<Header> list) throws IOException {
        for (Header header : list) {
            Object t = this.getTable(header.tag());
            if (t == null) {
                throw new IOException("Table out of sync with font header.");
            }
            int n = ((FontDataTable)t).serialize(fontOutputStream);
            int n2 = (n + 3 & 0xFFFFFFFC) - n;
            for (int i = 0; i < n2; ++i) {
                fontOutputStream.write(0);
            }
        }
    }

    private List<Integer> generateTableOrdering(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tables.size());
        if (list == null) {
            list = this.defaultTableOrdering();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.tables.keySet());
        for (Integer n : list) {
            if (!this.hasTable(n)) continue;
            arrayList.add(n);
            treeSet.remove(n);
        }
        for (Integer n : treeSet) {
            arrayList.add(n);
        }
        return arrayList;
    }

    private List<Integer> defaultTableOrdering() {
        if (this.hasTable(Tag.CFF)) {
            return CFF_TABLE_ORDERING;
        }
        return TRUE_TYPE_TABLE_ORDERING;
    }

    static {
        Integer[] integerArray = new Integer[]{Tag.head, Tag.hhea, Tag.maxp, Tag.OS_2, Tag.name, Tag.cmap, Tag.post, Tag.CFF};
        ArrayList arrayList = new ArrayList(integerArray.length);
        Collections.addAll(arrayList, integerArray);
        CFF_TABLE_ORDERING = Collections.unmodifiableList(arrayList);
        Integer[] integerArray2 = new Integer[]{Tag.head, Tag.hhea, Tag.maxp, Tag.OS_2, Tag.hmtx, Tag.LTSH, Tag.VDMX, Tag.hdmx, Tag.cmap, Tag.fpgm, Tag.prep, Tag.cvt, Tag.loca, Tag.glyf, Tag.kern, Tag.name, Tag.post, Tag.gasp, Tag.PCLT, Tag.DSIG};
        ArrayList arrayList2 = new ArrayList(integerArray2.length);
        Collections.addAll(arrayList2, integerArray2);
        TRUE_TYPE_TABLE_ORDERING = Collections.unmodifiableList(arrayList2);
        SFNTVERSION_1 = Fixed1616.fixed(1, 0);
    }

    public static final class Builder {
        private Map<Integer, Table.Builder<? extends Table>> tableBuilders;
        private FontFactory factory;
        private int sfntVersion = SFNTVERSION_1;
        private int numTables;
        private int searchRange;
        private int entrySelector;
        private int rangeShift;
        private Map<Header, WritableFontData> dataBlocks;
        private byte[] digest;

        private Builder(FontFactory fontFactory) {
            this.factory = fontFactory;
            this.tableBuilders = new HashMap<Integer, Table.Builder<? extends Table>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFont(InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new IOException("No input stream for font.");
            }
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new FontInputStream(inputStream);
                SortedSet<Header> sortedSet = this.readHeader((FontInputStream)filterInputStream);
                this.dataBlocks = this.loadTableData(sortedSet, (FontInputStream)filterInputStream);
                this.tableBuilders = this.buildAllTableBuilders(this.dataBlocks);
            }
            finally {
                filterInputStream.close();
            }
        }

        private void loadFont(WritableFontData writableFontData, int n) throws IOException {
            if (writableFontData == null) {
                throw new IOException("No data for font.");
            }
            SortedSet<Header> sortedSet = this.readHeader(writableFontData, n);
            this.dataBlocks = this.loadTableData(sortedSet, writableFontData);
            this.tableBuilders = this.buildAllTableBuilders(this.dataBlocks);
        }

        static final Builder getOTFBuilder(FontFactory fontFactory, InputStream inputStream) throws IOException {
            Builder builder = new Builder(fontFactory);
            builder.loadFont(inputStream);
            return builder;
        }

        static final Builder getOTFBuilder(FontFactory fontFactory, WritableFontData writableFontData, int n) throws IOException {
            Builder builder = new Builder(fontFactory);
            builder.loadFont(writableFontData, n);
            return builder;
        }

        static final Builder getOTFBuilder(FontFactory fontFactory) {
            return new Builder(fontFactory);
        }

        public FontFactory getFontFactory() {
            return this.factory;
        }

        public boolean readyToBuild() {
            if (this.tableBuilders == null && this.dataBlocks != null && this.dataBlocks.size() > 0) {
                return true;
            }
            for (Table.Builder<? extends Table> builder : this.tableBuilders.values()) {
                if (builder.readyToBuild()) continue;
                return false;
            }
            return true;
        }

        public Font build() {
            Map<Integer, Table> map = null;
            Font font = new Font(this.sfntVersion, this.digest);
            if (this.tableBuilders.size() > 0) {
                map = Builder.buildTablesFromBuilders(font, this.tableBuilders);
            }
            font.tables = map;
            this.tableBuilders = null;
            this.dataBlocks = null;
            return font;
        }

        public void setDigest(byte[] byArray) {
            this.digest = byArray;
        }

        public void clearTableBuilders() {
            this.tableBuilders.clear();
        }

        public boolean hasTableBuilder(int n) {
            return this.tableBuilders.containsKey(n);
        }

        public Table.Builder<? extends Table> getTableBuilder(int n) {
            Table.Builder<? extends Table> builder = this.tableBuilders.get(n);
            return builder;
        }

        public Table.Builder<? extends Table> newTableBuilder(int n) {
            Header header = new Header(n);
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, null);
            this.tableBuilders.put(header.tag(), builder);
            return builder;
        }

        public Table.Builder<? extends Table> newTableBuilder(int n, ReadableFontData readableFontData) {
            WritableFontData writableFontData = WritableFontData.createWritableFontData(readableFontData.length());
            readableFontData.copyTo(writableFontData);
            Header header = new Header(n, writableFontData.length());
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, writableFontData);
            this.tableBuilders.put(n, builder);
            return builder;
        }

        public Map<Integer, Table.Builder<? extends Table>> tableBuilderMap() {
            return Collections.unmodifiableMap(this.tableBuilders);
        }

        public Table.Builder<? extends Table> removeTableBuilder(int n) {
            return this.tableBuilders.remove(n);
        }

        public int tableBuilderCount() {
            return this.tableBuilders.size();
        }

        private int sfntWrapperSize() {
            return Offset.sfntHeaderSize.offset + Offset.tableRecordSize.offset * this.tableBuilders.size();
        }

        private Map<Integer, Table.Builder<? extends Table>> buildAllTableBuilders(Map<Header, WritableFontData> map) {
            HashMap<Integer, Table.Builder<? extends Table>> hashMap = new HashMap<Integer, Table.Builder<? extends Table>>();
            Set<Header> set = map.keySet();
            for (Header header : set) {
                Table.Builder<? extends Table> builder = this.getTableBuilder(header, map.get(header));
                hashMap.put(header.tag(), builder);
            }
            Builder.interRelateBuilders(hashMap);
            return hashMap;
        }

        private Table.Builder<? extends Table> getTableBuilder(Header header, WritableFontData writableFontData) {
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, writableFontData);
            return builder;
        }

        private static Map<Integer, Table> buildTablesFromBuilders(Font font, Map<Integer, Table.Builder<? extends Table>> map) {
            TreeMap<Integer, Table> treeMap = new TreeMap<Integer, Table>();
            Builder.interRelateBuilders(map);
            long l = 0L;
            boolean bl = false;
            FontDataTable.Builder builder = null;
            for (Table.Builder<? extends Table> builder2 : map.values()) {
                Table table = null;
                if (Tag.isHeaderTable(builder2.header().tag())) {
                    builder = (FontHeaderTable.Builder)builder2;
                    continue;
                }
                if (builder2.readyToBuild()) {
                    bl |= builder2.changed();
                    table = (Table)builder2.build();
                }
                if (table == null) {
                    throw new RuntimeException("Unable to build table - " + builder2);
                }
                long l2 = table.calculatedChecksum();
                l += l2;
                treeMap.put(table.header().tag(), table);
            }
            Object object = null;
            if (builder != null) {
                if (bl) {
                    ((FontHeaderTable.Builder)builder).setFontChecksum(l);
                }
                if (builder.readyToBuild()) {
                    bl |= builder.changed();
                    object = ((TableBasedTableBuilder)builder).build();
                }
                if (object == null) {
                    throw new RuntimeException("Unable to build table - " + builder);
                }
                l += ((Table)object).calculatedChecksum();
                treeMap.put(((Table)object).header().tag(), (Table)object);
            }
            font.checksum = l & 0xFFFFFFFFL;
            return treeMap;
        }

        private static void interRelateBuilders(Map<Integer, Table.Builder<? extends Table>> map) {
            FontHeaderTable.Builder builder = (FontHeaderTable.Builder)map.get(Tag.head);
            HorizontalHeaderTable.Builder builder2 = (HorizontalHeaderTable.Builder)map.get(Tag.hhea);
            MaximumProfileTable.Builder builder3 = (MaximumProfileTable.Builder)map.get(Tag.maxp);
            LocaTable.Builder builder4 = (LocaTable.Builder)map.get(Tag.loca);
            HorizontalMetricsTable.Builder builder5 = (HorizontalMetricsTable.Builder)map.get(Tag.hmtx);
            HorizontalDeviceMetricsTable.Builder builder6 = (HorizontalDeviceMetricsTable.Builder)map.get(Tag.hdmx);
            if (builder5 != null) {
                if (builder3 != null) {
                    builder5.setNumGlyphs(builder3.numGlyphs());
                }
                if (builder2 != null) {
                    builder5.setNumberOfHMetrics(builder2.numberOfHMetrics());
                }
            }
            if (builder4 != null) {
                if (builder3 != null) {
                    builder4.setNumGlyphs(builder3.numGlyphs());
                }
                if (builder != null) {
                    builder4.setFormatVersion(builder.indexToLocFormat());
                }
            }
            if (builder6 != null && builder3 != null) {
                builder6.setNumGlyphs(builder3.numGlyphs());
            }
        }

        private SortedSet<Header> readHeader(FontInputStream fontInputStream) throws IOException {
            TreeSet<Header> treeSet = new TreeSet<Header>(Header.COMPARATOR_BY_OFFSET);
            this.sfntVersion = fontInputStream.readFixed();
            this.numTables = fontInputStream.readUShort();
            this.searchRange = fontInputStream.readUShort();
            this.entrySelector = fontInputStream.readUShort();
            this.rangeShift = fontInputStream.readUShort();
            for (int i = 0; i < this.numTables; ++i) {
                Header header = new Header(fontInputStream.readULongAsInt(), fontInputStream.readULong(), fontInputStream.readULongAsInt(), fontInputStream.readULongAsInt());
                treeSet.add(header);
            }
            return treeSet;
        }

        private Map<Header, WritableFontData> loadTableData(SortedSet<Header> sortedSet, FontInputStream fontInputStream) throws IOException {
            HashMap<Header, WritableFontData> hashMap = new HashMap<Header, WritableFontData>(sortedSet.size());
            logger.fine("########  Reading Table Data");
            for (Header header : sortedSet) {
                fontInputStream.skip((long)header.offset() - fontInputStream.position());
                logger.finer("\t" + header);
                logger.finest("\t\tStream Position = " + Integer.toHexString((int)fontInputStream.position()));
                FontInputStream fontInputStream2 = new FontInputStream(fontInputStream, header.length());
                WritableFontData writableFontData = WritableFontData.createWritableFontData(header.length());
                writableFontData.copyFrom(fontInputStream2, header.length());
                hashMap.put(header, writableFontData);
            }
            return hashMap;
        }

        private SortedSet<Header> readHeader(ReadableFontData readableFontData, int n) {
            TreeSet<Header> treeSet = new TreeSet<Header>(Header.COMPARATOR_BY_OFFSET);
            this.sfntVersion = readableFontData.readFixed(n + Offset.sfntVersion.offset);
            this.numTables = readableFontData.readUShort(n + Offset.numTables.offset);
            this.searchRange = readableFontData.readUShort(n + Offset.searchRange.offset);
            this.entrySelector = readableFontData.readUShort(n + Offset.entrySelector.offset);
            this.rangeShift = readableFontData.readUShort(n + Offset.rangeShift.offset);
            int n2 = n + Offset.tableRecordBegin.offset;
            int n3 = 0;
            while (n3 < this.numTables) {
                Header header = new Header(readableFontData.readULongAsInt(n2 + Offset.tableTag.offset), readableFontData.readULong(n2 + Offset.tableCheckSum.offset), readableFontData.readULongAsInt(n2 + Offset.tableOffset.offset), readableFontData.readULongAsInt(n2 + Offset.tableLength.offset));
                treeSet.add(header);
                ++n3;
                n2 += Offset.tableRecordSize.offset;
            }
            return treeSet;
        }

        private Map<Header, WritableFontData> loadTableData(SortedSet<Header> sortedSet, WritableFontData writableFontData) {
            HashMap<Header, WritableFontData> hashMap = new HashMap<Header, WritableFontData>(sortedSet.size());
            logger.fine("########  Reading Table Data");
            for (Header header : sortedSet) {
                WritableFontData writableFontData2 = writableFontData.slice(header.offset(), header.length());
                hashMap.put(header, writableFontData2);
            }
            return hashMap;
        }
    }

    public static enum MacintoshEncodingId {
        Unknown(-1),
        Roman(0),
        Japanese(1),
        ChineseTraditional(2),
        Korean(3),
        Arabic(4),
        Hebrew(5),
        Greek(6),
        Russian(7),
        RSymbol(8),
        Devanagari(9),
        Gurmukhi(10),
        Gujarati(11),
        Oriya(12),
        Bengali(13),
        Tamil(14),
        Telugu(15),
        Kannada(16),
        Malayalam(17),
        Sinhalese(18),
        Burmese(19),
        Khmer(20),
        Thai(21),
        Laotian(22),
        Georgian(23),
        Armenian(24),
        ChineseSimplified(25),
        Tibetan(26),
        Mongolian(27),
        Geez(28),
        Slavic(29),
        Vietnamese(30),
        Sindhi(31),
        Uninterpreted(32);

        private final int value;

        private MacintoshEncodingId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static MacintoshEncodingId valueOf(int n) {
            for (MacintoshEncodingId macintoshEncodingId : MacintoshEncodingId.values()) {
                if (!macintoshEncodingId.equals(n)) continue;
                return macintoshEncodingId;
            }
            return Unknown;
        }
    }

    public static enum WindowsEncodingId {
        Unknown(-1),
        Symbol(0),
        UnicodeUCS2(1),
        ShiftJIS(2),
        PRC(3),
        Big5(4),
        Wansung(5),
        Johab(6),
        UnicodeUCS4(10);

        private final int value;

        private WindowsEncodingId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static WindowsEncodingId valueOf(int n) {
            for (WindowsEncodingId windowsEncodingId : WindowsEncodingId.values()) {
                if (!windowsEncodingId.equals(n)) continue;
                return windowsEncodingId;
            }
            return Unknown;
        }
    }

    public static enum UnicodeEncodingId {
        Unknown(-1),
        Unicode1_0(0),
        Unicode1_1(1),
        ISO10646(2),
        Unicode2_0_BMP(3),
        Unicode2_0(4),
        UnicodeVariationSequences(5);

        private final int value;

        private UnicodeEncodingId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static UnicodeEncodingId valueOf(int n) {
            for (UnicodeEncodingId unicodeEncodingId : UnicodeEncodingId.values()) {
                if (!unicodeEncodingId.equals(n)) continue;
                return unicodeEncodingId;
            }
            return Unknown;
        }
    }

    public static enum PlatformId {
        Unknown(-1),
        Unicode(0),
        Macintosh(1),
        ISO(2),
        Windows(3),
        Custom(4);

        private final int value;

        private PlatformId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static PlatformId valueOf(int n) {
            for (PlatformId platformId : PlatformId.values()) {
                if (!platformId.equals(n)) continue;
                return platformId;
            }
            return Unknown;
        }
    }

    private static enum Offset {
        sfntVersion(0),
        numTables(4),
        searchRange(6),
        entrySelector(8),
        rangeShift(10),
        tableRecordBegin(12),
        sfntHeaderSize(12),
        tableTag(0),
        tableCheckSum(4),
        tableOffset(8),
        tableLength(12),
        tableRecordSize(16);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

