/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sfntdump;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.PostScriptTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SfntDump {
    private boolean countSpecialGlyphs;
    private boolean dumpTableHeadersInFont;
    private boolean dumpNameList;
    private boolean dumpCmapList;
    private boolean cmapMapping;
    private boolean dumpPost;
    private boolean dumpEblc;
    private boolean dumpAllGlyphs;
    private List<String> tablesToBinaryDump = new ArrayList<String>();
    private BitSet glyphSet;
    private boolean dumpAllChars;
    private BitSet charSet;
    private CMapTable.CMapId cmapId = CMapTable.CMapId.WINDOWS_BMP;
    private FontFactory fontFactory = FontFactory.getInstance();
    private static final Pattern RANGE_PATTERN = Pattern.compile("(x?)([\\da-fA-F]{1,5})-(x?)([\\da-fA-F]{1,5})");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(x?)([\\da-fA-F]{1,5})");

    public static void main(String[] stringArray) throws IOException {
        SfntDump sfntDump = new SfntDump();
        File file = null;
        int n = 0;
        if (!(stringArray.length <= 0 || stringArray[0].equals("-h") || stringArray[0].equals("-help") || stringArray[0].equals("-?"))) {
            file = new File(stringArray[stringArray.length - 1]);
            stringArray = Arrays.copyOfRange(stringArray, 0, stringArray.length - 1);
        } else {
            SfntDump.printUsage();
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            BitSet bitSet;
            Object object = null;
            if (stringArray[i].charAt(0) == '-') {
                object = stringArray[i].substring(1);
            }
            if (object == null) continue;
            ++n;
            if (((String)object).equals("count")) {
                sfntDump.countSpecialGlyphs(true);
                continue;
            }
            if (((String)object).equals("t")) {
                if (i + 1 >= stringArray.length) continue;
                sfntDump.dumpTablesAsBinary(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("cm")) {
                if (i + 1 >= stringArray.length) continue;
                sfntDump.useCMap(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("table")) {
                sfntDump.dumpTableList(true);
                continue;
            }
            if (((String)object).startsWith("name")) {
                sfntDump.dumpNames(true);
                continue;
            }
            if (((String)object).startsWith("cmap")) {
                sfntDump.dumpCMaps(true);
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue;
                sfntDump.dumpCMaps(stringArray[++i]);
                continue;
            }
            if (((String)object).startsWith("post")) {
                sfntDump.dumpPost(true);
                continue;
            }
            if (((String)object).startsWith("eblc")) {
                sfntDump.dumpEblc(true);
                continue;
            }
            if (((String)object).equals("glyph") || ((String)object).equals("g")) {
                bitSet = null;
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) {
                    sfntDump.dumpAllGlyphs(true);
                    continue;
                }
                if (i + 1 < stringArray.length) {
                    if ((bitSet = SfntDump.parseRange(stringArray[++i])) == null) {
                        bitSet = SfntDump.parseList(stringArray[i]);
                    }
                    if (bitSet != null) {
                        sfntDump.dumpGlyphs(bitSet);
                    }
                }
                if (bitSet == null) {
                    System.out.println("glyph dump option requires a glyph range or list");
                    System.exit(0);
                }
            }
            if (((String)object).equals("char") || ((String)object).equals("c")) {
                bitSet = null;
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) {
                    sfntDump.dumpAllChars(true);
                    continue;
                }
                if (i + 1 < stringArray.length) {
                    if ((bitSet = SfntDump.parseRange(stringArray[++i])) == null) {
                        bitSet = SfntDump.parseList(stringArray[i]);
                    }
                    if (bitSet != null) {
                        sfntDump.dumpChars(bitSet);
                    }
                }
                if (bitSet == null) {
                    System.out.println("character dump option requires a glyph range or list");
                    System.exit(0);
                }
            }
            if (!((String)object).equals("all") && !((String)object).equals("a")) continue;
            sfntDump.dumpAll(true);
        }
        if (n == 0) {
            sfntDump.dumpTableList(true);
        }
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (File file2 : fileArray) {
                    if (!file2.isFile() || file2.isHidden()) continue;
                    try {
                        sfntDump.dumpFont(file2);
                        System.out.println();
                    }
                    catch (Throwable throwable) {
                        System.out.printf("Error processing file: %s\n", file2);
                    }
                }
            } else {
                try {
                    sfntDump.dumpFont(file);
                }
                catch (Throwable throwable) {
                    System.out.printf("Error processing file: %s\n", file);
                }
            }
        } else {
            SfntDump.printUsage();
            System.exit(0);
        }
    }

    private static final void printUsage() {
        System.out.println("FontDumper [-all|-a] [-table] [-t tag] [-name] [-cmap] [-g|-glyph range|list] [-c|-char range|list] [-?|-h|-help] fontfile | directory");
        System.out.println("dump information aobut the font file or all fonts in a directory");
        System.out.println("\t-all,-a\t\tdump all information");
        System.out.println("\t-table\t\tdump all table indexes");
        System.out.println("\t-t tag\t\tbinary dump the table with the tag specified if it exists in the font");
        System.out.println("\t-name\t\tdump all name entries");
        System.out.println("\t-cmap [mapping]\t\tdump all cmap subtables");
        System.out.println("\tif 'mapping' specified then dump the character to glyph mapping for the cmap(s)");
        String string = "\t-cm pid,eid\t\tuse the cmap with the given platform id and";
        String string2 = "encoding id when looking for glyphs from character ids";
        System.out.println(string + string2);
        System.out.println("\t-post\t\tdump the PostScript name table");
        System.out.println("\t-eblc\t\tdump the EBLC table - bitmap location");
        System.out.println("\t-g,-glyph\t\tdump the glyphs specified");
        System.out.println("\t-c,-char\t\tdump the characters specified using the Windows English Unicode cmap or the cmap specified with the -cm option");
        System.out.println("\trange\t\ttwo 1 to 4 digit numbers seperated by a hyphen that are optionally preceded by an x indicating hex - e.g. x12-234");
        System.out.println("\tlist\t\tone or more 1 to 4 digit numbers seperated commas that are optionally preceded by an x indicating hex - e.g. x12,234,666,x1234");
        System.out.println("\t-?,-h,-help\tprint this help information");
    }

    private static final BitSet parseRange(String string) {
        BitSet bitSet = null;
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(2), matcher.group(1).equals("") ? 10 : 16);
            int n2 = Integer.parseInt(matcher.group(4), matcher.group(3).equals("") ? 10 : 16);
            bitSet = new BitSet();
            bitSet.set(n, n2 + 1);
        }
        return bitSet;
    }

    private static final BitSet parseList(String string) {
        BitSet bitSet = null;
        String[] stringArray = string.split(",");
        if (stringArray.length == 0) {
            return null;
        }
        bitSet = new BitSet();
        for (String string2 : stringArray) {
            Matcher matcher = NUMBER_PATTERN.matcher(string2);
            if (!matcher.matches()) {
                return null;
            }
            int n = Integer.parseInt(matcher.group(2), matcher.group(1).equals("") ? 10 : 16);
            bitSet.set(n);
        }
        return bitSet;
    }

    public void countSpecialGlyphs(boolean bl) {
        this.countSpecialGlyphs = bl;
    }

    public void dumpTableList(boolean bl) {
        this.dumpTableHeadersInFont = bl;
    }

    public void dumpCMaps(boolean bl) {
        this.dumpCmapList = bl;
    }

    public void dumpCMaps(String string) {
        if (string.equals("mapping")) {
            this.cmapMapping = true;
        }
    }

    public void dumpNames(boolean bl) {
        this.dumpNameList = bl;
    }

    public void dumpPost(boolean bl) {
        this.dumpPost = bl;
    }

    public void dumpEblc(boolean bl) {
        this.dumpEblc = bl;
    }

    public void dumpAll(boolean bl) {
        this.dumpCMaps(bl);
        this.dumpNames(bl);
        this.dumpPost(bl);
        this.dumpTableList(bl);
    }

    public void dumpGlyphs(BitSet bitSet) {
        this.glyphSet = bitSet;
    }

    public void dumpAllGlyphs(boolean bl) {
        this.dumpAllGlyphs = bl;
    }

    public void dumpAllChars(boolean bl) {
        this.dumpAllChars = bl;
    }

    public void dumpChars(BitSet bitSet) {
        this.charSet = bitSet;
    }

    public void dumpTablesAsBinary(String string) {
        this.tablesToBinaryDump.add(string);
    }

    public void useCMap(String string) {
        String[] stringArray = string.split("\\D");
        this.cmapId = CMapTable.CMapId.getInstance(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpFont(File file) throws IOException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        System.out.println(file + " ============================");
        try {
            fileInputStream = new FileInputStream(file);
            Font[] fontArray = this.fontFactory.loadFonts(fileInputStream);
            for (int i = 0; i < fontArray.length; ++i) {
                Object object;
                Object object2;
                Font font = fontArray[i];
                if (fontArray.length > 1) {
                    System.out.println("\n======= TTC Entry #" + i + "\n");
                }
                if (this.dumpTableHeadersInFont) {
                    for (Map.Entry<Integer, ? extends Table> entry : font.tableMap().entrySet()) {
                        System.out.println(entry.getValue().header());
                    }
                }
                if (this.countSpecialGlyphs) {
                    this.countSpecialGlyphs(font);
                }
                if (this.dumpNameList) {
                    System.out.println("\n----- Name Tables");
                    object2 = (NameTable)font.getTable(Tag.name);
                    Iterator<NameTable.NameEntry> string = ((NameTable)object2).iterator();
                    while (string.hasNext()) {
                        object = string.next();
                        System.out.println(object);
                    }
                }
                if (this.dumpCmapList) {
                    System.out.println("\n------ CMap Tables");
                    object2 = (CMapTable)font.getTable(Tag.cmap);
                    Iterator<CMap> iterator = ((CMapTable)object2).iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        System.out.println(object);
                        if (!this.cmapMapping) continue;
                        this.dumpCMapMapping((CMap)object);
                    }
                }
                if (this.dumpPost) {
                    System.out.println("\n------ Post Table");
                    object2 = (PostScriptTable)font.getTable(Tag.post);
                    int n = ((PostScriptTable)object2).numberOfGlyphs();
                    for (int j = 0; j < n; ++j) {
                        System.out.printf("%d: %s\n", j, ((PostScriptTable)object2).glyphName(j));
                    }
                }
                if (this.dumpEblc) {
                    System.out.println("\n------ EBLC Table");
                    object2 = (EblcTable)font.getTable(Tag.EBLC);
                    System.out.println(((EblcTable)object2).toString());
                }
                if (this.tablesToBinaryDump.size() > 0) {
                    for (String string : this.tablesToBinaryDump) {
                        int n = Tag.intValue(string);
                        Object t = font.getTable(n);
                        if (t == null) continue;
                        System.out.println("\n------ Dump Data - Table = " + string + ", length = " + Integer.toHexString(((FontDataTable)t).dataLength()));
                        ReadableFontData readableFontData = ((FontDataTable)t).readFontData();
                        for (int j = 0; j < readableFontData.length(); j += 16) {
                            System.out.printf("%08x: ", j);
                            for (int k = j; k < j + 16 && k < readableFontData.length(); ++k) {
                                System.out.printf("%02x ", readableFontData.readUByte(k));
                            }
                            System.out.println();
                        }
                        System.out.println();
                    }
                }
                object2 = (LocaTable)font.getTable(Tag.loca);
                GlyphTable object32 = (GlyphTable)font.getTable(Tag.glyf);
                if (object2 == null) {
                    bl = false;
                    System.out.println("PROBLEM: font has no 'loca' table.");
                }
                if (object32 == null) {
                    bl = false;
                    System.out.println("PROBLEM: font has no 'glyf' table.");
                }
                if (bl && this.glyphSet != null) {
                    System.out.println("\n------ Glyphs");
                    int n = this.glyphSet.nextSetBit(0);
                    while (n >= 0) {
                        int n2 = ((LocaTable)object2).glyphOffset(n);
                        int n3 = ((LocaTable)object2).glyphLength(n);
                        Glyph glyph = object32.glyph(n2, n3);
                        System.out.println("glyph id = " + n);
                        if (glyph != null) {
                            System.out.println(glyph);
                        }
                        n = this.glyphSet.nextSetBit(n + 1);
                    }
                }
                if (!bl || this.charSet == null) continue;
                this.dumpChars(font, (LocaTable)object2, object32);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void dumpChars(Font font, LocaTable locaTable, GlyphTable glyphTable) {
        block5: {
            CMap cMap;
            block4: {
                CMapTable cMapTable = (CMapTable)font.getTable(Tag.cmap);
                if (cMapTable == null) {
                    System.out.println("PROBLEM: font has no 'cmap' table.");
                    return;
                }
                cMap = cMapTable.cmap(this.cmapId);
                if (cMap == null) {
                    System.out.println("PROBLEM: required cmap subtable not available.");
                    return;
                }
                System.out.println("\n=============\n" + cMap);
                if (!this.dumpAllChars) break block4;
                Iterator iterator = cMap.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    this.dumpChar(n, cMap, locaTable, glyphTable);
                }
                break block5;
            }
            if (this.charSet == null) break block5;
            System.out.println("\n------ Characters");
            int n = this.charSet.nextSetBit(0);
            while (n >= 0) {
                this.dumpChar(n, cMap, locaTable, glyphTable);
                n = this.charSet.nextSetBit(n + 1);
            }
        }
    }

    private void dumpChar(int n, CMap cMap, LocaTable locaTable, GlyphTable glyphTable) {
        int n2 = cMap.glyphId(n);
        int n3 = locaTable.glyphOffset(n2);
        int n4 = locaTable.glyphLength(n2);
        Glyph glyph = glyphTable.glyph(n3, n4);
        System.out.println("char = 0x" + Integer.toHexString(n) + ", glyph id = 0x" + Integer.toHexString(n2));
        if (glyph != null) {
            System.out.println(glyph);
        } else {
            System.out.println();
        }
    }

    private void countSpecialGlyphs(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int n = 0;
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            SimpleGlyph simpleGlyph;
            int n2;
            int n3 = locaTable.glyphOffset(i);
            Glyph glyph = glyphTable.glyph(n3, n2 = locaTable.glyphLength(i));
            if (!(glyph instanceof SimpleGlyph) || (simpleGlyph = (SimpleGlyph)glyph).numberOfContours() != 2 || simpleGlyph.numberOfPoints(0) != 1 && simpleGlyph.numberOfPoints(1) != 1) continue;
            ++n;
        }
        System.out.println("\n------ Special Glyph Count");
        System.out.println("\ttotal glyphs = " + locaTable.numGlyphs());
        System.out.println("\tspecial glyphs = " + n);
    }

    private void dumpCMapMapping(CMap cMap) {
        Iterator iterator = cMap.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            int n2 = cMap.glyphId(n);
            if (n2 == 0) continue;
            System.out.printf("%x -> %x\n", n, n2);
        }
    }
}

