/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BigGlyphMetrics;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat5
extends IndexSubTable {
    private final int imageSize;

    private IndexSubTableFormat5(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2);
        this.imageSize = this.data.readULongAsInt(EblcTable.Offset.indexSubTable5_imageSize.offset);
    }

    private static int numGlyphs(ReadableFontData readableFontData, int n) {
        int n2 = readableFontData.readULongAsInt(n + EblcTable.Offset.indexSubTable5_numGlyphs.offset);
        return n2;
    }

    public int imageSize() {
        return this.data.readULongAsInt(EblcTable.Offset.indexSubTable5_imageSize.offset);
    }

    public BigGlyphMetrics bigMetrics() {
        return new BigGlyphMetrics(this.data.slice(EblcTable.Offset.indexSubTable5_bigGlyphMetrics.offset, BigGlyphMetrics.Offset.metricsLength.offset));
    }

    @Override
    public int numGlyphs() {
        return IndexSubTableFormat5.numGlyphs(this.data, 0);
    }

    @Override
    public int glyphStartOffset(int n) {
        this.checkGlyphRange(n);
        int n2 = this.readFontData().searchUShort(EblcTable.Offset.indexSubTable5_glyphArray.offset, FontData.DataSize.USHORT.size(), this.numGlyphs(), n);
        if (n2 == -1) {
            return n2;
        }
        return n2 * this.imageSize;
    }

    @Override
    public int glyphLength(int n) {
        this.checkGlyphRange(n);
        return this.imageSize;
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat5> {
        private List<Integer> glyphArray;
        private BigGlyphMetrics.Builder metrics;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(readableFontData, n, n2, n3);
            return new Builder(readableFontData.slice(n, n4), n2, n3);
        }

        static Builder createBuilder(WritableFontData writableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(writableFontData, n, n2, n3);
            return new Builder(writableFontData.slice(n, n4), n2, n3);
        }

        private static int dataLength(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = IndexSubTableFormat5.numGlyphs(readableFontData, n);
            return EblcTable.Offset.indexSubTable5_glyphArray.offset + n4 * FontData.DataSize.USHORT.size();
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable5_builderDataSize.offset, 5);
            this.metrics = BigGlyphMetrics.Builder.createBuilder();
        }

        private Builder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData, n, n2);
        }

        private Builder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData, n, n2);
        }

        public int imageSize() {
            return this.internalReadData().readULongAsInt(EblcTable.Offset.indexSubTable5_imageSize.offset);
        }

        public void setImageSize(int n) {
            this.internalWriteData().writeULong(EblcTable.Offset.indexSubTable5_imageSize.offset, n);
        }

        public BigGlyphMetrics.Builder bigMetrics() {
            if (this.metrics == null) {
                WritableFontData writableFontData = this.internalWriteData().slice(EblcTable.Offset.indexSubTable5_bigGlyphMetrics.offset, BigGlyphMetrics.Offset.metricsLength.offset);
                this.metrics = new BigGlyphMetrics.Builder(writableFontData);
                this.setModelChanged();
            }
            return this.metrics;
        }

        @Override
        public int numGlyphs() {
            return this.getGlyphArray().size();
        }

        @Override
        public int glyphLength(int n) {
            return this.imageSize();
        }

        @Override
        public int glyphStartOffset(int n) {
            this.checkGlyphRange(n);
            List<Integer> list = this.getGlyphArray();
            int n2 = Collections.binarySearch(list, n);
            if (n2 == -1) {
                return -1;
            }
            return n2 * this.imageSize();
        }

        public List<Integer> glyphArray() {
            return this.getGlyphArray();
        }

        private List<Integer> getGlyphArray() {
            if (this.glyphArray == null) {
                this.initialize(super.internalReadData());
                super.setModelChanged();
            }
            return this.glyphArray;
        }

        private void initialize(ReadableFontData readableFontData) {
            if (this.glyphArray == null) {
                this.glyphArray = new ArrayList<Integer>();
            } else {
                this.glyphArray.clear();
            }
            if (readableFontData != null) {
                int n = IndexSubTableFormat5.numGlyphs(readableFontData, 0);
                for (int i = 0; i < n; ++i) {
                    this.glyphArray.add(readableFontData.readUShort(EblcTable.Offset.indexSubTable5_glyphArray.offset + i * FontData.DataSize.USHORT.size()));
                }
            }
        }

        public void setGlyphArray(List<Integer> list) {
            this.glyphArray = list;
            this.setModelChanged();
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected void revert() {
            super.revert();
            this.glyphArray = null;
        }

        @Override
        protected IndexSubTableFormat5 subBuildTable(ReadableFontData readableFontData) {
            return new IndexSubTableFormat5(readableFontData, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.glyphArray == null) {
                return this.internalReadData().length();
            }
            return EblcTable.Offset.indexSubTable5_builderDataSize.offset + this.glyphArray.size() * FontData.DataSize.USHORT.size();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.glyphArray != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = super.serializeIndexSubHeader(writableFontData);
            if (!this.modelChanged()) {
                n += this.internalReadData().slice(EblcTable.Offset.indexSubTable5_imageSize.offset).copyTo(writableFontData.slice(EblcTable.Offset.indexSubTable5_imageSize.offset));
            } else {
                n += writableFontData.writeULong(EblcTable.Offset.indexSubTable5_imageSize.offset, this.imageSize());
                n += this.bigMetrics().subSerialize(writableFontData.slice(n));
                n += writableFontData.writeULong(n, this.glyphArray.size());
                for (Integer n2 : this.glyphArray) {
                    n += writableFontData.writeUShort(n, n2);
                }
            }
            return n;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int offsetIndex;

            @Override
            public boolean hasNext() {
                return this.offsetIndex < Builder.this.getGlyphArray().size();
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                BitmapGlyphInfo bitmapGlyphInfo = new BitmapGlyphInfo((Integer)Builder.this.getGlyphArray().get(this.offsetIndex), Builder.this.imageDataOffset(), this.offsetIndex * Builder.this.imageSize(), Builder.this.imageSize(), Builder.this.imageFormat());
                ++this.offsetIndex;
                return bitmapGlyphInfo;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

