/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat0
extends CMap {
    protected CMapFormat0(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format0.value, cMapId);
    }

    @Override
    public int glyphId(int n) {
        if (n < 0 || n > 255) {
            return 0;
        }
        return this.data.readUByte(n + CMapTable.Offset.format0GlyphIdArray.offset);
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format0Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat0> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readUShort(n + CMapTable.Offset.format0Length.offset)), CMap.CMapFormat.Format0, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readUShort(n + CMapTable.Offset.format0Length.offset)), CMap.CMapFormat.Format0, cMapId);
        }

        @Override
        protected CMapFormat0 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat0(readableFontData, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        int character = 0;
        protected static final int MAX_CHARACTER = 255;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.character <= 255;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

