/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.ibm.icu.charset.CharsetICU;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public final class NameTable
extends SubTableContainerTable
implements Iterable<NameEntry> {
    private NameTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int format() {
        return this.data.readUShort(Offset.format.offset);
    }

    public int nameCount() {
        return this.data.readUShort(Offset.count.offset);
    }

    private int stringOffset() {
        return this.data.readUShort(Offset.stringOffset.offset);
    }

    private int offsetForNameRecord(int n) {
        return Offset.nameRecordStart.offset + n * Offset.nameRecordSize.offset;
    }

    public int platformId(int n) {
        return this.data.readUShort(Offset.nameRecordPlatformId.offset + this.offsetForNameRecord(n));
    }

    public int encodingId(int n) {
        return this.data.readUShort(Offset.nameRecordEncodingId.offset + this.offsetForNameRecord(n));
    }

    public int languageId(int n) {
        return this.data.readUShort(Offset.nameRecordLanguageId.offset + this.offsetForNameRecord(n));
    }

    public int nameId(int n) {
        return this.data.readUShort(Offset.nameRecordNameId.offset + this.offsetForNameRecord(n));
    }

    private int nameLength(int n) {
        return this.data.readUShort(Offset.nameRecordStringLength.offset + this.offsetForNameRecord(n));
    }

    private int nameOffset(int n) {
        return this.data.readUShort(Offset.nameRecordStringOffset.offset + this.offsetForNameRecord(n)) + this.stringOffset();
    }

    public byte[] nameAsBytes(int n) {
        int n2 = this.nameLength(n);
        byte[] byArray = new byte[n2];
        this.data.readBytes(this.nameOffset(n), byArray, 0, n2);
        return byArray;
    }

    public byte[] nameAsBytes(int n, int n2, int n3, int n4) {
        NameEntry nameEntry = this.nameEntry(n, n2, n3, n4);
        if (nameEntry != null) {
            return nameEntry.nameAsBytes();
        }
        return null;
    }

    public String name(int n) {
        return NameTable.convertFromNameBytes(this.nameAsBytes(n), this.platformId(n), this.encodingId(n));
    }

    public String name(int n, int n2, int n3, int n4) {
        NameEntry nameEntry = this.nameEntry(n, n2, n3, n4);
        if (nameEntry != null) {
            return nameEntry.name();
        }
        return null;
    }

    public NameEntry nameEntry(int n) {
        return new NameEntry(this.platformId(n), this.encodingId(n), this.languageId(n), this.nameId(n), this.nameAsBytes(n));
    }

    public NameEntry nameEntry(final int n, final int n2, final int n3, final int n4) {
        Iterator<NameEntry> iterator = this.iterator(new NameEntryFilter(){

            @Override
            public boolean accept(int n5, int n22, int n32, int n42) {
                return n5 == n && n22 == n2 && n32 == n3 && n42 == n4;
            }
        });
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Set<NameEntry> names() {
        HashSet<NameEntry> hashSet = new HashSet<NameEntry>(this.nameCount());
        for (NameEntry nameEntry : this) {
            hashSet.add(nameEntry);
        }
        return hashSet;
    }

    @Override
    public Iterator<NameEntry> iterator() {
        return new NameEntryIterator();
    }

    public Iterator<NameEntry> iterator(NameEntryFilter nameEntryFilter) {
        return new NameEntryIterator(nameEntryFilter);
    }

    private static String getEncodingName(int n, int n2) {
        String string = null;
        block0 : switch (Font.PlatformId.valueOf(n)) {
            case Unicode: {
                string = "UTF-16BE";
                break;
            }
            case Macintosh: {
                switch (Font.MacintoshEncodingId.valueOf(n2)) {
                    case Roman: {
                        string = "MacRoman";
                        break block0;
                    }
                    case Japanese: {
                        string = "Shift_JIS";
                        break block0;
                    }
                    case ChineseTraditional: {
                        string = "Big5";
                        break block0;
                    }
                    case Korean: {
                        string = "EUC-KR";
                        break block0;
                    }
                    case Arabic: {
                        string = "MacArabic";
                        break block0;
                    }
                    case Hebrew: {
                        string = "MacHebrew";
                        break block0;
                    }
                    case Greek: {
                        string = "MacGreek";
                        break block0;
                    }
                    case Russian: {
                        string = "MacCyrillic";
                        break block0;
                    }
                    case RSymbol: {
                        string = "MacSymbol";
                        break block0;
                    }
                    case Devanagari: {
                        break block0;
                    }
                    case Gurmukhi: {
                        break block0;
                    }
                    case Gujarati: {
                        break block0;
                    }
                    case Oriya: {
                        break block0;
                    }
                    case Bengali: {
                        break block0;
                    }
                    case Tamil: {
                        break block0;
                    }
                    case Telugu: {
                        break block0;
                    }
                    case Kannada: {
                        break block0;
                    }
                    case Malayalam: {
                        break block0;
                    }
                    case Sinhalese: {
                        break block0;
                    }
                    case Burmese: {
                        break block0;
                    }
                    case Khmer: {
                        break block0;
                    }
                    case Thai: {
                        string = "MacThai";
                        break block0;
                    }
                    case Laotian: {
                        break block0;
                    }
                    case Georgian: {
                        string = "MacCyrillic";
                        break block0;
                    }
                    case Armenian: {
                        break block0;
                    }
                    case ChineseSimplified: {
                        string = "EUC-CN";
                        break block0;
                    }
                    case Tibetan: {
                        break block0;
                    }
                    case Mongolian: {
                        string = "MacCyrillic";
                        break block0;
                    }
                    case Geez: {
                        break block0;
                    }
                    case Slavic: {
                        string = "MacCyrillic";
                        break block0;
                    }
                    case Vietnamese: {
                        break block0;
                    }
                    case Sindhi: {
                        break block0;
                    }
                }
                break;
            }
            case ISO: {
                break;
            }
            case Windows: {
                switch (Font.WindowsEncodingId.valueOf(n2)) {
                    case Symbol: {
                        string = "UTF-16BE";
                        break;
                    }
                    case UnicodeUCS2: {
                        string = "UTF-16BE";
                        break;
                    }
                    case ShiftJIS: {
                        string = "windows-933";
                        break;
                    }
                    case PRC: {
                        string = "windows-936";
                        break;
                    }
                    case Big5: {
                        string = "windows-950";
                        break;
                    }
                    case Wansung: {
                        string = "windows-949";
                        break;
                    }
                    case Johab: {
                        string = "ms1361";
                        break;
                    }
                    case UnicodeUCS4: {
                        string = "UCS-4";
                    }
                }
                break;
            }
            case Custom: {
                break;
            }
        }
        return string;
    }

    private static Charset getCharset(int n, int n2) {
        String string = NameTable.getEncodingName(n, n2);
        if (string == null) {
            return null;
        }
        Charset charset = null;
        try {
            charset = CharsetICU.forNameICU((String)string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return null;
        }
        return charset;
    }

    private static byte[] convertToNameBytes(String string, int n, int n2) {
        Charset charset = NameTable.getCharset(n, n2);
        if (charset == null) {
            return null;
        }
        ByteBuffer byteBuffer = charset.encode(string);
        return byteBuffer.array();
    }

    private static String convertFromNameBytes(byte[] byArray, int n, int n2) {
        return NameTable.convertFromNameBytes(ByteBuffer.wrap(byArray), n, n2);
    }

    private static String convertFromNameBytes(ByteBuffer byteBuffer, int n, int n2) {
        Charset charset = NameTable.getCharset(n, n2);
        if (charset == null) {
            return Integer.toHexString(n);
        }
        CharBuffer charBuffer = charset.decode(byteBuffer);
        return charBuffer.toString();
    }

    public static class Builder
    extends SubTableContainerTable.Builder<NameTable> {
        private Map<NameEntryId, NameEntryBuilder> nameEntryMap;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        private void initialize(ReadableFontData readableFontData) {
            this.nameEntryMap = new TreeMap<NameEntryId, NameEntryBuilder>();
            if (readableFontData != null) {
                NameTable nameTable = new NameTable(this.header(), readableFontData);
                for (NameEntry nameEntry : nameTable) {
                    NameEntryBuilder nameEntryBuilder = new NameEntryBuilder(nameEntry);
                    this.nameEntryMap.put(nameEntryBuilder.getNameEntryId(), nameEntryBuilder);
                }
            }
        }

        private Map<NameEntryId, NameEntryBuilder> getNameBuilders() {
            if (this.nameEntryMap == null) {
                this.initialize(super.internalReadData());
            }
            super.setModelChanged();
            return this.nameEntryMap;
        }

        public void revertNames() {
            this.nameEntryMap = null;
            this.setModelChanged(false);
        }

        public int builderCount() {
            return this.getNameBuilders().size();
        }

        public void clear() {
            this.getNameBuilders().clear();
        }

        public boolean has(int n, int n2, int n3, int n4) {
            NameEntryId nameEntryId = new NameEntryId(n, n2, n3, n4);
            return this.getNameBuilders().containsKey(nameEntryId);
        }

        public NameEntryBuilder nameBuilder(int n, int n2, int n3, int n4) {
            NameEntryId nameEntryId = new NameEntryId(n, n2, n3, n4);
            NameEntryBuilder nameEntryBuilder = this.getNameBuilders().get(nameEntryId);
            if (nameEntryBuilder == null) {
                nameEntryBuilder = new NameEntryBuilder(nameEntryId);
                this.getNameBuilders().put(nameEntryId, nameEntryBuilder);
            }
            return nameEntryBuilder;
        }

        public boolean remove(int n, int n2, int n3, int n4) {
            NameEntryId nameEntryId = new NameEntryId(n, n2, n3, n4);
            return this.getNameBuilders().remove(nameEntryId) != null;
        }

        @Override
        protected NameTable subBuildTable(ReadableFontData readableFontData) {
            return new NameTable(this.header(), readableFontData);
        }

        @Override
        protected void subDataSet() {
            this.nameEntryMap = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.nameEntryMap == null || this.nameEntryMap.size() == 0) {
                return 0;
            }
            int n = Offset.nameRecordStart.offset + this.nameEntryMap.size() * Offset.nameRecordSize.offset;
            for (Map.Entry<NameEntryId, NameEntryBuilder> entry : this.nameEntryMap.entrySet()) {
                n += entry.getValue().nameAsBytes().length;
            }
            return n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.nameEntryMap != null && this.nameEntryMap.size() != 0;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = Offset.nameRecordStart.offset + this.nameEntryMap.size() * Offset.nameRecordSize.offset;
            writableFontData.writeUShort(Offset.format.offset, 0);
            writableFontData.writeUShort(Offset.count.offset, this.nameEntryMap.size());
            writableFontData.writeUShort(Offset.stringOffset.offset, n);
            int n2 = Offset.nameRecordStart.offset;
            int n3 = 0;
            for (Map.Entry<NameEntryId, NameEntryBuilder> entry : this.nameEntryMap.entrySet()) {
                writableFontData.writeUShort(n2 + Offset.nameRecordPlatformId.offset, entry.getKey().getPlatformId());
                writableFontData.writeUShort(n2 + Offset.nameRecordEncodingId.offset, entry.getKey().getEncodingId());
                writableFontData.writeUShort(n2 + Offset.nameRecordLanguageId.offset, entry.getKey().getLanguageId());
                writableFontData.writeUShort(n2 + Offset.nameRecordNameId.offset, entry.getKey().getNameId());
                writableFontData.writeUShort(n2 + Offset.nameRecordStringLength.offset, entry.getValue().nameAsBytes().length);
                writableFontData.writeUShort(n2 + Offset.nameRecordStringOffset.offset, n3);
                n2 += Offset.nameRecordSize.offset;
                n3 += writableFontData.writeBytes(n3 + n, entry.getValue().nameAsBytes());
            }
            return n3 + n;
        }
    }

    protected class NameEntryIterator
    implements Iterator<NameEntry> {
        private int nameIndex = 0;
        private NameEntryFilter filter = null;

        private NameEntryIterator() {
        }

        private NameEntryIterator(NameEntryFilter nameEntryFilter) {
            this.filter = nameEntryFilter;
        }

        @Override
        public boolean hasNext() {
            if (this.filter == null) {
                return this.nameIndex < NameTable.this.nameCount();
            }
            while (this.nameIndex < NameTable.this.nameCount()) {
                if (this.filter.accept(NameTable.this.platformId(this.nameIndex), NameTable.this.encodingId(this.nameIndex), NameTable.this.languageId(this.nameIndex), NameTable.this.nameId(this.nameIndex))) {
                    return true;
                }
                ++this.nameIndex;
            }
            return false;
        }

        @Override
        public NameEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return NameTable.this.nameEntry(this.nameIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a CMap table from an existing font.");
        }
    }

    public static interface NameEntryFilter {
        public boolean accept(int var1, int var2, int var3, int var4);
    }

    public static class NameEntryBuilder
    extends NameEntry {
        protected NameEntryBuilder() {
        }

        protected NameEntryBuilder(NameEntryId nameEntryId, byte[] byArray) {
            super(nameEntryId, byArray);
        }

        protected NameEntryBuilder(NameEntryId nameEntryId) {
            this(nameEntryId, null);
        }

        protected NameEntryBuilder(NameEntry nameEntry) {
            this(nameEntry.getNameEntryId(), nameEntry.nameAsBytes());
        }

        public void setName(String string) {
            if (string == null) {
                this.nameBytes = new byte[0];
                return;
            }
            this.nameBytes = NameTable.convertToNameBytes(string, this.nameEntryId.getPlatformId(), this.nameEntryId.getEncodingId());
        }

        public void setName(byte[] byArray) {
            this.nameBytes = Arrays.copyOf(byArray, byArray.length);
        }

        public void setName(byte[] byArray, int n, int n2) {
            this.nameBytes = Arrays.copyOfRange(byArray, n, n + n2);
        }
    }

    public static class NameEntry {
        NameEntryId nameEntryId;
        protected int length;
        protected byte[] nameBytes;

        protected NameEntry() {
        }

        protected NameEntry(NameEntryId nameEntryId, byte[] byArray) {
            this.nameEntryId = nameEntryId;
            this.nameBytes = byArray;
        }

        protected NameEntry(int n, int n2, int n3, int n4, byte[] byArray) {
            this(new NameEntryId(n, n2, n3, n4), byArray);
        }

        protected NameEntryId getNameEntryId() {
            return this.nameEntryId;
        }

        public int platformId() {
            return this.nameEntryId.getPlatformId();
        }

        public int encodingId() {
            return this.nameEntryId.getEncodingId();
        }

        public int languageId() {
            return this.nameEntryId.getLanguageId();
        }

        public int nameId() {
            return this.nameEntryId.getNameId();
        }

        public byte[] nameAsBytes() {
            return this.nameBytes;
        }

        public String name() {
            return NameTable.convertFromNameBytes(this.nameBytes, this.platformId(), this.encodingId());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(this.nameEntryId);
            stringBuilder.append(", \"");
            String string = this.name();
            stringBuilder.append(this.name());
            stringBuilder.append("\"]");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameEntry)) {
                return false;
            }
            NameEntry nameEntry = (NameEntry)object;
            if (!this.nameEntryId.equals(nameEntry.nameEntryId)) {
                return false;
            }
            if (this.nameBytes.length != nameEntry.nameBytes.length) {
                return false;
            }
            for (int i = 0; i < this.nameBytes.length; ++i) {
                if (this.nameBytes[i] == nameEntry.nameBytes[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = this.nameEntryId.hashCode();
            for (int i = 0; i < this.nameBytes.length; i += 4) {
                for (int j = 0; j < 4 && j + i < this.nameBytes.length; ++j) {
                    n |= this.nameBytes[j] << j * 8;
                }
            }
            return n;
        }
    }

    private static class NameEntryId
    implements Comparable<NameEntryId> {
        protected int platformId;
        protected int encodingId;
        protected int languageId;
        protected int nameId;

        protected NameEntryId(int n, int n2, int n3, int n4) {
            this.platformId = n;
            this.encodingId = n2;
            this.languageId = n3;
            this.nameId = n4;
        }

        protected int getPlatformId() {
            return this.platformId;
        }

        protected int getEncodingId() {
            return this.encodingId;
        }

        protected int getLanguageId() {
            return this.languageId;
        }

        protected int getNameId() {
            return this.nameId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameEntryId)) {
                return false;
            }
            NameEntryId nameEntryId = (NameEntryId)object;
            return this.encodingId == nameEntryId.encodingId && this.languageId == nameEntryId.languageId && this.platformId == nameEntryId.platformId && this.nameId == nameEntryId.nameId;
        }

        public int hashCode() {
            return (this.encodingId & 0x3F) << 26 | (this.nameId & 0x3F) << 16 | (this.platformId & 0xF) << 12 | this.languageId & 0xFF;
        }

        @Override
        public int compareTo(NameEntryId nameEntryId) {
            if (this.platformId != nameEntryId.platformId) {
                return this.platformId - nameEntryId.platformId;
            }
            if (this.encodingId != nameEntryId.encodingId) {
                return this.encodingId - nameEntryId.encodingId;
            }
            if (this.languageId != nameEntryId.languageId) {
                return this.languageId - nameEntryId.languageId;
            }
            return this.nameId - nameEntryId.nameId;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("P=");
            stringBuilder.append((Object)Font.PlatformId.valueOf(this.platformId));
            stringBuilder.append(", E=0x");
            stringBuilder.append(Integer.toHexString(this.encodingId));
            stringBuilder.append(", L=0x");
            stringBuilder.append(Integer.toHexString(this.languageId));
            stringBuilder.append(", N=");
            NameId nameId = NameId.valueOf(this.nameId);
            if (nameId != null) {
                stringBuilder.append((Object)NameId.valueOf(this.nameId));
            } else {
                stringBuilder.append("0x");
                stringBuilder.append(Integer.toHexString(this.nameId));
            }
            return stringBuilder.toString();
        }
    }

    public static enum WindowsLanguageId {
        Unknown(-1),
        Afrikaans_SouthAfrica(1078),
        Albanian_Albania(1052),
        Alsatian_France(1156),
        Amharic_Ethiopia(1118),
        Arabic_Algeria(5121),
        Arabic_Bahrain(15361),
        Arabic_Egypt(3073),
        Arabic_Iraq(2049),
        Arabic_Jordan(11265),
        Arabic_Kuwait(13313),
        Arabic_Lebanon(12289),
        Arabic_Libya(4097),
        Arabic_Morocco(6145),
        Arabic_Oman(8193),
        Arabic_Qatar(16385),
        Arabic_SaudiArabia(1025),
        Arabic_Syria(10241),
        Arabic_Tunisia(7169),
        Arabic_UAE(14337),
        Arabic_Yemen(9217),
        Armenian_Armenia(1067),
        Assamese_India(1101),
        Azeri_Cyrillic_Azerbaijan(2092),
        Azeri_Latin_Azerbaijan(1068),
        Bashkir_Russia(1133),
        Basque_Basque(1069),
        Belarusian_Belarus(1059),
        Bengali_Bangladesh(2117),
        Bengali_India(1093),
        Bosnian_Cyrillic_BosniaAndHerzegovina(8218),
        Bosnian_Latin_BosniaAndHerzegovina(5146),
        Breton_France(1150),
        Bulgarian_Bulgaria(1026),
        Catalan_Catalan(1027),
        Chinese_HongKongSAR(3076),
        Chinese_MacaoSAR(5124),
        Chinese_PeoplesRepublicOfChina(2052),
        Chinese_Singapore(4100),
        Chinese_Taiwan(1028),
        Corsican_France(1155),
        Croatian_Croatia(1050),
        Croatian_Latin_BosniaAndHerzegovina(4122),
        Czech_CzechRepublic(1029),
        Danish_Denmark(1030),
        Dari_Afghanistan(1164),
        Divehi_Maldives(1125),
        Dutch_Belgium(2067),
        Dutch_Netherlands(1043),
        English_Australia(3081),
        English_Belize(10249),
        English_Canada(4105),
        English_Caribbean(9225),
        English_India(16393),
        English_Ireland(6153),
        English_Jamaica(8201),
        English_Malaysia(17417),
        English_NewZealand(5129),
        English_RepublicOfThePhilippines(13321),
        English_Singapore(18441),
        English_SouthAfrica(7177),
        English_TrinidadAndTobago(11273),
        English_UnitedKingdom(2057),
        English_UnitedStates(1033),
        English_Zimbabwe(12297),
        Estonian_Estonia(1061),
        Faroese_FaroeIslands(1080),
        Filipino_Philippines(1124),
        Finnish_Finland(1035),
        French_Belgium(2060),
        French_Canada(3084),
        French_France(1036),
        French_Luxembourg(5132),
        French_PrincipalityOfMonoco(6156),
        French_Switzerland(4108),
        Frisian_Netherlands(1122),
        Galician_Galician(1110),
        Georgian_Georgia(1079),
        German_Austria(3079),
        German_Germany(1031),
        German_Liechtenstein(5127),
        German_Luxembourg(4103),
        German_Switzerland(2055),
        Greek_Greece(1032),
        Greenlandic_Greenland(1135),
        Gujarati_India(1095),
        Hausa_Latin_Nigeria(1128),
        Hebrew_Israel(1037),
        Hindi_India(1081),
        Hungarian_Hungary(1038),
        Icelandic_Iceland(1039),
        Igbo_Nigeria(1136),
        Indonesian_Indonesia(1057),
        Inuktitut_Canada(1117),
        Inuktitut_Latin_Canada(2141),
        Irish_Ireland(2108),
        isiXhosa_SouthAfrica(1076),
        isiZulu_SouthAfrica(1077),
        Italian_Italy(1040),
        Italian_Switzerland(2064),
        Japanese_Japan(1041),
        Kannada_India(1099),
        Kazakh_Kazakhstan(1087),
        Khmer_Cambodia(1107),
        Kiche_Guatemala(1158),
        Kinyarwanda_Rwanda(1159),
        Kiswahili_Kenya(1089),
        Konkani_India(1111),
        Korean_Korea(1042),
        Kyrgyz_Kyrgyzstan(1088),
        Lao_LaoPDR(1108),
        Latvian_Latvia(1062),
        Lithuanian_Lithuania(1063),
        LowerSorbian_Germany(2094),
        Luxembourgish_Luxembourg(1134),
        Macedonian_FYROM_FormerYugoslavRepublicOfMacedonia(1071),
        Malay_BruneiDarussalam(2110),
        Malay_Malaysia(1086),
        Malayalam_India(1100),
        Maltese_Malta(1082),
        Maori_NewZealand(1153),
        Mapudungun_Chile(1146),
        Marathi_India(1102),
        Mohawk_Mohawk(1148),
        Mongolian_Cyrillic_Mongolia(1104),
        Mongolian_Traditional_PeoplesRepublicOfChina(2128),
        Nepali_Nepal(1121),
        Norwegian_Bokmal_Norway(1044),
        Norwegian_Nynorsk_Norway(2068),
        Occitan_France(1154),
        Oriya_India(1096),
        Pashto_Afghanistan(1123),
        Polish_Poland(1045),
        Portuguese_Brazil(1046),
        Portuguese_Portugal(2070),
        Punjabi_India(1094),
        Quechua_Bolivia(1131),
        Quechua_Ecuador(2155),
        Quechua_Peru(3179),
        Romanian_Romania(1048),
        Romansh_Switzerland(1047),
        Russian_Russia(1049),
        Sami_Inari_Finland(9275),
        Sami_Lule_Norway(4155),
        Sami_Lule_Sweden(5179),
        Sami_Northern_Finland(3131),
        Sami_Northern_Norway(1083),
        Sami_Northern_Sweden(2107),
        Sami_Skolt_Finland(8251),
        Sami_Southern_Norway(6203),
        Sami_Southern_Sweden(7227),
        Sanskrit_India(1103),
        Serbian_Cyrillic_BosniaAndHerzegovina(7194),
        Serbian_Cyrillic_Serbia(3098),
        Serbian_Latin_BosniaAndHerzegovina(6170),
        Serbian_Latin_Serbia(2074),
        SesothoSaLeboa_SouthAfrica(1132),
        Setswana_SouthAfrica(1074),
        Sinhala_SriLanka(1115),
        Slovak_Slovakia(1051),
        Slovenian_Slovenia(1060),
        Spanish_Argentina(11274),
        Spanish_Bolivia(16394),
        Spanish_Chile(13322),
        Spanish_Colombia(9226),
        Spanish_CostaRica(5130),
        Spanish_DominicanRepublic(7178),
        Spanish_Ecuador(12298),
        Spanish_ElSalvador(17418),
        Spanish_Guatemala(4106),
        Spanish_Honduras(18442),
        Spanish_Mexico(2058),
        Spanish_Nicaragua(19466),
        Spanish_Panama(6154),
        Spanish_Paraguay(15370),
        Spanish_Peru(10250),
        Spanish_PuertoRico(20490),
        Spanish_ModernSort_Spain(3082),
        Spanish_TraditionalSort_Spain(1034),
        Spanish_UnitedStates(21514),
        Spanish_Uruguay(14346),
        Spanish_Venezuela(8202),
        Sweden_Finland(2077),
        Swedish_Sweden(1053),
        Syriac_Syria(1114),
        Tajik_Cyrillic_Tajikistan(1064),
        Tamazight_Latin_Algeria(2143),
        Tamil_India(1097),
        Tatar_Russia(1092),
        Telugu_India(1098),
        Thai_Thailand(1054),
        Tibetan_PRC(1105),
        Turkish_Turkey(1055),
        Turkmen_Turkmenistan(1090),
        Uighur_PRC(1152),
        Ukrainian_Ukraine(1058),
        UpperSorbian_Germany(1070),
        Urdu_IslamicRepublicOfPakistan(1056),
        Uzbek_Cyrillic_Uzbekistan(2115),
        Uzbek_Latin_Uzbekistan(1091),
        Vietnamese_Vietnam(1066),
        Welsh_UnitedKingdom(1106),
        Wolof_Senegal(1096),
        Yakut_Russia(1157),
        Yi_PRC(1144),
        Yoruba_Nigeria(1130);

        private final int value;

        private WindowsLanguageId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static WindowsLanguageId valueOf(int n) {
            for (WindowsLanguageId windowsLanguageId : WindowsLanguageId.values()) {
                if (!windowsLanguageId.equals(n)) continue;
                return windowsLanguageId;
            }
            return Unknown;
        }
    }

    public static enum MacintoshLanguageId {
        Unknown(-1),
        English(0),
        French(1),
        German(2),
        Italian(3),
        Dutch(4),
        Swedish(5),
        Spanish(6),
        Danish(7),
        Portuguese(8),
        Norwegian(9),
        Hebrew(10),
        Japanese(11),
        Arabic(12),
        Finnish(13),
        Greek(14),
        Icelandic(15),
        Maltese(16),
        Turkish(17),
        Croatian(18),
        Chinese_Traditional(19),
        Urdu(20),
        Hindi(21),
        Thai(22),
        Korean(23),
        Lithuanian(24),
        Polish(25),
        Hungarian(26),
        Estonian(27),
        Latvian(28),
        Sami(29),
        Faroese(30),
        FarsiPersian(31),
        Russian(32),
        Chinese_Simplified(33),
        Flemish(34),
        IrishGaelic(35),
        Albanian(36),
        Romanian(37),
        Czech(38),
        Slovak(39),
        Slovenian(40),
        Yiddish(41),
        Serbian(42),
        Macedonian(43),
        Bulgarian(44),
        Ukrainian(45),
        Byelorussian(46),
        Uzbek(47),
        Kazakh(48),
        Azerbaijani_Cyrillic(49),
        Azerbaijani_Arabic(50),
        Armenian(51),
        Georgian(52),
        Moldavian(53),
        Kirghiz(54),
        Tajiki(55),
        Turkmen(56),
        Mongolian_Mongolian(57),
        Mongolian_Cyrillic(58),
        Pashto(59),
        Kurdish(60),
        Kashmiri(61),
        Sindhi(62),
        Tibetan(63),
        Nepali(64),
        Sanskrit(65),
        Marathi(66),
        Bengali(67),
        Assamese(68),
        Gujarati(69),
        Punjabi(70),
        Oriya(71),
        Malayalam(72),
        Kannada(73),
        Tamil(74),
        Telugu(75),
        Sinhalese(76),
        Burmese(77),
        Khmer(78),
        Lao(79),
        Vietnamese(80),
        Indonesian(81),
        Tagalong(82),
        Malay_Roman(83),
        Malay_Arabic(84),
        Amharic(85),
        Tigrinya(86),
        Galla(87),
        Somali(88),
        Swahili(89),
        KinyarwandaRuanda(90),
        Rundi(91),
        NyanjaChewa(92),
        Malagasy(93),
        Esperanto(94),
        Welsh(128),
        Basque(129),
        Catalan(130),
        Latin(131),
        Quenchua(132),
        Guarani(133),
        Aymara(134),
        Tatar(135),
        Uighur(136),
        Dzongkha(137),
        Javanese_Roman(138),
        Sundanese_Roman(139),
        Galician(140),
        Afrikaans(141),
        Breton(142),
        Inuktitut(143),
        ScottishGaelic(144),
        ManxGaelic(145),
        IrishGaelic_WithDotAbove(146),
        Tongan(147),
        Greek_Polytonic(148),
        Greenlandic(149),
        Azerbaijani_Roman(150);

        private final int value;

        private MacintoshLanguageId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static MacintoshLanguageId valueOf(int n) {
            for (MacintoshLanguageId macintoshLanguageId : MacintoshLanguageId.values()) {
                if (!macintoshLanguageId.equals(n)) continue;
                return macintoshLanguageId;
            }
            return Unknown;
        }
    }

    public static enum UnicodeLanguageId {
        Unknown(-1),
        All(0);

        private final int value;

        private UnicodeLanguageId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static UnicodeLanguageId valueOf(int n) {
            for (UnicodeLanguageId unicodeLanguageId : UnicodeLanguageId.values()) {
                if (!unicodeLanguageId.equals(n)) continue;
                return unicodeLanguageId;
            }
            return Unknown;
        }
    }

    public static enum NameId {
        Unknown(-1),
        CopyrightNotice(0),
        FontFamilyName(1),
        FontSubfamilyName(2),
        UniqueFontIdentifier(3),
        FullFontName(4),
        VersionString(5),
        PostscriptName(6),
        Trademark(7),
        ManufacturerName(8),
        Designer(9),
        Description(10),
        VendorURL(11),
        DesignerURL(12),
        LicenseDescription(13),
        LicenseInfoURL(14),
        Reserved15(15),
        PreferredFamily(16),
        PreferredSubfamily(17),
        CompatibleFullName(18),
        SampleText(19),
        PostscriptCID(20),
        WWSFamilyName(21),
        WWSSubfamilyName(22);

        private final int value;

        private NameId(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static NameId valueOf(int n) {
            for (NameId nameId : NameId.values()) {
                if (!nameId.equals(n)) continue;
                return nameId;
            }
            return Unknown;
        }
    }

    public static enum Offset {
        format(0),
        count(2),
        stringOffset(4),
        nameRecordStart(6),
        langTagCount(0),
        langTagRecord(2),
        nameRecordSize(12),
        nameRecordPlatformId(0),
        nameRecordEncodingId(2),
        nameRecordLanguageId(4),
        nameRecordNameId(6),
        nameRecordStringLength(8),
        nameRecordStringOffset(10);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

