/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;

public abstract class Glyph
extends SubTable {
    protected volatile boolean initialized = false;
    protected final Object initializationLock = new Object();
    private final GlyphType glyphType;
    private final int numberOfContours;

    protected Glyph(ReadableFontData readableFontData, GlyphType glyphType) {
        super(readableFontData);
        this.glyphType = glyphType;
        this.numberOfContours = this.data.length() == 0 ? 0 : this.data.readShort(GlyphTable.Offset.numberOfContours.offset);
    }

    protected Glyph(ReadableFontData readableFontData, int n, int n2, GlyphType glyphType) {
        super(readableFontData, n, n2);
        this.glyphType = glyphType;
        this.numberOfContours = this.data.length() == 0 ? 0 : this.data.readShort(GlyphTable.Offset.numberOfContours.offset);
    }

    private static GlyphType glyphType(ReadableFontData readableFontData, int n, int n2) {
        if (n2 == 0) {
            return GlyphType.Simple;
        }
        int n3 = readableFontData.readShort(n);
        if (n3 >= 0) {
            return GlyphType.Simple;
        }
        return GlyphType.Composite;
    }

    static Glyph getGlyph(GlyphTable glyphTable, ReadableFontData readableFontData, int n, int n2) {
        GlyphType glyphType = Glyph.glyphType(readableFontData, n, n2);
        if (glyphType == GlyphType.Simple) {
            return new SimpleGlyph(readableFontData, n, n2);
        }
        return new CompositeGlyph(readableFontData, n, n2);
    }

    protected abstract void initialize();

    @Override
    public int padding() {
        this.initialize();
        return super.padding();
    }

    public GlyphType glyphType() {
        return this.glyphType;
    }

    public int numberOfContours() {
        return this.numberOfContours;
    }

    public int xMin() {
        return this.data.readShort(GlyphTable.Offset.xMin.offset);
    }

    public int xMax() {
        return this.data.readShort(GlyphTable.Offset.xMax.offset);
    }

    public int yMin() {
        return this.data.readShort(GlyphTable.Offset.yMin.offset);
    }

    public int yMax() {
        return this.data.readShort(GlyphTable.Offset.yMax.offset);
    }

    public abstract int instructionSize();

    public abstract ReadableFontData instructions();

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.glyphType());
        stringBuilder.append(", contours=");
        stringBuilder.append(this.numberOfContours());
        stringBuilder.append(", [xmin=");
        stringBuilder.append(this.xMin());
        stringBuilder.append(", ymin=");
        stringBuilder.append(this.yMin());
        stringBuilder.append(", xmax=");
        stringBuilder.append(this.xMax());
        stringBuilder.append(", ymax=");
        stringBuilder.append(this.yMax());
        stringBuilder.append("]");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static abstract class Builder<T extends Glyph>
    extends SubTable.Builder<T> {
        protected int format;

        protected Builder(WritableFontData writableFontData) {
            super(writableFontData);
        }

        protected Builder(ReadableFontData readableFontData) {
            super(readableFontData);
        }

        protected Builder(WritableFontData writableFontData, int n, int n2) {
            this(writableFontData.slice(n, n2));
        }

        static Builder<? extends Glyph> getBuilder(GlyphTable.Builder builder, ReadableFontData readableFontData) {
            return Builder.getBuilder(builder, readableFontData, 0, readableFontData.length());
        }

        static Builder<? extends Glyph> getBuilder(GlyphTable.Builder builder, ReadableFontData readableFontData, int n, int n2) {
            GlyphType glyphType = Glyph.glyphType(readableFontData, n, n2);
            if (glyphType == GlyphType.Simple) {
                return new SimpleGlyph.SimpleGlyphBuilder(readableFontData, n, n2);
            }
            return new CompositeGlyph.CompositeGlyphBuilder(readableFontData, n, n2);
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return this.internalReadData().length();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return this.internalReadData().copyTo(writableFontData);
        }
    }

    public static abstract class Contour {
        protected Contour() {
        }
    }

    public static enum GlyphType {
        Simple,
        Composite;

    }
}

