/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.table.truetype.ControlValueTable;
import com.google.typography.font.tools.conversion.eot.CvtEncoder;
import com.google.typography.font.tools.conversion.eot.GlyfEncoder;
import com.google.typography.font.tools.conversion.eot.HdmxEncoder;
import com.google.typography.font.tools.conversion.eot.LzcompCompress;
import com.google.typography.font.tools.conversion.eot.MtxFontBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MtxWriter {
    private static final Set<Integer> REMOVE_TABLES = MtxWriter.createRemoveTables();

    private static Set<Integer> createRemoveTables() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(Tag.VDMX);
        hashSet.add(Tag.glyf);
        hashSet.add(Tag.cvt);
        hashSet.add(Tag.loca);
        hashSet.add(Tag.hdmx);
        hashSet.add(Tag.head);
        return Collections.unmodifiableSet(hashSet);
    }

    public byte[] compress(Font font) {
        Object object;
        Object object2;
        Map.Entry<Integer, ? extends Table> entry2;
        MtxFontBuilder mtxFontBuilder = new MtxFontBuilder();
        for (Map.Entry<Integer, ? extends Table> entry2 : font.tableMap().entrySet()) {
            object2 = entry2.getKey();
            if (REMOVE_TABLES.contains(object2)) continue;
            mtxFontBuilder.addTable((Integer)object2, ((Table)entry2.getValue()).readFontData());
        }
        FontHeaderTable fontHeaderTable = (FontHeaderTable)font.getTable(Tag.head);
        mtxFontBuilder.getHeadBuilder().initFrom(fontHeaderTable);
        entry2 = new GlyfEncoder();
        ((GlyfEncoder)((Object)entry2)).encode(font);
        mtxFontBuilder.addTableBytes(Tag.glyf, ((GlyfEncoder)((Object)entry2)).getGlyfBytes());
        mtxFontBuilder.addTable(Tag.loca, null);
        object2 = (ControlValueTable)font.getTable(Tag.cvt);
        if (object2 != null) {
            object = new CvtEncoder();
            ((CvtEncoder)object).encode((ControlValueTable)object2);
            mtxFontBuilder.addTableBytes(Tag.cvt, ((CvtEncoder)object).toByteArray());
        }
        if ((object = (HorizontalDeviceMetricsTable)font.getTable(Tag.hdmx)) != null) {
            mtxFontBuilder.addTable(Tag.hdmx, new HdmxEncoder().encode(font));
        }
        byte[] byArray = mtxFontBuilder.build();
        byte[] byArray2 = ((GlyfEncoder)((Object)entry2)).getPushBytes();
        byte[] byArray3 = ((GlyfEncoder)((Object)entry2)).getCodeBytes();
        return MtxWriter.packMtx(byArray, byArray2, byArray3);
    }

    private static void writeBE24(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n & 0xFF);
    }

    private static byte[] packMtx(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = Math.max(byArray.length, Math.max(byArray2.length, byArray3.length)) + LzcompCompress.getPreloadSize();
        byte[] byArray4 = LzcompCompress.compress(byArray);
        byte[] byArray5 = LzcompCompress.compress(byArray2);
        byte[] byArray6 = LzcompCompress.compress(byArray3);
        int n2 = 10 + byArray4.length + byArray5.length + byArray6.length;
        byte[] byArray7 = new byte[n2];
        byArray7[0] = 3;
        MtxWriter.writeBE24(byArray7, n, 1);
        int n3 = 10 + byArray4.length;
        int n4 = n3 + byArray5.length;
        MtxWriter.writeBE24(byArray7, n3, 4);
        MtxWriter.writeBE24(byArray7, n4, 7);
        System.arraycopy(byArray4, 0, byArray7, 10, byArray4.length);
        System.arraycopy(byArray5, 0, byArray7, n3, byArray5.length);
        System.arraycopy(byArray6, 0, byArray7, n4, byArray6.length);
        return byArray7;
    }
}

